//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by Fernflower decompiler)
//

package com.bcxin.rest.web.apis.utils;

import cn.hutool.core.util.StrUtil;
import io.leopard.javahost.JavaHost;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import sun.misc.BASE64Encoder;

import javax.net.ssl.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.*;

public class YZTAuthUtil {

    private static String keystorePath = "";
    private static ResourceBundle rb = ResourceBundle.getBundle("yzt_deploy", Locale.getDefault());
    static final HostnameVerifier DO_NOT_VERIFY;
    protected static KeyStore keyStore;

    private String getKeystorePath() {
        if (StrUtil.isEmpty(keystorePath)) {
            keystorePath = rb.getString("serverKeyStorePath");
        }
        return keystorePath;
    }

    public String doAuth(HttpServletRequest req, boolean isSSO) throws Exception {
        String errMsg;
        try {
            String scope = rb.getString("scope");
            String clientId = rb.getString("client_id");
            String clientSecret = rb.getString("client_secret");
            String grantType = null;

            try {
                grantType = rb.getString("grantType");
            } catch (Exception var31) {
            }

            grantType = null != grantType && !"".equals(grantType) ? grantType : "authorization_code";
            String yztUrl = null;
            String redirectUrl = null;
            if (isSSO) {
                try {
                    yztUrl = rb.getString("yzt_sso_auth_url_ip");
                } catch (Exception var30) {
                }

                if (null == yztUrl) {
                    yztUrl = rb.getString("yzt_sso_auth_url");
                }

                redirectUrl = rb.getString("yzt_sso_auth_redirect_url");
            } else {
                try {
                    yztUrl = rb.getString("yzt_cert_auth_url_ip");
                } catch (Exception var29) {
                }

                if (null == yztUrl) {
                    yztUrl = rb.getString("yzt_cert_auth_url");
                }

                redirectUrl = rb.getString("yzt_cert_auth_redirect_url");
            }

            String ignoreKeyStore = null;

            try {
                ignoreKeyStore = rb.getString("ignoreKeyStore");
            } catch (Exception var28) {
            }

            String sysTrustStorePath = System.getProperty("javax.net.ssl.trustStore");
            String trustStorePass = rb.getString("serverKeyStorePass");
            if (null == YZTAuthUtil.keyStore) {
                InputStream in = this.getClass().getClassLoader().getResourceAsStream(keystorePath);
                KeyStore keyStore = null;
                try {
                    keyStore = KeyStore.getInstance("JKS");
                    keyStore.load(in, trustStorePass.toCharArray());
                    in.close();
                } catch (Exception var27) {
                    //var27.printStackTrace();
                }
                YZTAuthUtil.keyStore = keyStore;
            }

            boolean ignore = ignoreKeyStore != null && ("true".equals(ignoreKeyStore.toLowerCase()) || "default".equals(ignoreKeyStore.toLowerCase()));
            if (!ignore && (null == sysTrustStorePath || "".equals(sysTrustStorePath) || sysTrustStorePath.indexOf("yzttrust.jks") == -1)) {
                System.setProperty("javax.net.ssl.trustStore", keystorePath);
                System.setProperty("javax.net.ssl.trustStorePassword", trustStorePass);
                System.setProperty("javax.net.ssl.trustStoreType", "JKS");
            }

            String code = req.getParameter("code");
            if (code != null && !"".equals(code.trim())) {
                String matterCode = req.getParameter("matterCode");
                if (null != matterCode && !"".equals(matterCode)) {
                    req.getSession().setAttribute("yzt_matter_code", matterCode);
                }

                try {
                    String accessTokenUrlTemp = yztUrl + "/oauth2/access_token?client_id=" + clientId + "&redirect_uri=" + URLEncoder.encode(redirectUrl, "UTF-8") + "&scope=" + scope + "&client_secret=" + clientSecret + "&grant_type=" + grantType + "&code=" + code;
                    System.out.println(accessTokenUrlTemp);
                    String accessTokenJSON = YZTAuthUtil.getAccessToken(accessTokenUrlTemp);
                    System.out.println(accessTokenJSON);
                    JSONObject jsonObj = JSONObject.fromObject(accessTokenJSON);
                    String errorCode = jsonObj.optString("error_code");
                    String errorMsg = jsonObj.optString("error_msg");
                    if (null != errorCode && !"".equals(errorCode) || null != errorMsg && !"".equals(errorMsg)) {
                        errMsg = errorMsg + "1";
                    } else {
                        String accessToken = jsonObj.optString("access_token");
                        String tokenInfoUrlTemp = yztUrl + "/oauth2/tokeninfo?access_token=" + accessToken;
                        req.getSession().setAttribute("accessToken", accessToken);
                        String info = YZTAuthUtil.getUserInfo(tokenInfoUrlTemp);
                        JSONObject userInfoJson = JSONObject.fromObject(info);
                        String error = userInfoJson.optString("error");
                        String errorDescription = userInfoJson.optString("error_description");
                        if ((null == error || "".equals(error)) && (null == errorDescription || "".equals(errorDescription))) {
                            return info;
                        }

                        errMsg = errorMsg + "2";
                    }
                } catch (Exception var32) {
                    var32.printStackTrace();
                    errMsg = "登录失败：法人一证通平台登录失败。" + var32.getMessage();
                }
            } else {
                errMsg = "登录失败：系统获取授权码信息失败。";
            }
        } catch (Exception var33) {
            errMsg = "一证通认证异常。";
            var33.printStackTrace();
        }
        throw new Exception(errMsg);
    }

    public static String getYztLoginUrl() {
        ResourceBundle e = ResourceBundle.getBundle("yzt_deploy", Locale.getDefault());
        String url = e.getString("yzt_cert_auth_url");
        String redirectUrl = e.getString("yzt_cert_auth_redirect_url");
        String client_id = e.getString("client_id");
        String scope = e.getString("scope");

        String service;
        try {
            service = e.getString("service");
        } catch (Exception var10) {
            service = "userService";
        }

        long ts = System.currentTimeMillis();

        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "utf8");
        } catch (UnsupportedEncodingException var9) {
            redirectUrl = "UrlIsError";
        }

        url = url + "/oauth2/authorize?service=" + service + "&response_type=code&client_id=" + client_id + "&scope=" + scope + "&redirect_uri=" + redirectUrl + "&ts=" + ts;
        return url;
    }

    private static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {
            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};

        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init((KeyManager[])null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        } catch (Exception var2) {
            var2.printStackTrace();
        }

    }

    public YZTAuthUtil() {
    }

    public static Object getUserInfoObjFromRequest(HttpServletRequest request) {
        Object userinfoObj = request.getAttribute("yzt_userinfo_json");
        request.removeAttribute("yzt_userinfo_json");
        if (null == userinfoObj || "".equals(userinfoObj.toString().trim())) {
            userinfoObj = request.getAttribute("yzt_sso_userinfo_json");
            request.removeAttribute("yzt_sso_userinfo_json");
        }

        return userinfoObj;
    }

    public static Object getUserInfoObjFromSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object userinfoObj = session.getAttribute("yzt_userinfo_json");
        session.removeAttribute("yzt_userinfo_json");
        if (null == userinfoObj) {
            userinfoObj = session.getAttribute("yzt_sso_userinfo_json");
            session.removeAttribute("yzt_sso_userinfo_json");
        }

        Object jsonStrObj;
        if (null == userinfoObj) {
            jsonStrObj = session.getAttribute("yzt_sso_userinfo_json_str");
            session.removeAttribute("yzt_sso_userinfo_json_str");
            if (null != jsonStrObj && !"".equals(jsonStrObj.toString())) {
                try {
                    userinfoObj = JSONObject.fromObject(jsonStrObj);
                } catch (Exception var6) {
                    var6.printStackTrace();
                    return null;
                }
            }
        }

        if (null == userinfoObj) {
            jsonStrObj = session.getAttribute("yzt_userinfo_json_str");
            session.removeAttribute("yzt_userinfo_json_str");
            if (null != jsonStrObj && !"".equals(jsonStrObj.toString())) {
                try {
                    userinfoObj = JSONObject.fromObject(jsonStrObj);
                } catch (Exception var5) {
                    var5.printStackTrace();
                    return null;
                }
            }
        }

        return userinfoObj;
    }

    public static Object getUserInfoObjFromSession(HttpSession session) {
        Object userinfoObj = session.getAttribute("yzt_userinfo_json");
        session.removeAttribute("yzt_userinfo_json");
        if (null == userinfoObj || "".equals(userinfoObj.toString().trim())) {
            userinfoObj = session.getAttribute("yzt_sso_userinfo_json");
            session.removeAttribute("yzt_sso_userinfo_json");
        }

        return userinfoObj;
    }

    public static String sign(String data) throws Exception {
        if (null != keyStore) {
            try {
                String keyStorePass = rb.getString("serverKeyStorePass");
                PrivateKey privateKey = (PrivateKey)keyStore.getKey("cn/org/bjca/yzt", keyStorePass.toCharArray());
                Signature signature = Signature.getInstance("SHA1withRSA");
                signature.initSign(privateKey);
                signature.update(data.getBytes("GBK"));
                return (new BASE64Encoder()).encode(signature.sign()).replaceAll("\n", "").replaceAll("\r\n", "").replaceAll("\r", "");
            } catch (Exception var4) {
                return "signException" + var4.getMessage();
            }
        } else {
            return "keyStoreIsNull";
        }
    }

    public static boolean informYZT(String uid, int type) {
        String amUrl = null;

        try {
            amUrl = rb.getString("yzt_sso_auth_url_ip");
        } catch (Exception var6) {
        }

        if (null == amUrl) {
            amUrl = rb.getString("yzt_sso_auth_url");
        }

        String clientSysCode = null;

        try {
            clientSysCode = rb.getString("clientSysCode");
        } catch (Exception var5) {
        }

        if (null == clientSysCode || "".equals(clientSysCode)) {
            clientSysCode = rb.getString("client_id");
        }

        return informYZT(amUrl, uid, clientSysCode, type);
    }

    public static boolean informYZT(String uid, String openFlag) {
        return informYZT(uid, 2, openFlag);
    }

    public static boolean informYZT(String uid, int type, String openFlag) {
        return openFlag != null && "true".equals(openFlag.toLowerCase()) ? true : informYZT(uid, type);
    }

    public static boolean informYZT(String amUrl, String uid, String clientSysCode, int type) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

        try {
            String rnd = sdf.format(new Date()) + getRandomString(8);
            String sig = sign("{clientSysCode:" + clientSysCode + ",uid:" + uid + ",type:" + type + ",rnd:" + rnd + "}");
            String e = amUrl.substring(0, amUrl.length() - 2);
            e = e + "idm/rest/recordApplyResult?operatorId=93ce5274575740e994a0c458488ce9db&certId=" + uid + "&state=" + type + "&sysCode=" + clientSysCode + "&rnd=" + rnd + "&sig=" + URLEncoder.encode(sig, "GBK");
            System.out.println(e);
            InputStream is = getContentByGET(e);
            String string = "";
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");

            BufferedReader in;
            String jsonObj;
            for(in = new BufferedReader(isr); (jsonObj = in.readLine()) != null; string = string + jsonObj) {
            }

            in.close();
            isr.close();
            is.close();
            JSONObject jsonObj1 = JSONObject.fromObject(string);
            if (jsonObj1.getString("state").equals("0")) {
                return true;
            }

            System.out.println(sdf.format(new Date()) + " " + jsonObj1.getString("state") + ":" + jsonObj1.getString("message") + "[" + uid + "]");
        } catch (Exception var14) {
            var14.printStackTrace();
        }

        return false;
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();

        for(int i = 0; i < length; ++i) {
            int number = random.nextInt(62);
            sb.append(str.charAt(number));
        }

        return sb.toString();
    }

    public static String resolveExtProperties(JSONObject userInfoJson, String param) {
        String extProperties = userInfoJson.optString("extProperties");
        return null != extProperties && !"".equals(extProperties) ? resolveExtProperties(extProperties, param) : "";
    }

    public static String resolveExtProperties(String extProperties, String param) {
        if (null != extProperties && !"".equals(extProperties)) {
            try {
                JSONArray e = JSONArray.fromObject(extProperties);

                for(int i = 0; i < e.size(); ++i) {
                    if (e.get(i) != null && e.get(i).toString().toUpperCase().indexOf(param.toUpperCase() + "=") == 0) {
                        return e.get(i).toString().substring(param.length() + 1);
                    }
                }
            } catch (Exception var4) {
                var4.printStackTrace();
            }

            return "";
        } else {
            return "";
        }
    }

    public static String resolveRegCodes(JSONObject userInfoJson, String param) {
        if (null == userInfoJson) {
            return "";
        } else {
            String regCodes = userInfoJson.optString("reserve3");
            if (null != regCodes && !"".equals(regCodes)) {
                String[] params = regCodes.split(";");
                String[] arr$ = params;
                int len$ = params.length;

                for(int i$ = 0; i$ < len$; ++i$) {
                    String paramTmp = arr$[i$];
                    if (paramTmp.startsWith(param + ":")) {
                        return "null".equals(paramTmp.replaceAll(param + ":", "").toLowerCase()) ? "" : paramTmp.replaceAll(param + ":", "").trim();
                    }
                }

                return "";
            } else {
                return "";
            }
        }
    }

    public static String getUserInfo(String accessTokenUrl) throws UnsupportedEncodingException {
        InputStream isrUserInfo = getContentByGET(accessTokenUrl);
        String string = "";
        if (isrUserInfo == null) {
            string = "{\"error_code\":\"502\",\"error_msg\":\"系统获取用户信息失败。\"}";
            return string;
        } else {
            InputStreamReader isr = new InputStreamReader(isrUserInfo, "UTF-8");
            BufferedReader in = new BufferedReader(isr);

            try {
                String str;
                try {
                    while((str = in.readLine()) != null) {
                        string = string + str;
                    }
                } catch (IOException var14) {
                }
            } finally {
                try {
                    in.close();
                } catch (IOException var13) {
                }

            }

            return string;
        }
    }

    public static String getAccessToken(String serviceUrl) throws UnsupportedEncodingException {
        InputStream isr = getContentByGET(serviceUrl);
        String string = "";
        if (isr == null) {
            return "{\"error_code\":\"501\",\"error_msg\":\"系统获取访问授权码信息失败。\"}";
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(isr, "UTF-8"));

            try {
                String str;
                try {
                    while((str = in.readLine()) != null) {
                        string = string + str;
                    }
                } catch (IOException var13) {
                }
            } finally {
                try {
                    in.close();
                } catch (IOException var12) {
                }

            }

            return string;
        }
    }

    public static InputStream getContentByGET(String serviceUrl) {
        InputStream is = null;

        try {
            if (serviceUrl.toLowerCase().indexOf("https") == 0) {
                HttpsURLConnection ioe = getHttpsURLConnection(serviceUrl, "GET");
                if (ioe.getResponseCode() == 200) {
                    is = ioe.getInputStream();
                } else {
                    is = getContentByPOST(serviceUrl);
                }
            } else {
                HttpURLConnection ioe1 = getURLConnection(serviceUrl, "GET");
                if (ioe1.getResponseCode() == 200) {
                    is = ioe1.getInputStream();
                } else {
                    is = getContentByPOST(serviceUrl);
                }
            }
        } catch (IOException var3) {
            var3.printStackTrace();
        }

        return is;
    }

    public static InputStream getContentByPOST(String serviceUrl) {
        InputStream is = null;

        try {
            if (serviceUrl.toLowerCase().indexOf("https") == 0) {
                HttpsURLConnection ioe = getHttpsURLConnection(serviceUrl, "POST");
                if (ioe.getResponseCode() == 200) {
                    is = ioe.getInputStream();
                }
            } else {
                HttpURLConnection ioe1 = getURLConnection(serviceUrl, "POST");
                if (ioe1.getResponseCode() == 200) {
                    is = ioe1.getInputStream();
                }
            }
        } catch (IOException var3) {
            var3.printStackTrace();
        }

        return is;
    }

    public static HttpURLConnection getURLConnection(String serviceUrl, String method) {
        HttpURLConnection connection = null;

        try {
            URL url = new URL(serviceUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setRequestMethod(method);
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setRequestProperty("contentType", "utf-8");
        } catch (IOException var4) {
            System.out.println("http连接异常， url(" + serviceUrl + ")");
            var4.printStackTrace();
        }

        return connection;
    }

    public static HttpsURLConnection getHttpsURLConnection(String serviceUrl, String method) {
        String ignoreKeyStore = null;

        try {
            ignoreKeyStore = rb.getString("ignoreKeyStore");
        } catch (Exception var8) {
        }

        boolean ignore = null != ignoreKeyStore && "true".equals(ignoreKeyStore.toLowerCase());
        if (ignore) {
            trustAllHosts();
        }

        HttpsURLConnection connection = null;

        try {
            URL url = new URL(serviceUrl);
            connection = (HttpsURLConnection)url.openConnection();
            if (ignore) {
                connection.setHostnameVerifier(DO_NOT_VERIFY);
            }

            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setRequestMethod(method);
            connection.setRequestProperty("Accept-Charset", "utf-8");
            connection.setRequestProperty("contentType", "utf-8");
        } catch (IOException var7) {
            System.out.println("https连接异常，url(" + serviceUrl + ")");
            var7.printStackTrace();
        }

        return connection;
    }

    static {
        try {
            Class.forName("io.leopard.javahost.JavaHost");
            String yztHostIp = rb.getString("yzt_host_ip");
            Map<String, String> yztHostIpMap = JSONObject.fromObject(yztHostIp);
            JavaHost.updateVirtualDns(yztHostIpMap);
        } catch (Exception var2) {
            System.out.println("JAVA DNS not SET. Exception Message: " + var2.getMessage());
        }

        DO_NOT_VERIFY = new HostnameVerifier() {
            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        keyStore = null;
    }
}
