package com.bcxin.rest.web.apis.responses;

import com.bcxin.api.interfaces.enums.DepartImPermissionType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Collection;

@ApiModel(description = "部门树实体对象")
@Data
public class ApiDepartmentTreeGetResponse {
    @ApiModelProperty("部门Id")
    private String id;
    @ApiModelProperty(value = "部门名称",allowEmptyValue = false)
    private String name;
    @ApiModelProperty(value = "父部门Id", allowEmptyValue = true)
    private String parentId;
    @ApiModelProperty(value = "显示顺序", allowEmptyValue = false,dataType = "int")
    private int displayOrder;
    private int totalMember;
    @ApiModelProperty(value = "通讯录权限", allowEmptyValue = false,example = "JustOnDepart", allowableValues = "JustOnDepart, OnDepartAndSub, JustSelf, Whole, Special")
    private DepartImPermissionType permissionType;
    private Collection<String> allowedDepartIds;
}
