package com.bcxin.rest.web.apis.controllers;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.api.interfaces.commons.OperateLogRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.operatelog.SearchOperateLogRequest;
import com.bcxin.api.interfaces.tenants.responses.OperateLogResponse;
import com.bcxin.rest.web.commons.ControllerAbstract;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * description：操作日志
 * author：linchunpeng
 * date：2023/12/14
 */
@RestController
@RequestMapping("/tenant/{organizationId}/operate/log")
@Api(value = "操作日志api", tags = "操作日志api")
public class OperateLogController extends ControllerAbstract {

    private final OperateLogRpcProvider operateLogRpcProvider;

    public OperateLogController(OperateLogRpcProvider operateLogRpcProvider) {
        this.operateLogRpcProvider = operateLogRpcProvider;
    }


    /**
     * description: 根据区域id获取监管机构树形结构
     * author: linchunpeng
     * date:  2023-05-10 9:37
     */
    @ApiOperation(value = "查询列表", response = OperateLogResponse.class)
    @PostMapping("/list")
    public ResponseEntity list(@PathVariable String organizationId, @RequestBody SearchOperateLogRequest request) {
        Pageable<OperateLogResponse> page = operateLogRpcProvider.getList(request, organizationId);
        return this.ok(page);
    }

}
