package com.bcxin.rbac.domain.v5.repository;
import com.bcxin.Infrastructures.components.CacheProvider;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.rbac.domain.components.ThirdAppMetaProvider;
import com.bcxin.rbac.domain.components.dtos.AppMetaDto;
import com.bcxin.rbac.domain.components.dtos.FunctionMetaDto;
import com.bcxin.rbac.domain.components.dtos.ModuleMetaDto;
import com.bcxin.rbac.domain.components.dtos.RoleMetaDto;
import com.bcxin.rbac.domain.v5.repository.translates.ThirdMapTranslate;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;

@Component
public class ThirdAppMetaProviderImpl implements ThirdAppMetaProvider {

    private final V5ConfigProperty configProperty;
    private final RetryProvider retryProvider;
    private final CacheProvider cacheProvider;
    private final JsonProvider jsonProvider;
    private final ThirdMapTranslate thirdMapTranslate;

    public ThirdAppMetaProviderImpl(V5ConfigProperty configProperty,
                                    RetryProvider retryProvider,
                                    CacheProvider cacheProvider,
                                    JsonProvider jsonProvider,
                                    ThirdMapTranslate thirdMapTranslate) {
        this.configProperty = configProperty;
        this.retryProvider = retryProvider;
        this.cacheProvider = cacheProvider;
        this.jsonProvider = jsonProvider;
        this.thirdMapTranslate = thirdMapTranslate;
    }

    @Override
    public Collection<AppMetaDto> getAppMetas(String organId) {
        return this.cacheProvider.get("ThirdAppMetaProviderImpl.getAppMetas", () -> {
            HttpPost httpPost = new HttpPost(this.configProperty.getAppMetaUri(organId));
            CloseableHttpResponse httpResponse = null;
            try {
                HttpResponse response = this.getHttpClient().execute(httpPost);
                String content = EntityUtils.toString(response.getEntity());
                Collection<Map> result = this.jsonProvider.toObjects(Map.class, content);
            } catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    @Override
    public Collection<RoleMetaDto> getRoleMetas(String appId) {
        return null;
    }

    @Override
    public Collection<ModuleMetaDto> getModuleMetas(String appId) {
        return null;
    }

    @Override
    public Collection<FunctionMetaDto> getFunctionMetas(String appId, String moduleId) {
        return null;
    }

    private HttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

}
