/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import com.bcxin.rbac.domain.entities.ResourceEntity;
import com.bcxin.rbac.domain.entities.SubjectEntity;
import com.bcxin.rbac.domain.entities.UserEntity;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Table(name="rbac_roles")
@Entity
public class RoleEntity
extends MetaEntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="name", length=200)
    private String name;
    @ManyToOne
    @JoinColumn(name="subject_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_role_subject_id", value=ConstraintMode.CONSTRAINT))
    private SubjectEntity subject;
    @OneToMany(cascade={CascadeType.DETACH})
    private Collection<ResourceEntity> resources;
    @OneToMany
    private Collection<UserEntity> users;
    @Embedded
    private OperatorValueType creator;

    public void change(String name) {
        this.setName(name);
    }

    public void assignResources(Collection<ResourceEntity> resources) {
        this.setResources(resources);
    }

    protected RoleEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static RoleEntity create(SubjectEntity subject, String name) {
        RoleEntity role = new RoleEntity();
        role.setSubject(subject);
        role.setId(UUIDUtil.getShortUuid());
        role.setName(name);
        return role;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SubjectEntity getSubject() {
        return this.subject;
    }

    public Collection<ResourceEntity> getResources() {
        return this.resources;
    }

    public Collection<UserEntity> getUsers() {
        return this.users;
    }

    public OperatorValueType getCreator() {
        return this.creator;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setSubject(SubjectEntity subject) {
        this.subject = subject;
    }

    protected void setResources(Collection<ResourceEntity> resources) {
        this.resources = resources;
    }

    protected void setUsers(Collection<UserEntity> users) {
        this.users = users;
    }

    protected void setCreator(OperatorValueType creator) {
        this.creator = creator;
    }
}

