/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.rbac.domain.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.rbac.domain.entities.CategoryEntity;
import com.bcxin.rbac.domain.entities.ResourceEntity;
import com.bcxin.rbac.domain.repositories.CategoryRepository;
import com.bcxin.rbac.domain.repositories.ResourceRepository;
import com.bcxin.rbac.domain.services.ResourceService;
import com.bcxin.rbac.domain.services.commands.resources.CreateResourceCommand;
import com.bcxin.rbac.domain.services.commands.resources.DeleteResourceCommand;
import com.bcxin.rbac.domain.services.commands.resources.UpdateResourceCommand;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ResourceServiceImpl
implements ResourceService {
    private final CategoryRepository categoryRepository;
    private final ResourceRepository resourceRepository;
    private final UnitWork unitWork;

    public ResourceServiceImpl(CategoryRepository categoryRepository, ResourceRepository resourceRepository, UnitWork unitWork) {
        this.categoryRepository = categoryRepository;
        this.resourceRepository = resourceRepository;
        this.unitWork = unitWork;
    }

    @Override
    public void dispatch(CreateResourceCommand command) {
        command.validate();
        Optional categoryOptional = this.categoryRepository.findById(command.getCategoryId());
        if (!categoryOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5206\u7c7b\u4fe1\u606f");
        }
        this.unitWork.executeTran(() -> {
            ResourceEntity resource = ResourceEntity.create((CategoryEntity)((Object)((Object)categoryOptional.get())), command.getCode(), command.getName(), command.getData(), command.getDataType());
            this.assignParent(resource, command.getCategoryId(), command.getParentId());
            this.resourceRepository.save((EntityAbstract)resource);
        });
    }

    @Override
    public void dispatch(UpdateResourceCommand command) {
        command.validate();
        Optional<ResourceEntity> resourceOptional = this.resourceRepository.getByCategoryAndId(command.getCategoryId(), command.getId());
        if (!resourceOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u8d44\u6e90\u4fe1\u606f");
        }
        this.unitWork.executeTran(() -> {
            ((ResourceEntity)((Object)((Object)resourceOptional.get()))).change(command.getCode(), command.getName(), command.getData(), command.getDataType());
            this.assignParent((ResourceEntity)((Object)((Object)resourceOptional.get())), command.getCategoryId(), command.getParentId());
            this.resourceRepository.save((EntityAbstract)resourceOptional.get());
        });
    }

    @Override
    public void dispatch(DeleteResourceCommand command) {
        command.validate();
        Optional<ResourceEntity> resourceOptional = this.resourceRepository.getByCategoryAndId(command.getCategoryId(), command.getId());
        if (!resourceOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u8d44\u6e90\u4fe1\u606f");
        }
        try {
            this.unitWork.executeTran(() -> this.resourceRepository.delete((EntityAbstract)resourceOptional.get()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private void assignParent(ResourceEntity resource, String categoryId, String parentId) {
        if (StringUtils.hasLength((String)parentId)) {
            Optional<ResourceEntity> selectedResourceOptional = this.resourceRepository.getByCategoryAndId(categoryId, parentId);
            if (!selectedResourceOptional.isPresent()) {
                throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7236\u8d44\u6e90\u4fe1\u606f");
            }
            resource.assignParent(selectedResourceOptional.get());
        }
    }
}

