/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.enums.AbnormalPersonnelEmployeeType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.models.CredentialModel;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.api.interfaces.tenants.requests.employees.EmployeeRequest;
import com.bcxin.tenant.domain.configs.SSOConfig;
import com.bcxin.tenant.domain.dto.AjaxResult;
import com.bcxin.tenant.domain.dto.SingleLoginUserDto;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.services.DepartmentService;
import com.bcxin.tenant.domain.services.EmployeeService;
import com.bcxin.tenant.domain.services.SingleLoginService;
import com.bcxin.tenant.domain.services.commands.CreateEmployeeRequestCommand;
import com.bcxin.tenant.domain.services.commands.DepartmentCommand;
import com.bcxin.tenant.domain.services.commands.UpdateEmployeeRequestCommand;
import com.bcxin.tenant.domain.utils.encry.AES;
import com.bcxin.tenant.domain.utils.encry.CreatRandomStr;
import com.bcxin.tenant.domain.utils.encry.Md5;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SingleLoginServiceImpl
implements SingleLoginService {
    private final Logger logger = LoggerFactory.getLogger(SingleLoginServiceImpl.class);
    private final DepartmentService departmentService;
    private final DepartmentRepository departmentRepository;
    private final EmployeeRepository employeeRepository;
    private final EmployeeService employeeService;

    public SingleLoginServiceImpl(DepartmentService departmentService, DepartmentRepository departmentRepository, EmployeeRepository employeeRepository, EmployeeService employeeService) {
        this.departmentService = departmentService;
        this.departmentRepository = departmentRepository;
        this.employeeRepository = employeeRepository;
        this.employeeService = employeeService;
    }

    private Map getParamMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("clientId", SSOConfig.getClientId());
        paramMap.put("randomStr", CreatRandomStr.CreatenNonce_str());
        paramMap.put("timeStamp", System.currentTimeMillis());
        String signTemp = CreatRandomStr.createStr(paramMap, SSOConfig.getClientSecret());
        String signStr = Md5.encoderMD5(signTemp);
        paramMap.put("signStr", signStr);
        return paramMap;
    }

    @Override
    public SingleLoginUserDto saveLoginUser(String userName) throws Exception {
        boolean isNew = false;
        String employeeId = null;
        try {
            String domainId = SSOConfig.getDomainId();
            if (StrUtil.isEmpty((CharSequence)domainId)) {
                throw new Exception("domainId\u914d\u7f6e\u9519\u8bef");
            }
            EmployeeRequest request = new EmployeeRequest();
            CredentialModel credential = new CredentialModel();
            request.setCredential(credential);
            EmployeeEntity employee = this.employeeRepository.getByIdNum(domainId, userName);
            if (employee == null) {
                isNew = true;
            }
            String urlPath = SSOConfig.getUrl() + "getjhuser";
            Map paramMap = this.getParamMap();
            paramMap.put("jh", AES.encrypt(userName, SSOConfig.getKey()));
            this.logger.error("\u6839\u636e\u8b66\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)urlPath);
            this.logger.error("\u6839\u636e\u8b66\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)paramMap));
            String reqResult = HttpUtil.post((String)urlPath, (Map)paramMap, (int)30000);
            this.logger.error("\u6839\u636e\u8b66\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f,\u8fd4\u56de\u7ed3\u679c:{}", (Object)reqResult);
            JSONObject resultJSON = JSON.parseObject((String)reqResult);
            String code = resultJSON.getString("code");
            if ("0".equals(code)) {
                String userObject = resultJSON.getString("userObject");
                JSONObject userJSON = JSON.parseObject((String)AES.decrypt(userObject, SSOConfig.getKey()));
                this.logger.error("\u6839\u636e\u8b66\u53f7\u83b7\u53d6\u7528\u6237\u4fe1\u606f,\u89e3\u5bc6\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)userJSON));
                request.setName(userJSON.getString("NAME"));
                request.setTelephone(userName);
                if (userJSON.getString("SOTHER_INFO") != null) {
                    request.setTelephone(userJSON.getString("SOTHER_INFO"));
                    credential.setType(CredentialType.PoliceNo);
                    credential.setNumber(userName);
                } else if (StrUtil.isNotEmpty((CharSequence)userJSON.getString("PID"))) {
                    credential.setType(CredentialType.IdCard);
                    credential.setNumber(userJSON.getString("PID"));
                }
                request.setDepartId(this.getPoliceDepart(userJSON.getString("SUNIT_CODE")));
                if (userJSON.getString("NSTATION_NO") == null) {
                    throw new Exception("\u8be5\u8d26\u53f7\u672a\u914d\u7f6e\u5c97\u4f4d");
                }
                String roleNo = userJSON.getString("NSTATION_NO");
                String roleName = userJSON.getString("SSTATION_NAME");
                if (isNew) {
                    employeeId = this.employeeService.dispatch(CreateEmployeeRequestCommand.create(domainId, request.getName(), request.getTelephone(), null, request.getDepartId(), OccupationType.Police, null, new Date(), request.getCredential().getType(), request.getCredential().getNumber(), AuthUtil.getCurrentOperator(), AbnormalPersonnelEmployeeType.NOT_VERIFY));
                } else {
                    employeeId = employee.getId();
                    this.employeeService.dispatch(UpdateEmployeeRequestCommand.create(domainId, employee.getId(), request.getDepartId(), employee.getHiredDate(), employee.getSuperior() == null ? null : employee.getSuperior().getId(), employee.getPosition(), employee.getPositiveDate(), null, employee.getInterview(), employee.getPersonStatus(), employee.getProbation(), employee.getPlanPositiveDate(), employee.getSalary()));
                }
                return SingleLoginUserDto.create(employeeId, request.getTelephone(), this.getPoliceRole(roleNo, roleName));
            }
            throw new Exception(resultJSON.getString("msg"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getPoliceDepart(String jgdm) throws Exception {
        DepartmentEntity department = this.departmentRepository.getByOrganIdAndCode(SSOConfig.getDomainId(), jgdm);
        if (department == null) {
            String urlPath = SSOConfig.getUrl() + "getorgcode";
            Map paramMap = this.getParamMap();
            paramMap.put("jgdm", AES.encrypt(jgdm, SSOConfig.getKey()));
            this.logger.error("\u6839\u636e\u673a\u6784\u7f16\u53f7\u83b7\u53d6\u673a\u6784\u4fe1\u606f,\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)urlPath);
            this.logger.error("\u6839\u636e\u673a\u6784\u7f16\u53f7\u83b7\u53d6\u673a\u6784\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)paramMap));
            String result = HttpUtil.post((String)urlPath, (Map)paramMap, (int)30000);
            this.logger.error("\u6839\u636e\u673a\u6784\u7f16\u53f7\u83b7\u53d6\u673a\u6784\u4fe1\u606f,\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            JSONObject resultJSON = JSON.parseObject((String)result);
            String code = resultJSON.getString("code");
            if ("0".equals(code)) {
                String dwObject = resultJSON.getString("dwObject");
                JSONObject orgJSON = JSON.parseObject((String)AES.decrypt(dwObject, SSOConfig.getKey()));
                this.logger.error("\u6839\u636e\u673a\u6784\u7f16\u53f7\u83b7\u53d6\u673a\u6784\u4fe1\u606f,\u89e3\u5bc6\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)orgJSON));
                String parentCode = orgJSON.getString("SUPUNIT_CODE");
                DepartmentCommand command = null;
                String parentId = null;
                if (StrUtil.isNotEmpty((CharSequence)parentCode)) {
                    DepartmentEntity parentDepart = this.departmentRepository.getByOrganIdAndCode(SSOConfig.getDomainId(), jgdm);
                    parentId = parentDepart == null ? this.getPoliceDepart(parentCode) : parentDepart.getId();
                } else {
                    DepartmentEntity rootDepart = this.departmentRepository.getRootByOrganId(SSOConfig.getDomainId());
                    parentId = rootDepart.getId();
                }
                command = DepartmentCommand.create(SSOConfig.getDomainId(), orgJSON.getString("ORGNAME"), parentId, jgdm);
                return this.departmentService.create(command);
            }
            throw new Exception(resultJSON.getString("msg"));
        }
        return department.getId();
    }

    private List<String> getPoliceRole(String roleNo, String roleName) throws Exception {
        ArrayList<String> roleList = new ArrayList<String>();
        String urlPath = SSOConfig.getUrl() + "getmenu";
        HashMap<String, String> menuIdMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = this.getParamMap();
        paramMap.put("zxtqxgw", AES.encrypt(roleNo, SSOConfig.getKey()));
        paramMap.put("zxtbm", AES.encrypt(SSOConfig.getZxtqxgw(), SSOConfig.getKey()));
        this.logger.error("\u83b7\u53d6\u83dc\u5355\u4fe1\u606f,\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)urlPath);
        this.logger.error("\u83b7\u53d6\u83dc\u5355\u4fe1\u606f,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)paramMap));
        String result = HttpUtil.post((String)urlPath, (Map)paramMap, (int)30000);
        this.logger.error("\u83b7\u53d6\u83dc\u5355\u4fe1\u606f,\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
        JSONObject resultJSON = JSON.parseObject((String)result);
        String code = resultJSON.getString("code");
        if ("0".equals(code)) {
            String dwObject = resultJSON.getString("menuObject");
            JSONObject menusJSON = JSON.parseObject((String)AES.decrypt(dwObject, SSOConfig.getKey()));
            this.logger.error("\u83b7\u53d6\u83dc\u5355\u4fe1\u606f,\u89e3\u5bc6\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)menusJSON));
            JSONArray menuArr = JSONArray.parseArray((String)menusJSON.getString("list"));
            this.logger.error(menusJSON.getString("list"));
            if (menuArr.size() < 1) {
                return roleList;
            }
            for (Object menuObj : menuArr) {
                JSONObject menu = JSON.parseObject((String)menuObj.toString());
                if (!StrUtil.isNotEmpty((CharSequence)menu.getString("MENU_ID"))) continue;
                menuIdMap.put(menu.getString("MENU_ID"), menu.getString("MENU_ID"));
            }
            paramMap = new HashMap<String, String>();
            paramMap.put("menuIds", (String)((Object)menuIdMap));
            paramMap.put("roleNo", roleNo);
            paramMap.put("roleName", roleName);
            this.logger.error("\u83b7\u53d6V5\u89d2\u8272,\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)(SSOConfig.getV5Url() + "/obpm/api/runtime/login/getPoliceRoles"));
            this.logger.error("\u83b7\u53d6V5\u89d2\u8272,\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(paramMap));
            result = HttpUtil.post((String)(SSOConfig.getV5Url() + "/obpm/api/runtime/login/getPoliceRoles"), paramMap, (int)30000);
            this.logger.error("\u83b7\u53d6V5\u89d2\u8272,\u8fd4\u56de\u7ed3\u679c:{}", (Object)result);
            AjaxResult ajaxResult = (AjaxResult)JSON.parseObject((String)result, AjaxResult.class);
            if (ajaxResult.isSuccessful()) {
                return (List)ajaxResult.getData();
            }
        } else {
            throw new Exception(resultJSON.getString("msg"));
        }
        return roleList;
    }

    public static void main(String[] args) {
        AjaxResult result = (AjaxResult)JSON.parseObject((String)"{\"code\":\"1\",\"data\":[\"1111\",\"2222\"],\"successful\":true}", AjaxResult.class);
        if (result.isSuccessful()) {
            List list = (List)result.getData();
            for (String s : list) {
                System.out.println(s);
            }
        }
    }
}

