/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.api.interfaces.tenants.requests.organizationType.OrganizationTypeCreateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizationType.OrganizationTypeUpdateRequest;
import com.bcxin.tenant.domain.entities.OrganizationTypeEntity;
import com.bcxin.tenant.domain.repositories.OrganizationTypeRepository;
import com.bcxin.tenant.domain.services.OrganizationTypeService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrganizationTypeServiceImpl
implements OrganizationTypeService {
    private final Logger logger = LoggerFactory.getLogger(OrganizationTypeServiceImpl.class);
    private OrganizationTypeRepository organizationTypeRepository;

    public OrganizationTypeServiceImpl(OrganizationTypeRepository organizationTypeRepository) {
        this.organizationTypeRepository = organizationTypeRepository;
    }

    @Override
    public void save(OrganizationTypeCreateRequest request) {
        TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
        if (currentUser == null) {
            throw new ForbidTenantException("\u5fc5\u987b\u6709\u4eba\u6765\u64cd\u4f5c\u79bb\u804c");
        }
        OrganizationTypeEntity tenantOrganizationTypeEntity = OrganizationTypeEntity.create(request.getName(), request.getNote(), request.getOrganizationId(), currentUser.getId(), currentUser.getId());
        this.organizationTypeRepository.save(tenantOrganizationTypeEntity);
    }

    @Override
    public void delete(long id) {
        this.organizationTypeRepository.deleteById(id);
    }

    @Override
    public void update(OrganizationTypeUpdateRequest organizationTypeUpdateRequest) {
        OrganizationTypeEntity tenantOrganizationTypeEntity = this.organizationTypeRepository.findById(organizationTypeUpdateRequest.getId());
        tenantOrganizationTypeEntity.change(organizationTypeUpdateRequest.getName(), organizationTypeUpdateRequest.getNote(), organizationTypeUpdateRequest.getOrganizationId());
        this.organizationTypeRepository.save(tenantOrganizationTypeEntity);
    }

    @Override
    public OrganizationTypeEntity findById(long id) {
        return this.organizationTypeRepository.findById(id);
    }

    @Override
    public Collection<OrganizationTypeEntity> findByOrganizationId(String organizationId) {
        return this.organizationTypeRepository.findByOrganizationId(organizationId);
    }
}

