/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.DepartImPermissionType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.RetryableTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.domain.DomainConstraint;
import com.bcxin.tenant.domain.entities.DepartmentEmployeeRelationEntity;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.ImportDataEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.enums.ImportedDataCategory;
import com.bcxin.tenant.domain.events.DepartmentCreatedEvent;
import com.bcxin.tenant.domain.events.DepartmentDeleteEvent;
import com.bcxin.tenant.domain.events.DepartmentUpdatedEvent;
import com.bcxin.tenant.domain.exceptions.TenantExceptionConverter;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.DepartmentAdminRepository;
import com.bcxin.tenant.domain.repositories.DepartmentEmployeeRelationRepository;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.ImportDataEntityRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.services.DepartmentService;
import com.bcxin.tenant.domain.services.commands.BatchAssignImPermissionCommand;
import com.bcxin.tenant.domain.services.commands.BatchDeleteDepartmentCommand;
import com.bcxin.tenant.domain.services.commands.BatchMoveDepartEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.ChangeDepartmentDisplayOrderCommand;
import com.bcxin.tenant.domain.services.commands.DeleteDepartmentCommand;
import com.bcxin.tenant.domain.services.commands.DepartmentCommand;
import com.bcxin.tenant.domain.services.commands.ImportDepartmentCommand;
import com.bcxin.tenant.domain.services.commands.results.ImportDepartmentCommandResult;
import com.bcxin.tenant.domain.snapshots.DepartImAllowedDepartSnapshot;
import com.bcxin.tenant.domain.snapshots.DepartmentImportedItemResultSnapshot;
import com.bcxin.tenant.domain.snapshots.DepartmentImportedItemSnapshot;
import com.bcxin.tenant.domain.snapshots.DepartmentImportedResultSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    private final OrganizationRepository organizationRepository;
    private final DepartmentRepository departmentRepository;
    private final DepartmentEmployeeRelationRepository departmentEmployeeRelationRepository;
    private final JsonProvider jsonProvider;
    private final UnitWork unitWork;
    private final RetryProvider retryProvider;
    private final ImportDataEntityRepository importDataEntityRepository;
    private final EventDispatcher eventDispatcher;
    private final TenantDbReader dbReader;
    private final DepartmentAdminRepository departmentAdminRepository;

    public DepartmentServiceImpl(OrganizationRepository organizationRepository, DepartmentRepository departmentRepository, DepartmentEmployeeRelationRepository departmentEmployeeRelationRepository, JsonProvider jsonProvider, UnitWork unitWork, RetryProvider retryProvider, ImportDataEntityRepository importDataEntityRepository, EventDispatcher eventDispatcher, TenantDbReader dbReader, DepartmentAdminRepository departmentAdminRepository) {
        this.organizationRepository = organizationRepository;
        this.departmentRepository = departmentRepository;
        this.departmentEmployeeRelationRepository = departmentEmployeeRelationRepository;
        this.jsonProvider = jsonProvider;
        this.unitWork = unitWork;
        this.retryProvider = retryProvider;
        this.importDataEntityRepository = importDataEntityRepository;
        this.eventDispatcher = eventDispatcher;
        this.dbReader = dbReader;
        this.departmentAdminRepository = departmentAdminRepository;
    }

    @Override
    public String create(DepartmentCommand command) {
        command.validate();
        Optional organizationOptional = this.organizationRepository.findById(command.getOrganizationId());
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException(String.format("\u7ec4\u7ec7(%s)\u65e0\u6548!", command.getOrganizationId()));
        }
        if (!StringUtils.hasLength((String)command.getParentId())) {
            throw new BadTenantException("\u7236\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<String> departIds = new ArrayList<String>();
        if (StringUtils.hasLength((String)command.getParentId())) {
            departIds.add(command.getParentId());
        }
        if (!CollectionUtils.isEmpty(command.getAllowedDepartIds())) {
            departIds.addAll(command.getAllowedDepartIds());
        }
        Collection<DepartmentEntity> existsDepartments = this.getAndValidateDepartment(command.getOrganizationId(), departIds);
        DepartmentEntity parentDepartment = existsDepartments.stream().filter(ii -> ii.getId().equalsIgnoreCase(command.getParentId())).findFirst().get();
        DepartmentEntity department = DepartmentEntity.create((OrganizationEntity)((Object)organizationOptional.get()), parentDepartment, command.getName(), command.getCode(), command.getDisplayOrder());
        DepartImAllowedDepartSnapshot snapshot = DepartImAllowedDepartSnapshot.create(command.getAllowedDepartIds());
        department.change(command.getPermissionType(), snapshot, this.jsonProvider);
        try {
            this.unitWork.executeTran(() -> {
                this.departmentRepository.save(department);
                this.eventDispatcher.dispatch((DomainEventAbstract)DepartmentCreatedEvent.create(department));
            });
            return department.getId();
        }
        catch (Exception ex) {
            if (DomainConstraint.isUniqueConstraintIssue(ex)) {
                throw new ConflictTenantException("\u8be5\u90e8\u95e8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
            }
            throw ex;
        }
    }

    @Override
    public void update(String id, DepartmentCommand command) {
        Collection<DepartmentEntity> existsDepartments;
        Optional<DepartmentEntity> departmentOptional;
        command.validate();
        if (!StringUtils.hasLength((String)id) || !StringUtils.hasLength((String)command.getOrganizationId())) {
            throw new BadTenantException("\u65e0\u6548\u6570\u636e!");
        }
        ArrayList<String> departIds = new ArrayList<String>();
        departIds.add(id);
        if (StringUtils.hasLength((String)command.getParentId())) {
            departIds.add(command.getParentId());
        }
        if (!CollectionUtils.isEmpty(command.getAllowedDepartIds())) {
            departIds.addAll(command.getAllowedDepartIds());
        }
        if (!(departmentOptional = (existsDepartments = this.getAndValidateDepartment(command.getOrganizationId(), departIds)).stream().filter(ii -> ii.getId().equalsIgnoreCase(id)).findFirst()).isPresent()) {
            throw new BadTenantException("\u5f53\u524d\u90e8\u95e8\u5df2\u88ab\u5220\u9664, \u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
        }
        DepartmentEntity department = departmentOptional.get();
        List<String> leaderEmployeeIdList = command.getLeaderEmployeeIdList();
        if (CollectionUtil.isNotEmpty(leaderEmployeeIdList) && !leaderEmployeeIdList.contains("null")) {
            List<DepartmentEmployeeRelationEntity> relationEntityList = this.departmentEmployeeRelationRepository.findListByDepartmentIdAndEmployeeIds(department.getId(), leaderEmployeeIdList);
            if (CollectionUtil.isEmpty(relationEntityList)) {
                throw new BadTenantException("\u6240\u9009\u7684\u804c\u5458\u90fd\u4e0d\u5728\u672c\u90e8\u95e8\u91cc\u9762\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8\u4e3b\u7ba1");
            }
            if (relationEntityList.size() != leaderEmployeeIdList.size()) {
                throw new BadTenantException("\u6240\u9009\u7684\u804c\u5458\uff0c\u5b58\u5728\u4e0d\u5728\u672c\u90e8\u95e8\u91cc\u9762\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8\u4e3b\u7ba1");
            }
        }
        department.change(command.getName(), command.getDisplayOrder());
        DepartImAllowedDepartSnapshot snapshot = DepartImAllowedDepartSnapshot.create(command.getAllowedDepartIds());
        department.change(command.getPermissionType(), snapshot, this.jsonProvider);
        boolean isChangeParent = false;
        String oldTree = department.getIndexTree();
        String newTree = "";
        String organizationId = command.getOrganizationId();
        if (StringUtils.hasLength((String)command.getParentId())) {
            if (!command.getParentId().equals(department.getParent().getId())) {
                isChangeParent = true;
            }
            DepartmentEntity parentDepartment = existsDepartments.stream().filter(ii -> ii.getId().equalsIgnoreCase(command.getParentId())).findFirst().get();
            department.changeSubNodeParent(parentDepartment);
            if (isChangeParent) {
                newTree = department.getIndexTree();
            }
        }
        try {
            boolean finalIsChangeParent = isChangeParent;
            String finalNewTree = newTree;
            this.unitWork.executeTran(() -> {
                this.departmentRepository.save(department);
                this.eventDispatcher.dispatch((DomainEventAbstract)DepartmentUpdatedEvent.create(department));
                if (finalIsChangeParent) {
                    this.departmentRepository.updateTreeByDepartmentIndexTree1(oldTree, finalNewTree, organizationId, oldTree.concat("%"));
                    this.departmentRepository.updateTreeByDepartmentIndexTree2(oldTree, finalNewTree, organizationId, oldTree.concat("%"));
                    this.departmentRepository.updateTreeByDepartmentIndexTree3(oldTree, finalNewTree, organizationId, oldTree.concat("%"));
                }
                if (CollectionUtil.isEmpty((Collection)leaderEmployeeIdList) || !leaderEmployeeIdList.contains("null")) {
                    this.departmentEmployeeRelationRepository.updateLeaderTypeFalseByDepartmentId(department.getId());
                    if (CollectionUtil.isNotEmpty((Collection)leaderEmployeeIdList)) {
                        this.departmentEmployeeRelationRepository.updateLeaderTypeTrueByDepartmentIdAndEmployeeIds(department.getId(), leaderEmployeeIdList);
                    }
                }
            });
        }
        catch (Exception ex) {
            if (DomainConstraint.isUniqueConstraintIssue(ex)) {
                throw new ConflictTenantException("\u8be5\u90e8\u95e8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
            }
            throw ex;
        }
    }

    @Override
    public void delete(DeleteDepartmentCommand command) {
        DepartmentEntity department = this.getDepartment(command.getId(), command.getOrganizationId(), false);
        boolean hasChildNode = false;
        if (department.getDepartmentEmployeeRelations().size() > 0 && department.getDepartmentEmployeeRelations().stream().anyMatch(ix -> !EmploymentStatus.OffJob.equals((Object)ix.getEmployee().getStatus()))) {
            hasChildNode = true;
        } else if (department.getChildren().size() > 0) {
            hasChildNode = true;
        }
        if (hasChildNode) {
            throw new NotAllowedTenantException("\u8bf7\u786e\u4fdd\u5220\u9664\u5b50\u90e8\u95e8\u6216\u8005\u6210\u5458\u4e4b\u540e, \u518d\u8fdb\u884c\u8be5\u90e8\u95e8\u7684\u5220\u9664!");
        }
        this.unitWork.executeTran(() -> {
            this.departmentRepository.deleteByIds(command.getOrganizationId(), ListUtil.toList((Object[])new String[]{department.getId()}));
            this.eventDispatcher.dispatch((DomainEventAbstract)DepartmentDeleteEvent.create(department.getId()));
        });
    }

    @Override
    public ImportDepartmentCommandResult batchImport(ImportDepartmentCommand command) {
        Optional organizationOptional = this.organizationRepository.findById(command.getOrganizationId());
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException("\u7ec4\u7ec7\u65e0\u6548!");
        }
        OrganizationEntity organization = (OrganizationEntity)((Object)organizationOptional.get());
        Collection<DepartmentEntity> wholeDepartments = this.departmentRepository.getAllByOrganId(organization.getId());
        AtomicReference result = new AtomicReference();
        this.retryProvider.execute(() -> {
            ImportDepartmentCommandResult r = this.buildChildDepartment(organization, wholeDepartments, command);
            result.set(r);
        }, 3);
        return (ImportDepartmentCommandResult)result.get();
    }

    @Override
    public void dispatch(ChangeDepartmentDisplayOrderCommand command) {
        DepartmentEntity department = this.getDepartment(command.getId(), command.getOrganizationId(), false);
        department.change(department.getName(), command.getDisplayOrder());
        this.unitWork.executeTran(() -> this.departmentRepository.save(department));
    }

    @Override
    public void dispatch(BatchAssignImPermissionCommand command) {
        command.validate();
        ArrayList<String> selectedDepartIds = new ArrayList<String>();
        selectedDepartIds.addAll(command.getDepartIds());
        if (command.getPermissionType() == DepartImPermissionType.Special) {
            selectedDepartIds.addAll(command.getAllowedDepartIds());
        }
        Collection<DepartmentEntity> allSelectedDepartments = this.departmentRepository.getByIds(command.getOrganizationId(), selectedDepartIds);
        Collection notExistsDepartIds = selectedDepartIds.stream().filter(ii -> !allSelectedDepartments.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (notExistsDepartIds.size() > 0) {
            throw new BadTenantException(String.format("\u9009\u62e9\u7684\u90e8\u95e8(%s)\u5217\u8868\u65e0\u6548", notExistsDepartIds.stream().collect(Collectors.joining(","))));
        }
        Collection departments = allSelectedDepartments.stream().filter(ii -> command.getDepartIds().stream().anyMatch(ix -> ix.equals(ii.getId()))).collect(Collectors.toList());
        DepartImAllowedDepartSnapshot snapshot = DepartImAllowedDepartSnapshot.create(command.getAllowedDepartIds());
        this.unitWork.executeTran(() -> departments.forEach(dept -> {
            dept.change(command.getPermissionType(), snapshot, this.jsonProvider);
            this.departmentRepository.save((EntityAbstract)dept);
        }));
    }

    @Override
    public void dispatch(BatchMoveDepartEmployeeCommand command) {
        if (CollectionUtils.isEmpty(command.getFromDepartIds())) {
            throw new BadTenantException("\u8981\u8f6c\u79fb\u7684\u90e8\u95e8\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (!StringUtils.hasLength((String)command.getDestDepartId())) {
            throw new BadTenantException("\u76ee\u6807\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (command.getFromDepartIds().contains(command.getDestDepartId())) {
            throw new BadTenantException("\u76ee\u6807\u90e8\u95e8\u4e0d\u80fd\u5305\u542b\u5728\u8981\u8f6c\u79fb\u7684\u6e90\u90e8\u95e8\u4e2d!");
        }
        Collection ids = command.getFromDepartIds().stream().collect(Collectors.toList());
        ids.add(command.getDestDepartId());
        Collection<DepartmentEntity> departments = this.departmentRepository.getByIds(command.getOrganizationId(), ids);
        Optional<DepartmentEntity> destOptional = departments.stream().filter(ii -> ii.getId().equals(command.getDestDepartId())).findFirst();
        if (!destOptional.isPresent()) {
            throw new NotFoundTenantException("\u8f6c\u79fb\u76ee\u6807\u90e8\u95e8\u4e0d\u5b58\u5728!", (Object)command.getDestDepartId());
        }
        Collection missedDepartIds = command.getFromDepartIds().stream().filter(ii -> !departments.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)missedDepartIds)) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u6e90\u90e8\u95e8\u4fe1\u606f", (Object)missedDepartIds);
        }
        DepartmentEntity destDepartment = destOptional.get();
        Collection sourceDepartments = departments.stream().filter(ii -> command.getFromDepartIds().contains(ii.getId())).collect(Collectors.toList());
        this.retryProvider.execute(() -> {
            try {
                this.unitWork.executeTran(() -> {
                    destDepartment.moveEmployeesFrom(sourceDepartments);
                    for (DepartmentEntity department : departments) {
                        this.departmentRepository.save(department);
                    }
                });
            }
            catch (Exception ex) {
                TenantExceptionAbstract exceptionAbstract = TenantExceptionConverter.cast(ex);
                if (exceptionAbstract instanceof ConflictTenantException) {
                    Collection<String> employeeRelationIds;
                    this.unitWork.detachAll();
                    String detailMsg = ExceptionUtil.getStackMessage((Throwable)ex);
                    if (detailMsg.contains("unique_department_employee_relation_department_id_employee_id") && (employeeRelationIds = this.dbReader.getDuplicatedEmployeeRelationIds(command.getFromDepartIds(), command.getDestDepartId())).size() > 0) {
                        this.unitWork.executeNewTran(() -> this.departmentRepository.clearDuplicatedEmployeeRelationIds(employeeRelationIds));
                        throw new RetryableTenantException("\u7528\u6237\u5df2\u7ecf\u518d\u8be5\u90e8\u95e8, \u65e0\u6cd5\u91cd\u590d\u8f6c\u79fb, \u8bf7\u8fdb\u884c\u5220\u9664", ex);
                    }
                }
                throw exceptionAbstract;
            }
        }, 2);
    }

    @Override
    public void dispatch(BatchDeleteDepartmentCommand command) {
        if (!StringUtils.hasLength((String)command.getOrganizationId())) {
            throw new BadTenantException(String.format("\u6240\u5728\u7ec4\u7ec7(%s)\u65e0\u6548!", command.getOrganizationId()));
        }
        if (CollectionUtils.isEmpty(command.getDepartIds())) {
            throw new BadTenantException("\u8981\u5220\u9664\u7684\u90e8\u95e8\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            Collection<DepartmentEntity> departmentEntities = this.departmentRepository.getByIds(command.getOrganizationId(), command.getDepartIds());
            Collection notExistsDepartIds = command.getDepartIds().stream().filter(ii -> !departmentEntities.stream().anyMatch(ix -> ix.getId().equals(ii))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)notExistsDepartIds)) {
                throw new BadTenantException(String.format("\u65e0\u6cd5\u627e\u5230\u90e8\u95e8(%s)\u4fe1\u606f, \u8bf7\u5237\u65b0\u540e\u518d\u8bd5!", notExistsDepartIds.stream().collect(Collectors.joining(";"))));
            }
            Optional<DepartmentEntity> rootDepartOptional = departmentEntities.stream().filter(ii -> ii.getLevel() == 0).findFirst();
            if (rootDepartOptional.isPresent()) {
                throw new BadTenantException(String.format("\u4e0d\u5141\u8bb8\u5220\u9664\u9876\u7ea7\u90e8\u95e8(%s)", rootDepartOptional.get().getName()));
            }
            for (DepartmentEntity department : departmentEntities) {
                if (department.getDepartmentEmployeeRelations().size() > 0 && department.getDepartmentEmployeeRelations().stream().anyMatch(ix -> ix.getEmployee() != null && !EmploymentStatus.OffJob.equals((Object)ix.getEmployee().getStatus()))) {
                    throw new NotAllowedTenantException(String.format("\u5220\u9664\u90e8\u95e8\u3010(%s)\u3011\u4e4b\u524d\uff0c\u8bf7\u5148\u786e\u4fdd\u8f6c\u79fb\u90e8\u95e8\u6210\u5458!", department.getName()));
                }
                if (department.getChildren().size() <= 0) continue;
                throw new NotAllowedTenantException(String.format("\u5220\u9664\u90e8\u95e8\u3010(%s)\u3011\u4e4b\u524d\uff0c\u8bf7\u5148\u786e\u4fdd\u8f6c\u79fb\u5176\u5b50\u90e8\u95e8\u5173\u7cfb!", department.getName()));
            }
            this.unitWork.executeTran(() -> {
                Collection departmentIds = departmentEntities.stream().map(DepartmentEntity::getId).collect(Collectors.toList());
                this.departmentRepository.clearDepartmentAdminByDepartIds(departmentIds);
                this.departmentRepository.deleteByIds(command.getOrganizationId(), departmentIds);
            });
        }
        catch (Exception ex) {
            if (ex.toString().contains("DataIntegrity")) {
                throw new BadTenantException("\u5220\u9664\u90e8\u95e8\u4e4b\u524d\uff0c\u8bf7\u5148\u786e\u4fdd\u8f6c\u79fb\u90e8\u95e8\u6210\u5458\u53ca\u5176\u5b50\u90e8\u95e8\u5173\u7cfb", ex);
            }
            if (ex instanceof TenantExceptionAbstract) {
                throw ex;
            }
            throw new BadTenantException("\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", ex);
        }
    }

    private DepartmentEntity getDepartment(String id, String organizationId, boolean isAllowedIdEmpty) {
        if (!StringUtils.hasLength((String)id)) {
            if (isAllowedIdEmpty) {
                return null;
            }
            throw new NotFoundTenantException("\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Optional departmentOptional = this.departmentRepository.findById(id);
        if (!departmentOptional.isPresent()) {
            throw new NotFoundTenantException(String.format("\u627e\u4e0d\u5230\u90e8\u95e8(%s)\u4fe1\u606f!", id));
        }
        DepartmentEntity department = (DepartmentEntity)((Object)departmentOptional.get());
        if (department.getOrganization() == null || !department.getOrganization().getId().equals(organizationId)) {
            throw new NotAllowedTenantException();
        }
        return department;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportDepartmentCommandResult buildChildDepartment(OrganizationEntity organization, Collection<DepartmentEntity> existsDepartments, ImportDepartmentCommand command) {
        List sortedChildDepartmentItems = command.getItems().stream().sorted((t1, t2) -> t1.getTreeDepth() - t2.getTreeDepth()).collect(Collectors.toList());
        ArrayList<DepartmentEntity> existsAndNewDepartments = new ArrayList<DepartmentEntity>();
        existsAndNewDepartments.addAll(existsDepartments);
        ArrayList<DepartmentImportedItemResultSnapshot> processedDetails = new ArrayList<DepartmentImportedItemResultSnapshot>();
        ArrayList<DepartmentEntity> newDepartments = new ArrayList<DepartmentEntity>();
        ImportDataEntity importDataEntity = ImportDataEntity.create(organization.getId(), command.getPath(), ImportedDataCategory.Department);
        for (DepartmentImportedItemSnapshot item : sortedChildDepartmentItems) {
            ArrayList<String> invalidLogs = new ArrayList<String>();
            try {
                DepartmentEntity matchedParentDepartment;
                if (!StringUtils.hasLength((String)item.getName())) {
                    invalidLogs.add("\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if ((matchedParentDepartment = this.getDepartmentByTreeName(existsAndNewDepartments, item.getParentTreeName())) == null) {
                    invalidLogs.add(String.format("\u7236\u90e8\u95e8(%s)\u65e0\u6548", item.getParentTreeName()));
                }
                int displayOrder = 0;
                if (StringUtils.hasLength((String)item.getDisplayOrder())) {
                    try {
                        displayOrder = Integer.parseInt(item.getDisplayOrder());
                    }
                    catch (Exception ex) {
                        invalidLogs.add("\u6392\u5e8f\u65e0\u6548");
                    }
                }
                DepartImPermissionType permissionType = null;
                try {
                    permissionType = DepartmentServiceImpl.translate2PermissionType(item.getPermissionType());
                }
                catch (Exception ex) {
                    invalidLogs.add(ex.getMessage());
                }
                if (invalidLogs.size() != 0) continue;
                DepartmentEntity newDepartment = DepartmentEntity.create(organization, matchedParentDepartment, item.getName(), null, displayOrder);
                newDepartment.change(permissionType, DepartImAllowedDepartSnapshot.create(Collections.EMPTY_LIST), this.jsonProvider);
                existsAndNewDepartments.add(newDepartment);
                newDepartments.add(newDepartment);
            }
            catch (Exception ex) {
                invalidLogs.add(ex.getMessage());
                ex.printStackTrace();
            }
            finally {
                processedDetails.add(DepartmentImportedItemResultSnapshot.create(item, invalidLogs));
                ProcessedStatus status = ProcessedStatus.Done;
                String message = "\u5bfc\u5165\u6210\u529f";
                if (!CollectionUtils.isEmpty(invalidLogs)) {
                    status = ProcessedStatus.Error;
                    message = invalidLogs.stream().collect(Collectors.joining(";"));
                }
                importDataEntity.addProcessedDataItem(this.jsonProvider.getJson((Object)item), status, message);
            }
        }
        DepartmentImportedResultSnapshot result = DepartmentImportedResultSnapshot.create(processedDetails);
        try {
            this.unitWork.executeTran(() -> {
                this.importDataEntityRepository.save(importDataEntity);
                newDepartments.forEach(di -> {
                    this.departmentRepository.save((EntityAbstract)di);
                    this.eventDispatcher.dispatch((DomainEventAbstract)DepartmentCreatedEvent.create(di));
                });
            });
        }
        catch (Exception ex) {
            newDepartments.forEach(di -> this.unitWork.detach((IAggregate)di));
            this.unitWork.detach((IAggregate)importDataEntity);
        }
        return ImportDepartmentCommandResult.create(importDataEntity.getId(), result);
    }

    private DepartmentEntity getDepartmentByTreeName(Collection<DepartmentEntity> wholeDepartments, String parentTreeName) {
        Optional<DepartmentEntity> rootOptional = wholeDepartments.stream().filter(ii -> ii.getParent() == null).findFirst();
        if (!rootOptional.isPresent()) {
            throw new BadTenantException("\u4f01\u4e1a\u90e8\u95e8\u4f53\u7cfb\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u9876\u7ea7\u90e8\u95e8\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        DepartmentEntity root = rootOptional.get();
        if (!StringUtils.hasLength((String)parentTreeName)) {
            return root;
        }
        Optional<DepartmentEntity> matchedDepartmentOptional = wholeDepartments.stream().filter(ii -> {
            boolean flag = parentTreeName.equalsIgnoreCase(ii.getName()) || parentTreeName.endsWith(String.format("/%s", ii.getName()));
            return flag;
        }).findFirst();
        if (!matchedDepartmentOptional.isPresent()) {
            throw new BadTenantException(String.format("\u627e\u4e0d\u5230\u7236\u90e8\u95e8(%s)\u4fe1\u606f(\u7531\u4e8e\u6570\u636e\u6743\u9650\u95ee\u9898, \u6709\u53ef\u80fd\u4f60\u65e0\u6cd5\u770b\u5230\u9876\u7ea7\u90e8\u95e8, \u56e0\u6b64\u5bfc\u81f4\u8be5\u9519\u8bef)", parentTreeName));
        }
        DepartmentEntity matchedDepartment = matchedDepartmentOptional.get();
        StringBuilder fullPathName = new StringBuilder();
        int index = 0;
        for (DepartmentEntity loopDepartment = matchedDepartment; loopDepartment != null; loopDepartment = loopDepartment.getParent()) {
            if (index > 0) {
                fullPathName.insert(0, "/");
            }
            fullPathName.insert(0, loopDepartment.getName());
            ++index;
        }
        if (!fullPathName.toString().equals(parentTreeName)) {
            throw new BadTenantException(String.format("\u627e\u4e0d\u5230\u7236\u90e8\u95e8(%s)\u4fe1\u606f", parentTreeName));
        }
        return matchedDepartment;
    }

    private String getDepartmentTreeName(DepartmentEntity department) {
        if (department == null) {
            return null;
        }
        if (department.getParent() == null) {
            return department.getName();
        }
        return String.format("%s/%s", this.getDepartmentTreeName(department.getParent()), department.getName());
    }

    private Collection<DepartmentEntity> getAndValidateDepartment(String organizationId, Collection<String> selectedDepartIds) {
        ArrayList<String> departIds = new ArrayList<String>();
        if (selectedDepartIds != null) {
            departIds.addAll(selectedDepartIds);
        }
        if (CollectionUtils.isEmpty(departIds)) {
            return Collections.EMPTY_LIST;
        }
        Collection<DepartmentEntity> departmentEntities = this.departmentRepository.getByIds(organizationId, departIds);
        Collection invalidDepartIds = departIds.stream().filter(ii -> !departmentEntities.stream().anyMatch(ix -> ix.getId().equalsIgnoreCase((String)ii))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)invalidDepartIds)) {
            throw new ArgumentTenantException(String.format("\u9009\u62e9\u7684\u90e8\u95e8(%s)\u4fe1\u606f\u4e0d\u5b58\u5728", invalidDepartIds.stream().collect(Collectors.joining(","))));
        }
        return departmentEntities;
    }

    private static DepartImPermissionType translate2PermissionType(String permissionText) {
        if (!StringUtils.hasLength((String)permissionText)) {
            return DepartImPermissionType.JustOnDepart;
        }
        switch (permissionText = permissionText.replace(" ", "")) {
            case "\u53ef\u89c1\u6240\u5728\u90e8\u95e8\u6210\u5458": {
                return DepartImPermissionType.JustOnDepart;
            }
            case "\u53ef\u89c1\u6240\u5728\u90e8\u95e8\u53ca\u4e0b\u7ea7\u90e8\u95e8\u6210\u5458": {
                return DepartImPermissionType.OnDepartAndSub;
            }
            case "\u53ef\u89c1\u81ea\u5df1": {
                return DepartImPermissionType.JustSelf;
            }
            case "\u53ef\u89c1\u5168\u90e8\u6210\u5458": {
                return DepartImPermissionType.Whole;
            }
            case "\u53ef\u89c1\u6307\u5b9a\u90e8\u95e8": {
                return DepartImPermissionType.Special;
            }
        }
        throw new BadTenantException(String.format("\u90e8\u95e8\u6210\u5458\u901a\u8baf\u5f55\u6743\u9650\u914d\u7f6e(%s)\u4fe1\u606f\u65e0\u6548", permissionText));
    }
}

