/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.organizations;

import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import com.bcxin.tenant.domain.services.commands.organizations.ItemValueCommandItem;
import org.apache.commons.lang3.StringUtils;

public class LocationCommandItem {
    private final ItemValueCommandItem province;
    private final ItemValueCommandItem city;
    private final ItemValueCommandItem district;
    private final String address;
    private static final LocationCommandItem emptyValue = new LocationCommandItem(ItemValueCommandItem.createEmpty(), ItemValueCommandItem.createEmpty(), ItemValueCommandItem.createEmpty(), null);

    public LocationCommandItem(ItemValueCommandItem province, ItemValueCommandItem city, ItemValueCommandItem district, String address) {
        this.province = province;
        this.city = city;
        this.district = district;
        this.address = address;
    }

    public static LocationCommandItem create(ItemValueCommandItem province, ItemValueCommandItem city, ItemValueCommandItem district, String address) {
        return new LocationCommandItem(province, city, district, address);
    }

    public static LocationCommandItem create(LocationRequest locationRequest) {
        if (locationRequest != null && locationRequest.getProvince() != null && locationRequest.getCity() != null && locationRequest.getDistrict() != null) {
            return new LocationCommandItem(ItemValueCommandItem.create(locationRequest.getProvince().getCode(), locationRequest.getProvince().getName()), ItemValueCommandItem.create(locationRequest.getCity().getCode(), locationRequest.getCity().getName()), ItemValueCommandItem.create(locationRequest.getDistrict().getCode(), locationRequest.getDistrict().getName()), locationRequest.getAddress());
        }
        return null;
    }

    public static LocationCommandItem createEmpty() {
        return emptyValue;
    }

    public String getRegionCode() {
        if (this.getProvince() == null || StringUtils.isBlank((CharSequence)this.getProvince().getCode())) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.getProvince().getCode());
        if (this.getCity() != null && StringUtils.isNotBlank((CharSequence)this.getCity().getCode())) {
            sb.append(this.getCity().getCode());
        }
        if (this.getDistrict() != null && StringUtils.isNotBlank((CharSequence)this.getDistrict().getCode())) {
            sb.append(this.getDistrict().getCode());
        }
        return sb.toString();
    }

    public ItemValueCommandItem getProvince() {
        return this.province;
    }

    public ItemValueCommandItem getCity() {
        return this.city;
    }

    public ItemValueCommandItem getDistrict() {
        return this.district;
    }

    public String getAddress() {
        return this.address;
    }
}

