/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.organizationAdmins;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class DeleteOrganizationAdminCommand
extends CommandAbstract {
    private final Collection<String> ids;
    private final String organizationId;

    public DeleteOrganizationAdminCommand(String organizationId, Collection<String> ids) {
        this.ids = ids;
        this.organizationId = organizationId;
    }

    public static DeleteOrganizationAdminCommand create(String organizationId, Collection<String> ids) {
        return new DeleteOrganizationAdminCommand(organizationId, ids);
    }

    public void validate() {
        if (CollectionUtils.isEmpty(this.getIds())) {
            throw new ArgumentTenantException("\u8981\u5220\u9664\u7684\u7ec4\u7ec7\u7ba1\u7406\u5458\u4e0d\u80fd\u4e3a\u7a7a");
        }
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (userModel == null) {
            throw new BadTenantException("\u5f53\u524d\u4e0a\u4e0b\u6587\u65e0\u6548, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (this.getIds().contains(userModel.getEmployeeId())) {
            throw new NotAllowedTenantException("\u7ec4\u7ec7\u7ba1\u7406\u5458\u4e0d\u80fd\u5220\u9664\u81ea\u5df1");
        }
    }

    public Collection<String> getIds() {
        return this.ids;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }
}

