/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.tenant.domain.snapshots.EmployeeLeaveExcelItemSnapshot;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchLeaveEmployeeExcelCommand
extends CommandAbstract {
    private final String organizationId;
    private final String path;
    private final Collection<EmployeeCommandItem> commandItems;
    private final Set<String> treeCodes;

    public BatchLeaveEmployeeExcelCommand(String organizationId, String path, Collection<EmployeeCommandItem> commandItems, Set<String> treeCodes) {
        this.organizationId = organizationId;
        this.path = path;
        this.commandItems = commandItems;
        this.treeCodes = treeCodes;
    }

    public static BatchLeaveEmployeeExcelCommand create(String organizationId, String path, Collection<EmployeeCommandItem> commandItems, Set<String> treeCodes) {
        return new BatchLeaveEmployeeExcelCommand(organizationId, path, commandItems, treeCodes);
    }

    public void validate() {
        if (CollectionUtils.isEmpty(this.commandItems)) {
            throw new ArgumentTenantException("\u5f85\u79bb\u804c\u7684\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.commandItems.forEach(ix -> {
            try {
                ix.validate();
            }
            catch (TenantExceptionAbstract ex) {
                ix.addError(ex.getMessage());
            }
        });
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getPath() {
        return this.path;
    }

    public Collection<EmployeeCommandItem> getCommandItems() {
        return this.commandItems;
    }

    public Set<String> getTreeCodes() {
        return this.treeCodes;
    }

    public static class EmployeeCommandItem
    extends CommandAbstract {
        private final EmployeeLeaveExcelItemSnapshot dataItem;

        public EmployeeCommandItem(EmployeeLeaveExcelItemSnapshot dataItem) {
            this.dataItem = dataItem;
        }

        public static EmployeeCommandItem create(int paramIndex, String name, String idNum, String leaveDate, String remark) {
            return new EmployeeCommandItem(new EmployeeLeaveExcelItemSnapshot(paramIndex, name, idNum, leaveDate, remark));
        }

        public static EmployeeCommandItem create(EmployeeLeaveExcelItemSnapshot snapshot) {
            return new EmployeeCommandItem(snapshot);
        }

        public void validate() {
            super.validate();
            this.checkParameter(() -> {
                if (StringUtils.hasLength((String)this.getDataItem().getErrMsg())) {
                    throw new ArgumentTenantException(this.getDataItem().getErrMsg());
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getDataItem().getName())) {
                    throw new ArgumentTenantException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getDataItem().getIdNum())) {
                    throw new ArgumentTenantException("\u8bc1\u4ef6\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (Objects.isNull(this.getDataItem().getLeaveDateText())) {
                    throw new ArgumentTenantException("\u79bb\u804c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (DateUtil.fromString((String)this.getDataItem().getLeaveDateText()) == null) {
                    throw new ArgumentTenantException("\u79bb\u804c\u65e5\u671f\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42");
                }
                this.getDataItem().setLeaveDate(DateUtil.fromString((String)this.getDataItem().getLeaveDateText()));
            });
            this.checkParameter(() -> {
                if (!DateUtil.format2ShortDate().equals(DateUtil.format2ShortDate((Date)this.getDataItem().getLeaveDate()))) {
                    throw new ArgumentTenantException("\u79bb\u804c\u65e5\u671f\u5fc5\u987b\u662f\u5f53\u5929");
                }
            });
        }

        public String toString() {
            return String.format("\u59d3\u540d=%s;\u8bc1\u4ef6\u53f7=%s;\u79bb\u804c\u65e5\u671f=%s;\u7ed3\u679c=%s;", this.dataItem.getName(), this.dataItem.getIdNum(), this.dataItem.getLeaveDate(), this.getErrorResult());
        }

        public EmployeeLeaveExcelItemSnapshot getDataItem() {
            return this.dataItem;
        }
    }
}

