/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.DateUtil;
import java.util.Collection;
import java.util.Date;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchLeaveEmployeeCommand
extends CommandAbstract {
    private final Collection<String> ids;
    private final String organizationId;
    private final Date expectedDate;
    private final String note;

    public BatchLeaveEmployeeCommand(Collection<String> ids, String organizationId, Date expectedDate, String note) {
        this.ids = ids;
        this.organizationId = organizationId;
        this.expectedDate = expectedDate;
        this.note = note;
    }

    public void validate() {
        super.validate();
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new BadTenantException("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(this.getIds())) {
            throw new BadTenantException("\u804c\u5458ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.getExpectedDate() == null) {
            throw new BadTenantException("\u79bb\u804c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getNote())) {
            throw new BadTenantException("\u79bb\u804c\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!DateUtil.format2ShortDate().equals(DateUtil.format2ShortDate((Date)this.getExpectedDate()))) {
            throw new BadTenantException("\u79bb\u804c\u65e5\u671f\u5fc5\u987b\u662f\u5f53\u5929");
        }
    }

    public static BatchLeaveEmployeeCommand create(Collection<String> ids, String organizationId, Date expectedDate, String note) {
        return new BatchLeaveEmployeeCommand(ids, organizationId, expectedDate, note);
    }

    public Collection<String> getIds() {
        return this.ids;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Date getExpectedDate() {
        return this.expectedDate;
    }

    public String getNote() {
        return this.note;
    }
}

