/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.DepartImPermissionType;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchAssignImPermissionCommand
extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> departIds;
    private final DepartImPermissionType permissionType;
    private final Collection<String> allowedDepartIds;

    public BatchAssignImPermissionCommand(String organizationId, Collection<String> departIds, DepartImPermissionType permissionType, Collection<String> allowedDepartIds) {
        this.organizationId = organizationId;
        this.departIds = departIds;
        this.permissionType = permissionType;
        this.allowedDepartIds = allowedDepartIds;
    }

    public void validate() {
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new BadTenantException("\u6240\u5728\u7ec4\u7ec7\u65e0\u6548!");
        }
        if (CollectionUtils.isEmpty(this.departIds)) {
            throw new BadTenantException("\u6279\u91cf\u8bbe\u7f6e\u6743\u9650\u7684\u90e8\u95e8\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (this.getPermissionType() == null) {
            throw new BadTenantException("\u901a\u8baf\u5f55\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (this.getPermissionType() == DepartImPermissionType.Special && CollectionUtils.isEmpty(this.getAllowedDepartIds())) {
            throw new BadTenantException("\u901a\u8baf\u5f55\u6743\u9650\u4e3a: \u53ef\u89c1\u6307\u5b9a\u90e8\u95e8\u65f6, \u5fc5\u987b\u9009\u62e9\u8981\u6388\u6743\u7684\u90e8\u95e8\u5217\u8868");
        }
    }

    public static BatchAssignImPermissionCommand create(String organizationId, Collection<String> departIds, DepartImPermissionType permissionType, Collection<String> allowedDepartIds) {
        return new BatchAssignImPermissionCommand(organizationId, departIds, permissionType, allowedDepartIds);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Collection<String> getDepartIds() {
        return this.departIds;
    }

    public DepartImPermissionType getPermissionType() {
        return this.permissionType;
    }

    public Collection<String> getAllowedDepartIds() {
        return this.allowedDepartIds;
    }
}

