/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.enums.EmployeeEventType;
import java.sql.Timestamp;
import java.time.Instant;

public class EmployeeUpdatedEvent
extends DomainEventAbstract<EmployeeEntity> {
    private final EmployeeEventType eventType;
    private final Timestamp eventTime;
    private final String note;

    public EmployeeUpdatedEvent(EmployeeEntity employee, EmployeeEventType eventType, Timestamp eventTime, String note) {
        super((Object)employee);
        this.eventType = eventType;
        this.eventTime = eventTime == null ? Timestamp.from(Instant.now()) : eventTime;
        this.note = note;
    }

    public static EmployeeUpdatedEvent create(EmployeeEntity employee, EmployeeEventType eventType, Timestamp eventTime, String note) {
        return new EmployeeUpdatedEvent(employee, eventType, eventTime, note);
    }

    public EmployeeEventType getEventType() {
        return this.eventType;
    }

    public Timestamp getEventTime() {
        return this.eventTime;
    }

    public String getNote() {
        return this.note;
    }
}

