/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities.reports;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.SyncDomainEntityAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.UserType;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantUserCredentialsEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="report_employees")
@Entity
public class EmployeeReportEntity
extends SyncDomainEntityAbstract
implements IAggregate {
    @Id
    @Column(name="id")
    private String id;
    @Column(name="name")
    private String name;
    @Column(name="depart_id")
    private String departId;
    @Column(name="depart_name")
    private String departName;
    @Column(name="occupation_type")
    private OccupationType occupationType;
    @Column(name="job_type")
    private String jobType;
    @Column(name="credential_type")
    private CredentialType credentialType;
    @Column(name="credential_number")
    private String credentialNumber;
    @Column(name="telephone")
    private String telephone;
    @Column(name="hired_date")
    private Date hiredDate;
    @Column(name="birth_date")
    private Date birthDate;
    @Column(name="sex")
    private Sex sex;
    @Column(name="nationality")
    private String nationality;
    @Column(name="education")
    private String education;
    @Column(name="stature")
    private String stature;
    @Column(name="blood_type")
    private String bloodType;
    @Column(name="nation")
    private String nation;
    @Column(name="politics_status")
    private String politicsStatus;
    @Column(name="military_status")
    private String militaryStatus;
    @Column(name="home_address")
    private String homeAddress;
    @Column(name="household_type")
    private String householdType;
    @Column(name="emergency_contact")
    private String emergencyContact;
    @Column(name="emergency_phone")
    private String emergencyPhone;
    @Column(name="license_level")
    private String licenseLevel;
    @Column(name="is_veteran")
    private TrueFalseStatus isVeteran;
    @Column(name="work_years")
    private String workYears;
    @Column(name="disease_history")
    private String diseaseHistory;
    @Column(name="is_certified")
    private String isCertified;
    @Column(name="id_face_photo")
    private String IDFacePhoto;
    @Column(name="id_nation_photo")
    private String IDNationPhoto;
    @Column(name="id_header_photo")
    private String IDHeaderPhoto;
    @Column(name="is_in_my_company")
    private TrueFalseStatus isInMyCompany;
    @Column(name="last_auth_time")
    private Timestamp LastAuthTime;
    @Column(name="last_search_past_time")
    private Timestamp lastSearchPastTime;
    @Column(name="leave_date")
    private Timestamp leaveDate;
    @Column(name="company_name")
    private String companyName;
    @Column(name="insure")
    private TrueFalseStatus insure;
    @Column(name="id_validation_s")
    private String idValidationS;
    @Column(name="id_validation_e")
    private String idValidationE;
    @Column(name="id_address")
    private String idAddress;
    @Column(name="attendance_site_status")
    private String attendanceSiteStatus;
    @Column(name="location")
    private String location;
    @Column(name="data_restrict")
    private Timestamp dataRestrict;
    @Column(name="certification")
    private String certification;
    @Column(name="document_id_bool")
    private String documentIDBool;
    @Column(name="is_state")
    private String isState;
    @Column(name="remark")
    private String remark;
    @Column(name="version")
    private long version;
    @Column(name="last_updated_time")
    private Timestamp lastUpdatedTime;
    @Column(name="shi_ming")
    private String shiming;
    @Column(name="is_deleted")
    private TrueFalseStatus isDeleted;
    @Column(name="superior_id")
    private String superiorId;
    @Column(name="tenant_user_id")
    private String tenantUserId;
    @Column(name="created_time")
    private Timestamp createdTime;
    @Column(name="organization_id", length=200)
    private String organizationId;
    @Column(name="one_inch_color_white_photo", length=1000)
    private String oneInchColorWhitePhoto;
    @Column(name="two_inch_color_blue_photo", length=1000)
    private String twoInchColorBluePhoto;
    @Column(name="is_in_mycompany")
    private String isInmycompany;

    protected EmployeeReportEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    protected EmployeeReportEntity(String id, String organId) {
        this();
        this.setId(id);
        this.setDomainId(organId);
    }

    public static EmployeeReportEntity create(EmployeeEntity employee) {
        EmployeeReportEntity reportEntity = new EmployeeReportEntity(employee.getId(), employee.getOrganization().getId());
        reportEntity.update(employee);
        reportEntity.setIsDeleted(TrueFalseStatus.False);
        return reportEntity;
    }

    public void update(EmployeeEntity employee) {
        this.markAsDeleted(false);
        TenantUserEntity tenantUser = employee.getTenantUser();
        OrganizationEntity organization = employee.getOrganization();
        TenantUserCredentialsEntity userCredentials = tenantUser.getSelectedCredential();
        DepartmentEntity department = employee.getDefaultDepartment();
        Timestamp now = Timestamp.from(Instant.now());
        this.setLastUpdatedTime(now);
        this.setVersion(now.getTime());
        this.setBirthDate(tenantUser.getBirthdate());
        this.setEducation(tenantUser.getEducation());
        this.setAttendanceSiteStatus("");
        this.setBloodType("");
        this.setCertification("");
        this.setCompanyName(organization.getName());
        this.setDocumentIDBool("");
        this.setSuperiorId(employee.getSuperior() == null ? null : employee.getSuperior().getId());
        if (department != null) {
            this.setDepartId(department.getId());
            this.setDepartName(department.getName());
        }
        this.setDiseaseHistory("");
        this.setAttendanceSiteStatus("");
        this.setEmergencyContact("");
        this.setName(tenantUser.getName());
        this.setOccupationType(OccupationType.Normal);
        this.setJobType("xxxxxxx");
        this.setTelephone(tenantUser.getTelephone());
        this.setTenantUserId(tenantUser.getId());
        this.setHiredDate(employee.getHiredDate());
        this.setSex(tenantUser.getSex());
        this.setNationality("");
        this.setStature(tenantUser.getStature());
        this.setNation(tenantUser.getNation());
        this.setPoliticsStatus(tenantUser.getPoliticsStatus());
        this.setMilitaryStatus(tenantUser.getMilitaryStatus());
        this.setHouseholdType(tenantUser.getHouseholdType());
        this.setEmergencyContact("");
        this.setEmergencyPhone("");
        this.setLicenseLevel("");
        this.setIsVeteran(tenantUser.getUserType() == UserType.exSoldier ? TrueFalseStatus.True : TrueFalseStatus.False);
        this.setWorkYears("");
        this.setDiseaseHistory("");
        this.setShiming("");
        this.setOrganizationId(organization.getId());
        if (tenantUser.getAuthenticateStatus() != null) {
            switch (tenantUser.getAuthenticateStatus()) {
                case Authenticating: {
                    this.setShiming("\u8ba4\u8bc1\u4e2d");
                    break;
                }
                case Passed: {
                    this.setShiming("\u5df2\u8ba4\u8bc1");
                    break;
                }
                case Failed: {
                    this.setShiming("\u8ba4\u8bc1\u5931\u8d25");
                    break;
                }
                case UnAuthenticated: {
                    this.setShiming("\u672a\u8ba4\u8bc1");
                }
            }
        }
        this.setIsCertified("");
        if (tenantUser.getCheckedStatus() != null) {
            switch (tenantUser.getCheckedStatus()) {
                case Matched: {
                    this.setIsCertified("\u5df2\u6838\u9a8c");
                    break;
                }
                case Commit: {
                    this.setIsCertified("\u5df2\u63d0\u4ea4");
                    break;
                }
                case None: {
                    this.setIsCertified("\u672a\u63d0\u4ea4");
                }
            }
        }
        if (userCredentials != null) {
            this.setCredentialNumber(userCredentials.getNumber());
            this.setCredentialType(userCredentials.getCredentialType());
            this.setHomeAddress(userCredentials.getAddress());
            this.setIDFacePhoto(userCredentials.getFrontPhoto());
            this.setIDNationPhoto(userCredentials.getReversePhoto());
            this.setIDHeaderPhoto(userCredentials.getHeadPhoto());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.setIdValidationS(userCredentials.getValidDateFrom() == null ? "\u6c38\u4e45" : simpleDateFormat.format(userCredentials.getValidDateFrom()));
            this.setIdValidationE(userCredentials.getValidDateTo() == null ? "\u6c38\u4e45" : simpleDateFormat.format(userCredentials.getValidDateTo()));
            this.setIdAddress(userCredentials.getAddress());
        }
        this.setIsInMyCompany(TrueFalseStatus.True);
        if (employee.getStatus() == EmploymentStatus.OffJob) {
            this.setIsInMyCompany(TrueFalseStatus.False);
        }
        this.setLastAuthTime(tenantUser.getAuthenticatedTime());
        this.setLeaveDate(employee.getLeaveTime());
        this.setInsure(employee.getInsure());
        this.setAttendanceSiteStatus("");
        this.setLocation(tenantUser.getLonLatJson());
        this.setDocumentIDBool("");
        this.setIsState("");
        this.setRemark(tenantUser.getAuthenticatedResult());
    }

    public void markAsDeleted(boolean isDeleted) {
        this.setIsDeleted(isDeleted ? TrueFalseStatus.True : TrueFalseStatus.False);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDepartId() {
        return this.departId;
    }

    public String getDepartName() {
        return this.departName;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public String getJobType() {
        return this.jobType;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public String getCredentialNumber() {
        return this.credentialNumber;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public Date getHiredDate() {
        return this.hiredDate;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public Sex getSex() {
        return this.sex;
    }

    public String getNationality() {
        return this.nationality;
    }

    public String getEducation() {
        return this.education;
    }

    public String getStature() {
        return this.stature;
    }

    public String getBloodType() {
        return this.bloodType;
    }

    public String getNation() {
        return this.nation;
    }

    public String getPoliticsStatus() {
        return this.politicsStatus;
    }

    public String getMilitaryStatus() {
        return this.militaryStatus;
    }

    public String getHomeAddress() {
        return this.homeAddress;
    }

    public String getHouseholdType() {
        return this.householdType;
    }

    public String getEmergencyContact() {
        return this.emergencyContact;
    }

    public String getEmergencyPhone() {
        return this.emergencyPhone;
    }

    public String getLicenseLevel() {
        return this.licenseLevel;
    }

    public TrueFalseStatus getIsVeteran() {
        return this.isVeteran;
    }

    public String getWorkYears() {
        return this.workYears;
    }

    public String getDiseaseHistory() {
        return this.diseaseHistory;
    }

    public String getIsCertified() {
        return this.isCertified;
    }

    public String getIDFacePhoto() {
        return this.IDFacePhoto;
    }

    public String getIDNationPhoto() {
        return this.IDNationPhoto;
    }

    public String getIDHeaderPhoto() {
        return this.IDHeaderPhoto;
    }

    public TrueFalseStatus getIsInMyCompany() {
        return this.isInMyCompany;
    }

    public Timestamp getLastAuthTime() {
        return this.LastAuthTime;
    }

    public Timestamp getLastSearchPastTime() {
        return this.lastSearchPastTime;
    }

    public Timestamp getLeaveDate() {
        return this.leaveDate;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public TrueFalseStatus getInsure() {
        return this.insure;
    }

    public String getIdValidationS() {
        return this.idValidationS;
    }

    public String getIdValidationE() {
        return this.idValidationE;
    }

    public String getIdAddress() {
        return this.idAddress;
    }

    public String getAttendanceSiteStatus() {
        return this.attendanceSiteStatus;
    }

    public String getLocation() {
        return this.location;
    }

    public Timestamp getDataRestrict() {
        return this.dataRestrict;
    }

    public String getCertification() {
        return this.certification;
    }

    public String getDocumentIDBool() {
        return this.documentIDBool;
    }

    public String getIsState() {
        return this.isState;
    }

    public String getRemark() {
        return this.remark;
    }

    public long getVersion() {
        return this.version;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getShiming() {
        return this.shiming;
    }

    public TrueFalseStatus getIsDeleted() {
        return this.isDeleted;
    }

    public String getSuperiorId() {
        return this.superiorId;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getOneInchColorWhitePhoto() {
        return this.oneInchColorWhitePhoto;
    }

    public String getTwoInchColorBluePhoto() {
        return this.twoInchColorBluePhoto;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setDepartId(String departId) {
        this.departId = departId;
    }

    protected void setDepartName(String departName) {
        this.departName = departName;
    }

    protected void setOccupationType(OccupationType occupationType) {
        this.occupationType = occupationType;
    }

    protected void setJobType(String jobType) {
        this.jobType = jobType;
    }

    protected void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    protected void setCredentialNumber(String credentialNumber) {
        this.credentialNumber = credentialNumber;
    }

    protected void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    protected void setHiredDate(Date hiredDate) {
        this.hiredDate = hiredDate;
    }

    protected void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    protected void setSex(Sex sex) {
        this.sex = sex;
    }

    protected void setNationality(String nationality) {
        this.nationality = nationality;
    }

    protected void setEducation(String education) {
        this.education = education;
    }

    protected void setStature(String stature) {
        this.stature = stature;
    }

    protected void setBloodType(String bloodType) {
        this.bloodType = bloodType;
    }

    protected void setNation(String nation) {
        this.nation = nation;
    }

    protected void setPoliticsStatus(String politicsStatus) {
        this.politicsStatus = politicsStatus;
    }

    protected void setMilitaryStatus(String militaryStatus) {
        this.militaryStatus = militaryStatus;
    }

    protected void setHomeAddress(String homeAddress) {
        this.homeAddress = homeAddress;
    }

    protected void setHouseholdType(String householdType) {
        this.householdType = householdType;
    }

    protected void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact;
    }

    protected void setEmergencyPhone(String emergencyPhone) {
        this.emergencyPhone = emergencyPhone;
    }

    protected void setLicenseLevel(String licenseLevel) {
        this.licenseLevel = licenseLevel;
    }

    protected void setIsVeteran(TrueFalseStatus isVeteran) {
        this.isVeteran = isVeteran;
    }

    protected void setWorkYears(String workYears) {
        this.workYears = workYears;
    }

    protected void setDiseaseHistory(String diseaseHistory) {
        this.diseaseHistory = diseaseHistory;
    }

    protected void setIsCertified(String isCertified) {
        this.isCertified = isCertified;
    }

    protected void setIDFacePhoto(String IDFacePhoto) {
        this.IDFacePhoto = IDFacePhoto;
    }

    protected void setIDNationPhoto(String IDNationPhoto) {
        this.IDNationPhoto = IDNationPhoto;
    }

    protected void setIDHeaderPhoto(String IDHeaderPhoto) {
        this.IDHeaderPhoto = IDHeaderPhoto;
    }

    protected void setIsInMyCompany(TrueFalseStatus isInMyCompany) {
        this.isInMyCompany = isInMyCompany;
    }

    protected void setLastAuthTime(Timestamp LastAuthTime) {
        this.LastAuthTime = LastAuthTime;
    }

    protected void setLastSearchPastTime(Timestamp lastSearchPastTime) {
        this.lastSearchPastTime = lastSearchPastTime;
    }

    protected void setLeaveDate(Timestamp leaveDate) {
        this.leaveDate = leaveDate;
    }

    protected void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    protected void setInsure(TrueFalseStatus insure) {
        this.insure = insure;
    }

    protected void setIdValidationS(String idValidationS) {
        this.idValidationS = idValidationS;
    }

    protected void setIdValidationE(String idValidationE) {
        this.idValidationE = idValidationE;
    }

    protected void setIdAddress(String idAddress) {
        this.idAddress = idAddress;
    }

    protected void setAttendanceSiteStatus(String attendanceSiteStatus) {
        this.attendanceSiteStatus = attendanceSiteStatus;
    }

    protected void setLocation(String location) {
        this.location = location;
    }

    protected void setDataRestrict(Timestamp dataRestrict) {
        this.dataRestrict = dataRestrict;
    }

    protected void setCertification(String certification) {
        this.certification = certification;
    }

    protected void setDocumentIDBool(String documentIDBool) {
        this.documentIDBool = documentIDBool;
    }

    protected void setIsState(String isState) {
        this.isState = isState;
    }

    protected void setRemark(String remark) {
        this.remark = remark;
    }

    protected void setVersion(long version) {
        this.version = version;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setShiming(String shiming) {
        this.shiming = shiming;
    }

    protected void setIsDeleted(TrueFalseStatus isDeleted) {
        this.isDeleted = isDeleted;
    }

    protected void setSuperiorId(String superiorId) {
        this.superiorId = superiorId;
    }

    protected void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    protected void setOneInchColorWhitePhoto(String oneInchColorWhitePhoto) {
        this.oneInchColorWhitePhoto = oneInchColorWhitePhoto;
    }

    protected void setTwoInchColorBluePhoto(String twoInchColorBluePhoto) {
        this.twoInchColorBluePhoto = twoInchColorBluePhoto;
    }
}

