/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.CompanyCertificateType;
import com.bcxin.Infrastructures.enums.CompanyNature;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EconomicType;
import com.bcxin.Infrastructures.enums.IndustryDetailType;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.OrganizationLevel;
import com.bcxin.Infrastructures.enums.OrganizationsStatus;
import com.bcxin.Infrastructures.enums.ParentSubsidiary;
import com.bcxin.Infrastructures.enums.SecurityArmedRating;
import com.bcxin.Infrastructures.enums.SecurityPreparednessRating;
import com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.snapshots.OrgGisLocationSnapshot;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.CompanyEntity;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.RegionEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.entities.converters.JsonMapConverter;
import com.bcxin.tenant.domain.entities.valueTypes.ApprovedInformationValueType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.events.OrganizationApprovedChangedEvent;
import com.bcxin.tenant.domain.events.OrganizationCreatedEvent;
import com.bcxin.tenant.domain.services.commands.organizations.CreateMyOrganizationCommand;
import com.bcxin.tenant.domain.services.commands.organizations.RegisterCompanyCommand;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.StringUtils;

@Table(name="tenant_organizations", uniqueConstraints={@UniqueConstraint(name="unique_organization_name", columnNames={"name"})})
@Entity
@Inheritance(strategy=InheritanceType.JOINED)
public class OrganizationEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=50)
    private String id;
    @Column(nullable=false, length=30)
    private String code;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="sys_name", length=100)
    private String sysName;
    @Column(length=500)
    private String description;
    @Column
    private Double longitude;
    @Column
    private Double latitude;
    @Column(nullable=true, name="lon_lat_json", length=200)
    private String lonLatJson;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="province.code", column=@Column(name="place_Of_register_province_code")), @AttributeOverride(name="province.name", column=@Column(name="place_Of_register_province_name")), @AttributeOverride(name="city.code", column=@Column(name="place_Of_register_city_code")), @AttributeOverride(name="city.name", column=@Column(name="place_Of_register_city_name")), @AttributeOverride(name="district.code", column=@Column(name="place_Of_register_district_code")), @AttributeOverride(name="district.name", column=@Column(name="place_Of_register_district_name")), @AttributeOverride(name="address", column=@Column(name="place_Of_register_address"))})
    private LocationValueType placeOfRegister;
    @Column(name="logo_path", length=500)
    private String logoPath;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="province.code", column=@Column(name="place_Of_business_province_code")), @AttributeOverride(name="province.name", column=@Column(name="place_Of_business_province_name")), @AttributeOverride(name="city.code", column=@Column(name="place_Of_business_city_code")), @AttributeOverride(name="city.name", column=@Column(name="place_Of_business_city_name")), @AttributeOverride(name="district.code", column=@Column(name="place_Of_business_district_code")), @AttributeOverride(name="district.name", column=@Column(name="place_Of_business_district_name")), @AttributeOverride(name="address", column=@Column(name="place_Of_business_address"))})
    private LocationValueType placeOfBusiness;
    @Column(name="industry_code")
    private String industryCode;
    @Column(name="institutional_code")
    private String institutionalCode;
    @Embedded
    @Column(name="approved_information")
    @AttributeOverrides(value={@AttributeOverride(name="status", column=@Column(name="approved_information_status")), @AttributeOverride(name="lastUpdatedTime", column=@Column(name="approved_information_last_updated_time")), @AttributeOverride(name="note", column=@Column(name="approved_information_note"))})
    private ApprovedInformationValueType approvedInformationValueType;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="last_updated_time", nullable=true)
    private Timestamp lastUpdatedTime;
    @OneToMany(mappedBy="organization", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<EmployeeEntity> employees;
    @OneToMany(mappedBy="organization", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<DepartmentEntity> departments;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="id", referencedColumnName="id", nullable=false)
    private CompanyEntity company;
    @ManyToOne(cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="tenant_user_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT))
    private TenantUserEntity tenantUser;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status")
    private OrganizationsStatus status;
    @Column(name="fax")
    private String fax;
    @Column(name="telephone")
    private String telephone;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="type")
    private ParentSubsidiary type;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="industry_detail_type")
    private IndustryDetailType industryDetailType;
    @Column(name="supervise_region_code")
    private String superviseRegionCode;
    @ManyToOne(targetEntity=RegionEntity.class, cascade={CascadeType.DETACH}, fetch=FetchType.LAZY)
    @JoinColumn(name="supervise_region_code", referencedColumnName="id", insertable=false, updatable=false)
    private RegionEntity superviseRegion;
    @Column(name="supervise_depart_id")
    private String superviseDepartId;
    @Column(name="supervise_depart_name")
    private String superviseDepartName;
    @Column(name="share_organization_id")
    private String shareOrganizationId;
    @Column(name="share_organization_name")
    private String shareOrganizationName;
    @Column(name="share_employee_id")
    private String shareEmployeeId;
    @Column(name="share_employee_name")
    private String shareEmployeeName;
    @Column(name="level")
    private int organizationLevel;
    @Column(name="level_changed_time")
    private Timestamp levelChangedTime;
    @Column(name="dynamic_fields", columnDefinition="json")
    @Convert(converter=JsonMapConverter.class)
    private Map<String, Object> dynamicFields;

    public void setDynamicFields(Map<String, Object> dynamicFields) {
        this.dynamicFields = dynamicFields;
    }

    public void change(LocationValueType placeOfRegister, LocationValueType placeOfBusiness) {
        this.setPlaceOfRegister(placeOfRegister);
        this.setPlaceOfBusiness(placeOfBusiness);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void change(String sysName, String description, String logoPath, Double longitude, Double latitude, String institutionalCode, IndustryDetailType industryDetailType, String name, ParentSubsidiary type, String telephone, EconomicType economicType, CompanyNature nature, LocationValueType placeOfRegister, LocationValueType placeOfBusiness, String parentName, CompanyCertificateType parentCertificateType, String parentCertificateNumber, String parentLegalPersonName, String parentLegalPersonTelephone, String legalPersonName, String legalPersonTelephone, CredentialType legalPersonCredentialType, String legalPersonCredentialNumber, String legalPersonNationality, String securityPersonName, String securityPersonTelephone, CredentialType securityPersonCredentialType, String securityPersonCredentialNumber, String registeredCapital, String fixedCapital, String annualSalesVolume, String annualProfitTax, CompanyCertificateType certificateType, String unifySocialCreditCode, String unifySocialCreditCodeFile, String servicePermitNumber, String nameOfIssuingAuthority, Date firstIssueServicePermit, String servicePermitAttachment, String securityApprovalNumber, List<String> serviceScopeList, SecurityPreparednessRating securityPreparednessRating, SecurityArmedRating securityArmedRating, SecuritySafetyDefenseRating securitySafetyDefenseRating, Boolean isRiskAssessment, String trainContent, Integer numberOfSecurityGuards, Boolean isPublicSecuritySecurity, Boolean isPropertyEnterprise, String natureOfSelfRecruitedUnits, String placeOfSupervise, String superviseDepartId, String superviseDepartName, String fax, String adminUserName, String adminUserTelephone, JsonProvider jsonProvider, String address) {
        if (sysName != null) {
            this.setSysName(sysName);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (logoPath != null) {
            this.setLogoPath(logoPath);
        }
        if (longitude != null && latitude != null) {
            this.setLongitude(longitude);
            this.setLatitude(latitude);
            OrgGisLocationSnapshot sn = (OrgGisLocationSnapshot)jsonProvider.toObject(OrgGisLocationSnapshot.class, this.getLonLatJson());
            long days = 0L;
            if (sn != null) {
                LocalDate localDate = sn.getTime().toLocalDateTime().toLocalDate();
                LocalDate localDate2 = Timestamp.from(Instant.now()).toLocalDateTime().toLocalDate();
                days = ChronoUnit.DAYS.between(localDate, localDate2);
            }
            if (sn == null || days > 30L) {
                sn = OrgGisLocationSnapshot.create((Double)latitude, (Double)longitude, (String)address);
            } else {
                sn.update(latitude, longitude, address);
            }
            String json = jsonProvider.getJson((Object)sn);
            this.setLonLatJson(json);
        }
        if (institutionalCode != null) {
            this.setInstitutionalCode(institutionalCode);
        }
        if (industryDetailType != null) {
            this.setIndustryDetailType(industryDetailType);
        }
        if (name != null) {
            this.setName(name);
        }
        if (type != null) {
            this.setType(type);
        }
        if (telephone != null) {
            this.setTelephone(telephone);
        }
        if (placeOfRegister != null) {
            this.setPlaceOfRegister(placeOfRegister);
        }
        if (placeOfBusiness != null) {
            this.setPlaceOfBusiness(placeOfBusiness);
        }
        if (placeOfSupervise != null) {
            this.setSuperviseRegionCode(placeOfSupervise);
        }
        if (superviseDepartId != null) {
            this.setSuperviseDepartId(superviseDepartId);
        }
        if (superviseDepartName != null) {
            this.setSuperviseDepartName(superviseDepartName);
        }
        if (fax != null) {
            this.setFax(fax);
        }
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        CompanyEntity company = this.getCompany();
        if (company == null) {
            company = CompanyEntity.create(this);
        }
        company.change(unifySocialCreditCode, unifySocialCreditCodeFile, parentName, parentCertificateType, parentCertificateNumber, parentLegalPersonName, parentLegalPersonTelephone, economicType, nature, serviceScopeList, registeredCapital, fixedCapital, annualProfitTax, annualSalesVolume, certificateType, servicePermitNumber, securityApprovalNumber, nameOfIssuingAuthority, firstIssueServicePermit, servicePermitAttachment, trainContent, securityPreparednessRating, securityArmedRating, securitySafetyDefenseRating, isRiskAssessment, numberOfSecurityGuards, isPublicSecuritySecurity, isPropertyEnterprise, natureOfSelfRecruitedUnits, legalPersonName, legalPersonTelephone, legalPersonCredentialType, legalPersonCredentialNumber, legalPersonNationality, securityPersonName, securityPersonTelephone, securityPersonCredentialType, securityPersonCredentialNumber);
        this.setCompany(company);
        if (StringUtils.isNotBlank((CharSequence)adminUserName) || StringUtils.isNotBlank((CharSequence)adminUserTelephone)) {
            TenantUserEntity adminUser = this.getTenantUser();
            if (StringUtils.isNotBlank((CharSequence)adminUserName)) {
                adminUser.changeName(adminUserName);
            }
            if (StringUtils.isNotBlank((CharSequence)adminUserTelephone)) {
                adminUser.changeTelephone(adminUserTelephone);
            }
            this.setTenantUser(adminUser);
        }
    }

    public void changeLogoPath(String logoPath) {
        this.setLogoPath(logoPath);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void abandon() {
        this.setName(this.getName().concat("-\u4f5c\u5e9f-").concat(DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void approve(ApprovedStatus status, String note) {
        if (this.getApprovedInformationValueType() != null && this.getApprovedInformationValueType().getStatus() == ApprovedStatus.Passed) {
            throw new BadTenantException("\u4f01\u4e1a\u5df2\u7ecf\u5ba1\u6279\u901a\u8fc7\uff0c\u65e0\u9700\u91cd\u590d\u5ba1\u6279");
        }
        ApprovedInformationValueType approvedInformation = ApprovedInformationValueType.create(status, note);
        this.setApprovedInformationValueType(approvedInformation);
        this.recordEvent(OrganizationApprovedChangedEvent.create(this.getId(), approvedInformation.getStatus(), this.getPlaceOfRegister(), this.getPlaceOfBusiness(), this.institutionalCode, this.superviseRegionCode));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void setCompanyEntity(RegisterCompanyCommand command) {
        CompanyEntity company = CompanyEntity.create(this, command);
        this.setCompany(company);
    }

    public void setCompanyEntity(CreateMyOrganizationCommand command) {
        CompanyEntity company = CompanyEntity.create(this, command);
        this.setCompany(company);
    }

    @Deprecated
    public void addEmployee(DepartmentEntity department, MasterSlaveType masterSlaveType, String name, String telephone, Date hiredDate, CredentialType credentialType, String credentialNumber, OccupationType occupationType, boolean ensureExistsUser) {
        Collection<EmployeeEntity> employees = this.getEmployees();
        if (employees == null) {
            employees = new ArrayList<EmployeeEntity>();
        }
        EmployeeEntity employee = EmployeeEntity.create((EventDispatcher)TenantContext.getInstance().resolve(EventDispatcher.class), this, department, name, telephone, null, null, hiredDate, MasterSlaveType.Normal, credentialType, credentialNumber, occupationType, ensureExistsUser, AuthUtil.getCurrentOperator());
        employees.add(employee);
        this.setEmployees(employees);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    @Deprecated
    public EmployeeEntity addEmployee(DepartmentEntity department, MasterSlaveType masterSlaveType, TenantUserEntity tenantUser, String position, boolean isDomainAdmin, OperatorValueType operator) {
        Collection<EmployeeEntity> employees = this.getEmployees();
        if (employees == null) {
            employees = new ArrayList<EmployeeEntity>();
        }
        EmployeeEntity employee = EmployeeEntity.create((EventDispatcher)TenantContext.getInstance().resolve(EventDispatcher.class), this, department, tenantUser, masterSlaveType, position, OccupationType.Normal, null, null, isDomainAdmin, operator);
        employees.add(employee);
        this.setEmployees(employees);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        return employee;
    }

    public void changeStatus(OrganizationsStatus status) {
        this.setStatus(status);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void changeOwner(TenantUserEntity tenantUser) {
        tenantUser.assignOrganization(this);
        this.setTenantUser(tenantUser);
    }

    public DepartmentEntity addDepartment(String name, int displayOrder) {
        Collection<DepartmentEntity> departments = this.getDepartments();
        if (departments == null) {
            departments = new ArrayList<DepartmentEntity>();
        }
        DepartmentEntity department = DepartmentEntity.createRoot(this, name, displayOrder);
        departments.add(department);
        this.setDepartments(departments);
        return department;
    }

    protected OrganizationEntity() {
        String value = UUIDUtil.getShortUuid();
        this.setId(value);
        this.setCode(value);
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setOrganizationLevel(OrganizationLevel.Basic.getValue());
    }

    protected OrganizationEntity(String industryCode, String institutionalCode, String name, String telephone) {
        this();
        this.setName(name);
        this.setIndustryCode(industryCode);
        this.setInstitutionalCode(institutionalCode);
        this.setTelephone(telephone);
        this.setSuperviseRegionCode("#1");
        this.setSuperviseDepartId("#1");
        this.setSuperviseDepartName("#1");
        this.setStatus(OrganizationsStatus.Normal);
        this.setType(ParentSubsidiary.None);
        this.setOrganizationLevel(OrganizationLevel.Basic.getValue());
        this.setApprovedInformationValueType(ApprovedInformationValueType.create(ApprovedStatus.Init, ""));
        this.recordEvent(OrganizationCreatedEvent.create(this, this.getName(), new HashMap<String, String>()));
        this.addDepartment(this.getName(), 0);
    }

    protected OrganizationEntity(String industryCode, String institutionalCode, String name, String telephone, ParentSubsidiary type, IndustryDetailType industryDetailType, String superviseRegionCode, String superviseDepartId, String superviseDepartName, String shareOrganizationId, String shareOrganizationName, String shareEmployeeId, String shareEmployeeName, Map<String, String> dynamic) {
        this(industryCode, institutionalCode, name, telephone);
        this.setType(type == null ? ParentSubsidiary.None : type);
        this.setIndustryDetailType(industryDetailType);
        this.setSuperviseRegionCode(superviseRegionCode == null ? "#" : superviseRegionCode);
        this.setSuperviseDepartId(superviseDepartId == null ? "#" : superviseDepartId);
        this.setSuperviseDepartName(superviseDepartName == null ? "#" : superviseDepartName);
        this.setShareOrganizationId(shareOrganizationId);
        this.setShareOrganizationName(shareOrganizationName);
        this.setShareEmployeeId(shareEmployeeId);
        this.setShareEmployeeName(shareEmployeeName);
    }

    public static OrganizationEntity create(String industryCode, String institutionalCode, String name, String telephone, ParentSubsidiary type, IndustryDetailType industryDetailType, String superviseRegionCode, String superviseDepartId, String superviseDepartName, String shareOrganizationId, String shareOrganizationName, String shareEmployeeId, String shareEmployeeName, Map<String, String> dynamic) {
        OrganizationEntity organization = new OrganizationEntity(industryCode, institutionalCode, name, telephone, type, industryDetailType, superviseRegionCode, superviseDepartId, superviseDepartName, shareOrganizationId, shareOrganizationName, shareEmployeeId, shareEmployeeName, dynamic);
        organization.setStatus(OrganizationsStatus.Normal);
        return organization;
    }

    public static OrganizationEntity createBasic(String industryCode, String institutionalCode, String name, String telephone) {
        OrganizationEntity organization = new OrganizationEntity(industryCode, institutionalCode, name, telephone);
        return organization;
    }

    @Transient
    public boolean infoCompleted() {
        boolean result = true;
        try {
            CompanyEntity company = this.getCompany();
            if (company.getNature() == null) {
                throw new BadTenantException("\u516c\u53f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.getInstitutionalCode().equals("0102")) {
                if (this.getIndustryDetailType() == null) {
                    throw new BadTenantException("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getFixedCapital())) {
                    throw new BadTenantException("\u56fa\u5b9a\u8d44\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getAnnualSalesVolume())) {
                    throw new BadTenantException("\u5e74\u8425\u4e1a\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getAnnualProfitTax())) {
                    throw new BadTenantException("\u5e74\u5229\u7a0e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getSecurityApprovalNumber())) {
                    throw new BadTenantException("\u6279\u51c6\u6587\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getServiceScope() == null) {
                    throw new BadTenantException("\u670d\u52a1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getSecurityPreparednessRating() == null) {
                    throw new BadTenantException("\u4eba\u529b\u9632\u8303\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getSecurityArmedRating() == null) {
                    throw new BadTenantException("\u6b66\u88c5\u5b88\u62a4\u62bc\u8fd0\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getSecuritySafetyDefenseRating() == null) {
                    throw new BadTenantException("\u5b89\u5168\u6280\u672f\u9632\u8303\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getIsRiskAssessment() == null) {
                    throw new BadTenantException("\u662f\u5426\u6709\u98ce\u9669\u8bc4\u4f30\u8d44\u8d28\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getServicePermitNumber())) {
                    throw new BadTenantException("\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getNameOfIssuingAuthority())) {
                    throw new BadTenantException("\u53d1\u8bc1\u673a\u5173\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getFirstIssueServicePermit() == null) {
                    throw new BadTenantException("\u53d1\u8bc1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getServicePermitAttachment())) {
                    throw new BadTenantException("\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u626b\u63cf\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getType().ordinal() == ParentSubsidiary.Branch.ordinal() || this.getType().ordinal() == ParentSubsidiary.Subsidiary.ordinal()) {
                    if (StringUtils.isBlank((CharSequence)company.getParentName())) {
                        throw new BadTenantException("\u603b\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (company.getParentCertificateType() == null) {
                        throw new BadTenantException("\u603b\u516c\u53f8\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isBlank((CharSequence)company.getParentCertificateNumber())) {
                        throw new BadTenantException("\u603b\u516c\u53f8\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isBlank((CharSequence)company.getParentLegalPersonName())) {
                        throw new BadTenantException("\u603b\u516c\u53f8\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (StringUtils.isBlank((CharSequence)company.getParentLegalPersonTelephone())) {
                        throw new BadTenantException("\u603b\u516c\u53f8\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                }
            } else if (this.getInstitutionalCode().equals("0103")) {
                if (StringUtils.isBlank((CharSequence)company.getTrainContent())) {
                    throw new BadTenantException("\u57f9\u8bad\u5355\u4f4d\u7684\u57f9\u8bad\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getServicePermitNumber())) {
                    throw new BadTenantException("\u4fdd\u5b89\u57f9\u8bad\u8bb8\u53ef\uff08\u5907\u6848\uff09\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getNameOfIssuingAuthority())) {
                    throw new BadTenantException("\u53d1\u8bc1\u673a\u5173\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getFirstIssueServicePermit() == null) {
                    throw new BadTenantException("\u53d1\u8bc1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getServicePermitAttachment())) {
                    throw new BadTenantException("\u4fdd\u5b89\u57f9\u8bad\u8bb8\u53ef\uff08\u5907\u6848\uff09\u8bc1\u626b\u63cf\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            } else if (this.getInstitutionalCode().equals("0104")) {
                if (StringUtils.isBlank((CharSequence)company.getSecurityPersonName())) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)company.getSecurityPersonTelephone())) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (company.getSecurityPersonCredentialType() == null) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)company.getSecurityPersonCredentialNumber())) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u8bc1\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (company.getNumberOfSecurityGuards() == null) {
                    throw new BadTenantException("\u62df\u81ea\u62db\u4fdd\u5b89\u5458\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getIsPublicSecuritySecurity() == null) {
                    throw new BadTenantException("\u662f\u5426\u6cbb\u5b89\u4fdd\u536b\u91cd\u70b9\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (company.getIsPropertyEnterprise() == null) {
                    throw new BadTenantException("\u662f\u5426\u7269\u4e1a\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)company.getNatureOfSelfRecruitedUnits())) {
                    throw new BadTenantException("\u81ea\u62db\u4fdd\u5b89\u5355\u4f4d\u6027\u8d28\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            this.validateLocation(this.getPlaceOfRegister(), "\u6ce8\u518c\u5730\u533a", true);
            this.validateLocation(this.getPlaceOfBusiness(), "\u7ecf\u8425\u5730\u533a", true);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Transient
    public boolean superviseCompleted() {
        boolean result = true;
        try {
            if (StringUtils.isBlank((CharSequence)this.getSuperviseRegionCode()) || "#".equals(this.getSuperviseRegionCode())) {
                throw new BadTenantException("\u76d1\u7ba1\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getSuperviseDepartId()) || "#".equals(this.getSuperviseRegionCode())) {
                throw new BadTenantException("\u76d1\u7ba1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Transient
    private void validateLocation(LocationValueType locationValueType, String category, boolean isValidAddress) {
        if (locationValueType == null) {
            throw new BadTenantException(String.format("%s\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (locationValueType.getProvince() == null || StringUtils.isBlank((CharSequence)locationValueType.getProvince().getCode())) {
            throw new BadTenantException(String.format("%s\u7684\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (isValidAddress && StringUtils.isBlank((CharSequence)locationValueType.getAddress())) {
            throw new BadTenantException(String.format("%s\u7684\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getSysName() {
        return this.sysName;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public String getLonLatJson() {
        return this.lonLatJson;
    }

    public LocationValueType getPlaceOfRegister() {
        return this.placeOfRegister;
    }

    public String getLogoPath() {
        return this.logoPath;
    }

    public LocationValueType getPlaceOfBusiness() {
        return this.placeOfBusiness;
    }

    public String getIndustryCode() {
        return this.industryCode;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public ApprovedInformationValueType getApprovedInformationValueType() {
        return this.approvedInformationValueType;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Collection<EmployeeEntity> getEmployees() {
        return this.employees;
    }

    public Collection<DepartmentEntity> getDepartments() {
        return this.departments;
    }

    public CompanyEntity getCompany() {
        return this.company;
    }

    public TenantUserEntity getTenantUser() {
        return this.tenantUser;
    }

    public OrganizationsStatus getStatus() {
        return this.status;
    }

    public String getFax() {
        return this.fax;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public ParentSubsidiary getType() {
        return this.type;
    }

    public IndustryDetailType getIndustryDetailType() {
        return this.industryDetailType;
    }

    public String getSuperviseRegionCode() {
        return this.superviseRegionCode;
    }

    public RegionEntity getSuperviseRegion() {
        return this.superviseRegion;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public String getShareOrganizationId() {
        return this.shareOrganizationId;
    }

    public String getShareOrganizationName() {
        return this.shareOrganizationName;
    }

    public String getShareEmployeeId() {
        return this.shareEmployeeId;
    }

    public String getShareEmployeeName() {
        return this.shareEmployeeName;
    }

    public int getOrganizationLevel() {
        return this.organizationLevel;
    }

    public Timestamp getLevelChangedTime() {
        return this.levelChangedTime;
    }

    public Map<String, Object> getDynamicFields() {
        return this.dynamicFields;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setSysName(String sysName) {
        this.sysName = sysName;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    protected void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    protected void setLonLatJson(String lonLatJson) {
        this.lonLatJson = lonLatJson;
    }

    protected void setPlaceOfRegister(LocationValueType placeOfRegister) {
        this.placeOfRegister = placeOfRegister;
    }

    protected void setLogoPath(String logoPath) {
        this.logoPath = logoPath;
    }

    protected void setPlaceOfBusiness(LocationValueType placeOfBusiness) {
        this.placeOfBusiness = placeOfBusiness;
    }

    protected void setIndustryCode(String industryCode) {
        this.industryCode = industryCode;
    }

    protected void setInstitutionalCode(String institutionalCode) {
        this.institutionalCode = institutionalCode;
    }

    protected void setApprovedInformationValueType(ApprovedInformationValueType approvedInformationValueType) {
        this.approvedInformationValueType = approvedInformationValueType;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setEmployees(Collection<EmployeeEntity> employees) {
        this.employees = employees;
    }

    protected void setDepartments(Collection<DepartmentEntity> departments) {
        this.departments = departments;
    }

    protected void setCompany(CompanyEntity company) {
        this.company = company;
    }

    protected void setTenantUser(TenantUserEntity tenantUser) {
        this.tenantUser = tenantUser;
    }

    protected void setStatus(OrganizationsStatus status) {
        this.status = status;
    }

    protected void setFax(String fax) {
        this.fax = fax;
    }

    protected void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    protected void setType(ParentSubsidiary type) {
        this.type = type;
    }

    protected void setIndustryDetailType(IndustryDetailType industryDetailType) {
        this.industryDetailType = industryDetailType;
    }

    protected void setSuperviseRegionCode(String superviseRegionCode) {
        this.superviseRegionCode = superviseRegionCode;
    }

    protected void setSuperviseRegion(RegionEntity superviseRegion) {
        this.superviseRegion = superviseRegion;
    }

    protected void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    protected void setSuperviseDepartName(String superviseDepartName) {
        this.superviseDepartName = superviseDepartName;
    }

    protected void setShareOrganizationId(String shareOrganizationId) {
        this.shareOrganizationId = shareOrganizationId;
    }

    protected void setShareOrganizationName(String shareOrganizationName) {
        this.shareOrganizationName = shareOrganizationName;
    }

    protected void setShareEmployeeId(String shareEmployeeId) {
        this.shareEmployeeId = shareEmployeeId;
    }

    protected void setShareEmployeeName(String shareEmployeeName) {
        this.shareEmployeeName = shareEmployeeName;
    }

    protected void setOrganizationLevel(int organizationLevel) {
        this.organizationLevel = organizationLevel;
    }

    protected void setLevelChangedTime(Timestamp levelChangedTime) {
        this.levelChangedTime = levelChangedTime;
    }
}

