/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="tenant_organization_admins")
@Entity
public class OrganizationAdminEntity
extends OpEntityAbstract
implements IAggregate {
    @Id
    @Column(name="id", length=255)
    private String id;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="organization_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_organization_admin_organization_id", value=ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;
    @ManyToOne(cascade={CascadeType.DETACH})
    @JoinColumn(name="employee_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_organization_admin_employee_id", value=ConstraintMode.CONSTRAINT))
    private EmployeeEntity employee;

    protected OrganizationAdminEntity() {
    }

    protected OrganizationAdminEntity(OrganizationEntity organization, EmployeeEntity employee) {
        this.setId(UUIDUtil.getShortUuid());
        this.setOrganization(organization);
        this.setEmployee(employee);
    }

    public static OrganizationAdminEntity create(OrganizationEntity organization, EmployeeEntity employee) {
        return new OrganizationAdminEntity(organization, employee);
    }

    public String getId() {
        return this.id;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public EmployeeEntity getEmployee() {
        return this.employee;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setEmployee(EmployeeEntity employee) {
        this.employee = employee;
    }
}

