/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import java.sql.Timestamp;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Table(name="tenant_invite_depart")
@Entity
public class InviteDepartEntity
extends EntityAbstract
implements IAggregate {
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="organization_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(name="fk_tenant_invite_depart_organization_id", value=ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="depart_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_tenant_invite_depart_id", value=ConstraintMode.CONSTRAINT))
    private DepartmentEntity department;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="occupation_type", nullable=false)
    private OccupationType occupationType;
    @Column(name="end_time", nullable=false)
    private Timestamp endTime;
    @Column(name="area_code", nullable=true)
    private String areaCode;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="creator_id", nullable=true, length=150)), @AttributeOverride(name="name", column=@Column(name="creator_name", nullable=true, length=200)), @AttributeOverride(name="createdTime", column=@Column(name="created_time", nullable=true))})
    private OperatorValueType creator;

    public static InviteDepartEntity create(OrganizationEntity organization, DepartmentEntity department, OccupationType occupationType, Timestamp endTime, String areaCode, OperatorValueType creator) {
        InviteDepartEntity inviteDepartEntity = new InviteDepartEntity();
        inviteDepartEntity.setOrganization(organization);
        inviteDepartEntity.setDepartment(department);
        inviteDepartEntity.setOccupationType(occupationType);
        inviteDepartEntity.setEndTime(endTime);
        inviteDepartEntity.setId(UUIDUtil.getShortUuid());
        inviteDepartEntity.setAreaCode(areaCode);
        inviteDepartEntity.setCreator(creator);
        return inviteDepartEntity;
    }

    public String getId() {
        return this.id;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public DepartmentEntity getDepartment() {
        return this.department;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public String getAreaCode() {
        return this.areaCode;
    }

    public OperatorValueType getCreator() {
        return this.creator;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setDepartment(DepartmentEntity department) {
        this.department = department;
    }

    protected void setOccupationType(OccupationType occupationType) {
        this.occupationType = occupationType;
    }

    protected void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    protected void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    protected void setCreator(OperatorValueType creator) {
        this.creator = creator;
    }
}

