/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.alibaba.excel.util.DateUtils;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.LockProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.AppealStatus;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.exceptions.RetryableTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import com.bcxin.api.interfaces.buses.requests.MessageRequest;
import com.bcxin.api.interfaces.commons.PlatformOperateLogRpcProvider;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.employees.ResetPassWordRequest;
import com.bcxin.api.interfaces.tenants.requests.operatelog.PlatformOperateLogRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.configs.TenantUserConfig;
import com.bcxin.tenant.domain.entities.TenantEventEntity;
import com.bcxin.tenant.domain.entities.TenantUserAppealsEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.entities.valueTypes.ItemValueType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;
import com.bcxin.tenant.domain.events.TenantUserAfterCreatedEvent;
import com.bcxin.tenant.domain.exceptions.TenantExceptionConverter;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import com.bcxin.tenant.domain.repositories.TenantUserAppealsRepository;
import com.bcxin.tenant.domain.repositories.TenantUserRepository;
import com.bcxin.tenant.domain.repositories.UniqueDataConstraintRepository;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.TenantUserService;
import com.bcxin.tenant.domain.services.commands.BatchCreateTenantUserCommand;
import com.bcxin.tenant.domain.services.commands.CreateTenantUserByEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.SyncTenantUserLocationCommand;
import com.bcxin.tenant.domain.services.commands.UpdateTenantUserCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.CreateAuthAppealCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.NotifyNewUserCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.PlatformResetAuthenticateStatusCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.PlatformResetPasswordCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.PlatformUpdateUserBasicCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.RedoAuthorizationCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.SyncDeviceCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.SyncWechatLabelCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.TocWechatCgiConfirmCheckStatusCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.UpdateBasicTenantUserCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.UpdateCredentialCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.UpdateUserCredentialCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.UpdateUserNickHeadPhotoCommand;
import com.bcxin.tenant.domain.services.commands.tenantUsers.UpdateUserPhotoCommand;
import com.bcxin.tenant.domain.utils.PassAssembleUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service
public class TenantUserServiceImpl
implements TenantUserService {
    private final Logger logger = LoggerFactory.getLogger(TenantUserServiceImpl.class);
    private final TenantUserRepository tenantUserRepository;
    private final TenantUserAppealsRepository tenantUserAppealsRepository;
    private final UnitWork unitWork;
    private final RetryProvider retryProvider;
    private final JsonProvider jsonProvider;
    private final TenantEventService eventService;
    private final EventDispatcher eventDispatcher;
    private final TenantEventRepository eventRepository;
    private final MessageRpcProvider messageRpcProvider;
    private final TenantUserConfig tenantUserConfig;
    private final EnvConfig envConfig;
    private final LockProvider lockProvider;
    private final TenantDbReader dbReader;
    private final PlatformOperateLogRpcProvider platformOperateLogRpcProvider;
    private final IdentityRpcProvider identityRpcProvider;
    private final boolean updateNicknameHeadPhoto;

    public TenantUserServiceImpl(TenantUserRepository tenantUserRepository, PlatformTransactionManager transactionManager, UnitWork unitWork, UniqueDataConstraintRepository uniqueDataConstraintRepository, TenantUserAppealsRepository tenantUserAppealsRepository, RetryProvider retryProvider, JsonProvider jsonProvider, TenantDbReader dbReader, TenantEventService eventService, EventDispatcher eventDispatcher, TenantEventRepository eventRepository, MessageRpcProvider messageRpcProvider, TenantUserConfig tenantUserConfig, EnvConfig envConfig, LockProvider lockProvider, PlatformOperateLogRpcProvider platformOperateLogRpcProvider, IdentityRpcProvider identityRpcProvider, @Value(value="${tenant-user-config.update-nickname-headphoto:false}") Boolean updateNicknameHeadPhoto) {
        this.tenantUserRepository = tenantUserRepository;
        this.unitWork = unitWork;
        this.tenantUserAppealsRepository = tenantUserAppealsRepository;
        this.retryProvider = retryProvider;
        this.jsonProvider = jsonProvider;
        this.eventService = eventService;
        this.eventDispatcher = eventDispatcher;
        this.eventRepository = eventRepository;
        this.messageRpcProvider = messageRpcProvider;
        this.tenantUserConfig = tenantUserConfig;
        this.envConfig = envConfig;
        this.lockProvider = lockProvider;
        this.dbReader = dbReader;
        this.platformOperateLogRpcProvider = platformOperateLogRpcProvider;
        this.identityRpcProvider = identityRpcProvider;
        this.updateNicknameHeadPhoto = updateNicknameHeadPhoto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(CreateTenantUserByEmployeeCommand command) {
        block10: {
            AtomicReference<TenantUserEntity> tenantUserAto = new AtomicReference<TenantUserEntity>();
            ArrayList uniqueDataConstraintEntities = new ArrayList();
            try {
                this.unitWork.executeNewTran(() -> {
                    TenantUserEntity finalTenantUser = TenantUserEntity.createImport(this.eventService, command.getName(), command.getTelephone(), command.getSex(), command.getBirthdate(), command.getNation(), command.getEducation(), command.getPoliticsStatus(), command.getMilitaryStatus(), command.getMaritalStatus(), command.getEmergencyContact(), command.getEmergencyPhone(), command.getAddress(), command.getHouseholdType());
                    if (this.tenantUserConfig.isIntranet()) {
                        finalTenantUser.assignThirdPartyLoginNo(this.generateThirdPartyLoginNo());
                    }
                    if (org.springframework.util.StringUtils.hasLength((String)command.getCredentialNumber())) {
                        finalTenantUser.addCredential(command.getCredentialType(), command.getCredentialNumber(), true);
                    }
                    this.tenantUserRepository.save(finalTenantUser);
                    tenantUserAto.set(finalTenantUser);
                });
                if (tenantUserAto.get() != null) {
                    this.eventDispatcher.dispatch((DomainEventAbstract)TenantUserAfterCreatedEvent.create((TenantUserEntity)((Object)tenantUserAto.get())));
                }
            }
            catch (Exception ex) {
                TenantExceptionAbstract tenantException = TenantExceptionConverter.cast(ex);
                if (tenantException instanceof ConflictTenantException) {
                    if (tenantUserAto.get() != null) {
                        this.unitWork.detach((IAggregate)tenantUserAto.get());
                        uniqueDataConstraintEntities.forEach(ii -> this.unitWork.detach((IAggregate)ii));
                    }
                    tenantUserAto.set(this.tenantUserRepository.getByIdNum(command.getCredentialNumber(), command.getCredentialType()));
                    if (tenantUserAto.get() == null) {
                        ex.printStackTrace();
                        throw new BadTenantException(String.format("\u8be5\u8bc1\u4ef6\u4fe1\u606f(%s)\u5df2\u7ecf\u88ab\u5176\u4ed6\u7528\u6237\u6ce8\u518c!", command.getCredentialNumber()));
                    }
                    break block10;
                }
                ex.printStackTrace();
                throw ex;
            }
            finally {
                if (tenantUserAto.get() != null) {
                    TenantContext.getInstance().setValue((Object)command.getEmployee(), tenantUserAto.get());
                    this.unitWork.detach((IAggregate)tenantUserAto.get());
                }
            }
        }
    }

    @Override
    public Collection<TenantUserEntity> create(BatchCreateTenantUserCommand command) {
        ArrayList<TenantUserEntity> existsTenantUsers = new ArrayList<TenantUserEntity>();
        this.retryProvider.execute(() -> {
            this.executeCreate(command, existsTenantUsers);
            if (command.getItems().stream().anyMatch(ix -> !existsTenantUsers.stream().anyMatch(ext -> ext.getSelectedCredential().getNumber().equals(ix.getCredentialNumber())))) {
                throw new RetryableTenantException();
            }
        }, 3);
        return existsTenantUsers;
    }

    @Override
    public void dispatch(UpdateTenantUserCommand command) {
        command.validate();
        Optional userOptional = this.tenantUserRepository.findById(command.getId());
        if (!userOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u8be5\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity userEntity = (TenantUserEntity)((Object)userOptional.get());
        userEntity.change(command.getSex(), command.getNation(), command.getDiseasesHistory(), command.getWorkYear(), command.getPoliticsStatus(), command.getStature(), command.getMilitaryStatus(), command.getBirthdate(), command.getEducation(), command.getHouseholdType(), command.getNativePlace(), command.getMaritalStatus(), command.getEmergencyContact(), command.getEmergencyPhone(), command.getLicenseLevel(), command.getPlaceOfNow() != null ? this.translateLocationItem(command.getPlaceOfNow()) : null);
        userEntity.changeEmail(command.getEmail());
        this.unitWork.executeTran(() -> this.tenantUserRepository.save(userEntity));
    }

    private LocationValueType translateLocationItem(LocationRequest locationRequest) {
        return LocationValueType.create(this.translateItemValueItem(locationRequest.getProvince() == null ? null : locationRequest.getProvince()), this.translateItemValueItem(locationRequest.getCity() == null ? null : locationRequest.getCity()), this.translateItemValueItem(locationRequest.getDistrict() == null ? null : locationRequest.getDistrict()), locationRequest.getAddress());
    }

    private ItemValueType translateItemValueItem(LocationRequest.ItemValueRequest itemValueRequest) {
        if (itemValueRequest == null) {
            return ItemValueType.create(null, null);
        }
        return ItemValueType.create(itemValueRequest.getCode(), itemValueRequest.getName());
    }

    @Override
    public void dispatch(SyncTenantUserLocationCommand command) {
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        this.unitWork.executeTran(() -> {
            tenantUser.changeLocation(command.getLatitude(), command.getLongitude(), this.jsonProvider);
            this.tenantUserRepository.save(tenantUser);
        });
    }

    @Override
    public void dispatch(SyncDeviceCommand command) {
        if (!org.springframework.util.StringUtils.hasLength((String)command.getCid())) {
            return;
        }
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getUserId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity tenant = (TenantUserEntity)((Object)tenantUserOptional.get());
        if (!org.springframework.util.StringUtils.hasLength((String)tenant.getCid()) || !tenant.getCid().equalsIgnoreCase(command.getCid())) {
            this.unitWork.executeTran(() -> {
                tenant.changeDeviceId(command.getCid());
                this.tenantUserRepository.save(tenant);
            });
        }
    }

    @Override
    public void dispatch(SyncWechatLabelCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u5f53\u524d\u7528\u6237\u65e0\u6548");
        }
        ((TenantUserEntity)((Object)tenantUserOptional.get())).changeWechat(command.getOpenId(), command.getNicky(), this.updateNicknameHeadPhoto);
        this.unitWork.executeTran(() -> this.tenantUserRepository.save((EntityAbstract)tenantUserOptional.get()));
    }

    @Override
    public void dispatch(UpdateBasicTenantUserCommand command) {
        command.validate(this.envConfig.isRequiredPhoneAsLoginName());
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        this.unitWork.executeTran(() -> {
            tenantUser.changeBasic(command.getName(), command.getTelephone());
            this.tenantUserRepository.save(tenantUser);
        });
    }

    @Override
    public void dispatch(UpdateCredentialCommand command) {
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        this.unitWork.executeTran(() -> {
            tenantUser.changeCredential(command.getHeadPhoto(), command.getFrontPhoto(), command.getReversePhoto(), command.getAddress(), command.getValidDateFrom(), command.getValidDateTo(), this.updateNicknameHeadPhoto);
            this.tenantUserRepository.save(tenantUser);
        });
    }

    @Override
    public void dispatch(UpdateUserCredentialCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        try {
            this.unitWork.executeTran(() -> {
                tenantUser.changeCredential(command.getName(), command.getCredentialType(), command.getHeadPhoto(), command.getNumber(), command.getValidDateFrom(), command.getValidDateTo(), command.getFrontPhoto(), command.getReversePhoto(), command.getAddress(), command.isFromMobile(), command.getCertificateImage(), this.updateNicknameHeadPhoto, command.isCheckAuthenticate());
                Sex sex = TenantUserServiceImpl.getSexByCredential(command.getCredentialType(), command.getNumber());
                Date birthdate = TenantUserServiceImpl.getBirthdateByCredential(command.getCredentialType(), command.getNumber());
                if (sex != null) {
                    tenantUser.changeSex(sex);
                }
                if (birthdate != null) {
                    tenantUser.changeBirthdate(birthdate);
                }
                this.assignHistoryCredential(command.getNumber(), tenantUser);
                this.tenantUserRepository.save(tenantUser);
                tenantUser.recordCredentialChangeEvent();
            });
        }
        catch (Exception ex) {
            String detailEx = ExceptionUtil.getStackMessage((Throwable)ex);
            if (detailEx.contains("unique_tenant_user_credential_number")) {
                throw new ConflictTenantException("\u8be5\u8bc1\u4ef6\u53f7\u5df2\u88ab\u6ce8\u518c\u3002\u82e5\u9700\u8981\u5c06\u8be5\u8bc1\u4ef6\u53f7\u7801\u6240\u5c5e\u4eba\u5458\u5165\u804c\u5230\u7ec4\u7ec7\u4e0b\uff0c\u8bf7\u901a\u8fc7\u65b0\u589e\u7528\u6237\u529f\u80fd\u5165\u804c\u3002\u672c\u6761\u6570\u636e\u53ef\u79bb\u804c\u79fb\u9664\u3002", ex);
            }
            throw ex;
        }
    }

    private static Sex getSexByCredential(CredentialType credentialType, String credentialNumber) {
        Sex sex = null;
        if (credentialType.ordinal() == CredentialType.IdCard.ordinal() && org.springframework.util.StringUtils.hasLength((String)credentialNumber)) {
            String sexText = "";
            if (credentialNumber.length() == 15) {
                sexText = credentialNumber.substring(14);
            } else if (credentialNumber.length() == 18) {
                sexText = credentialNumber.substring(16, 17);
            } else {
                throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
            }
            sex = TenantUserServiceImpl.isEvenNumber(Integer.parseInt(sexText)) ? Sex.Female : Sex.Male;
        }
        return sex;
    }

    private static Date getBirthdateByCredential(CredentialType credentialType, String credentialNumber) {
        Date birthdate = null;
        if (credentialType.ordinal() == CredentialType.IdCard.ordinal() && org.springframework.util.StringUtils.hasLength((String)credentialNumber)) {
            String birthdateText = "";
            if (credentialNumber.length() == 15) {
                birthdateText = "19" + credentialNumber.substring(6, 12);
            } else if (credentialNumber.length() == 18) {
                birthdateText = credentialNumber.substring(6, 14);
            } else {
                throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
            }
            try {
                birthdate = DateUtils.parseDate((String)birthdateText, (String)"yyyyMMdd");
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return birthdate;
    }

    private static boolean isEvenNumber(int num) {
        if (num == 0) {
            return true;
        }
        return num % 2 == 0;
    }

    private void assignHistoryCredential(String idCardNum, TenantUserEntity tenantUser) {
        if (org.springframework.util.StringUtils.hasLength((String)idCardNum)) {
            List<String> idNums = Stream.of(idCardNum).collect(Collectors.toList());
            this.tenantUserRepository.updateCredentialDetailsTenantUserId(idNums, tenantUser.getId());
        }
    }

    @Override
    public void dispatch(UpdateUserPhotoCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u65e0\u6548(\u627e\u4e0d\u5230)");
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        this.unitWork.executeTran(() -> {
            tenantUser.changePhoto(command.getOneInchColorWhitePhoto(), command.getTwoInchColorBluePhoto());
            this.tenantUserRepository.save(tenantUser);
        });
    }

    @Override
    public void dispatch(UpdateUserNickHeadPhotoCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u65e0\u6548(\u627e\u4e0d\u5230)");
        }
        if (!this.updateNicknameHeadPhoto) {
            if (org.springframework.util.StringUtils.hasLength((String)command.getNick()) && org.springframework.util.StringUtils.isEmpty((Object)command.getHeadPhoto())) {
                throw new UnAuthorizedTenantException("\u65e0\u6cd5\u4fee\u6539\u6635\u79f0");
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)command.getNick()) && org.springframework.util.StringUtils.hasLength((String)command.getHeadPhoto())) {
                throw new UnAuthorizedTenantException("\u65e0\u6cd5\u4fee\u6539\u5934\u50cf");
            }
            if (org.springframework.util.StringUtils.hasLength((String)command.getNick()) && org.springframework.util.StringUtils.hasLength((String)command.getHeadPhoto())) {
                throw new UnAuthorizedTenantException("\u65e0\u6cd5\u4fee\u6539\u6635\u79f0\u6216\u5934\u50cf");
            }
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        this.unitWork.executeTran(() -> {
            tenantUser.changeNickHeadPhoto(command.getNick(), command.getHeadPhoto());
            this.tenantUserRepository.save(tenantUser);
        });
    }

    @Override
    public void dispatch(RedoAuthorizationCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u5f53\u524d\u7528\u6237\u4fe1\u606f\u65e0\u6548(\u627e\u4e0d\u5230)");
        }
        this.unitWork.executeTran(() -> {
            ((TenantUserEntity)((Object)((Object)tenantUserOptional.get()))).redoAuthenticate(command.isCheckAuthenticate());
            this.tenantUserRepository.save((EntityAbstract)tenantUserOptional.get());
        });
    }

    @Override
    public void dispatch(NotifyNewUserCommand command) {
        AtomicReference tenantUserAtomic = new AtomicReference();
        this.retryProvider.execute(() -> {
            Optional tenantUserOptional = this.tenantUserRepository.findById(command.getId());
            if (!tenantUserOptional.isPresent()) {
                throw new RetryableTenantException();
            }
            tenantUserAtomic.set(tenantUserOptional.get());
        }, 10);
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserAtomic.get());
        this.lockProvider.execute(String.format("nf_%s", command.getEventId()), () -> {
            Optional tenantEventOptional = this.eventRepository.findById(command.getEventId());
            if (!tenantEventOptional.isPresent()) {
                return;
            }
            if (((TenantEventEntity)tenantEventOptional.get()).getEventAction() != EventAction.TenantUserAfterCreatedEventForSms) {
                throw new BadTenantException(String.format("\u7a0b\u5e8f\u6709\u8bef, \u8be5\u4e8b\u4ef6(%s, %s)\u5e76\u4e0d\u662f\u5904\u7406SMS\u6d88\u606f\u5185\u5bb9", new Object[]{((TenantEventEntity)tenantEventOptional.get()).getId(), ((TenantEventEntity)tenantEventOptional.get()).getEventAction()}));
            }
            TenantEventEntity selectedTenantEvent = (TenantEventEntity)tenantEventOptional.get();
            if (selectedTenantEvent.getStatus() == EventProcessedStatus.Processed) {
                this.logger.error("\u91cd\u590d\u77ed\u4fe1-\u8be5\u77ed\u4fe1\u4e4b\u524d\u5df2\u7ecf\u53d1\u9001\u8fc7(id={})", (Object)selectedTenantEvent.getId());
                return;
            }
            String pass = PassAssembleUtils.assemble(tenantUser.getSelectIdNum(), this.envConfig.getPassPrefix());
            HashMap<String, String> huaWeiSmsContent = new HashMap<String, String>();
            String smsTemplateCode = "B98";
            if (org.springframework.util.StringUtils.hasLength((String)this.envConfig.getRegisterSmsTemplateCode())) {
                smsTemplateCode = this.envConfig.getRegisterSmsTemplateCode();
            }
            huaWeiSmsContent.put("smsCode", smsTemplateCode);
            ArrayList<String> sendParams = new ArrayList<String>();
            sendParams.add(pass);
            huaWeiSmsContent.put("params", JSON.toJSONString(sendParams));
            String telephone = tenantUser.getTelephone();
            huaWeiSmsContent.put("mobile", telephone);
            this.messageRpcProvider.dispatch(MessageRequest.create((MessageType)MessageType.SMS, huaWeiSmsContent));
            this.unitWork.executeNewTran(() -> {
                selectedTenantEvent.done("\u4e8b\u4ef6\u6d88\u8d39\u6210\u529f-\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                this.eventRepository.save((EntityAbstract)selectedTenantEvent);
            });
        });
    }

    private void executeCreate(BatchCreateTenantUserCommand command, Collection<TenantUserEntity> existsTenantUsers) {
        this.logger.error("[BatchCreateTenantUser] \u5f00\u59cb\u6279\u91cf\u521b\u5efa\u7528\u6237, \u5f85\u521b\u5efa\u6570\u91cf: {}, \u8bc1\u4ef6\u53f7\u7801\u5217\u8868: {}", (Object)command.getItems().size(), command.getItems().stream().map(BatchCreateTenantUserCommand.TenantUserCommandItem::getCredentialNumber).collect(Collectors.toList()));
        Collection<TenantUserEntity> finalExistsTenantUsers = this.tenantUserRepository.findAllByNumbers(command.getItems().stream().map(BatchCreateTenantUserCommand.TenantUserCommandItem::getCredentialNumber).collect(Collectors.toList()));
        Map<Object, Object> userMap = new HashMap();
        if (finalExistsTenantUsers.size() > 0) {
            userMap = finalExistsTenantUsers.stream().collect(Collectors.toMap(TenantUserEntity::getSelectIdNum, Function.identity()));
            this.logger.error("[BatchCreateTenantUser] \u67e5\u8be2\u5230\u5df2\u5b58\u5728\u7528\u6237\u6570\u91cf: {}, \u8bc1\u4ef6\u53f7\u7801: {}", (Object)finalExistsTenantUsers.size(), finalExistsTenantUsers.stream().map(TenantUserEntity::getSelectIdNum).collect(Collectors.toList()));
        }
        ArrayList newTenantUserEntities = new ArrayList();
        try {
            HashMap finalUserMap = userMap;
            this.unitWork.executeTran(() -> {
                for (BatchCreateTenantUserCommand.TenantUserCommandItem item : command.getItems()) {
                    if (finalUserMap.get(item.getCredentialNumber()) != null) {
                        this.logger.debug("[BatchCreateTenantUser] \u8df3\u8fc7\u5df2\u5b58\u5728\u7528\u6237, \u8bc1\u4ef6\u53f7: {}", (Object)item.getCredentialNumber());
                        continue;
                    }
                    this.logger.error("[BatchCreateTenantUser] \u5f00\u59cb\u521b\u5efa\u7528\u6237, \u59d3\u540d: {}, \u624b\u673a\u53f7: {}, \u8bc1\u4ef6\u7c7b\u578b: {}, \u8bc1\u4ef6\u53f7: {}", new Object[]{item.getName(), item.getTelephone(), item.getCredentialType(), item.getCredentialNumber()});
                    TenantUserEntity tenantUser = TenantUserEntity.create(this.eventService, item.getName(), item.getTelephone(), false);
                    this.logger.error("[BatchCreateTenantUser] \u7528\u6237\u5b9e\u4f53\u521b\u5efa\u6210\u529f, \u7528\u6237ID: {}, \u59d3\u540d: {}, \u624b\u673a\u53f7: {}", new Object[]{tenantUser.getId(), tenantUser.getName(), tenantUser.getTelephone()});
                    if (this.tenantUserConfig.isIntranet()) {
                        tenantUser.assignThirdPartyLoginNo(this.generateThirdPartyLoginNo());
                        this.logger.debug("[BatchCreateTenantUser] \u5df2\u5206\u914d\u7b2c\u4e09\u65b9\u767b\u5f55\u6807\u8bc6, \u7528\u6237ID: {}", (Object)tenantUser.getId());
                    }
                    tenantUser.addCredential(item.getCredentialType(), item.getCredentialNumber(), true);
                    this.logger.error("[BatchCreateTenantUser] \u5df2\u6dfb\u52a0\u8bc1\u4ef6\u4fe1\u606f, \u7528\u6237ID: {}, \u8bc1\u4ef6\u7c7b\u578b: {}, \u8bc1\u4ef6\u53f7: {}", new Object[]{tenantUser.getId(), item.getCredentialType(), item.getCredentialNumber()});
                    Sex sex = TenantUserServiceImpl.getSexByCredential(item.getCredentialType(), item.getCredentialNumber());
                    Date birthdate = TenantUserServiceImpl.getBirthdateByCredential(item.getCredentialType(), item.getCredentialNumber());
                    if (sex != null) {
                        tenantUser.changeSex(sex);
                        this.logger.debug("[BatchCreateTenantUser] \u5df2\u8bbe\u7f6e\u6027\u522b, \u7528\u6237ID: {}, \u6027\u522b: {}", (Object)tenantUser.getId(), (Object)sex);
                    }
                    if (birthdate != null) {
                        tenantUser.changeBirthdate(birthdate);
                        this.logger.debug("[BatchCreateTenantUser] \u5df2\u8bbe\u7f6e\u51fa\u751f\u65e5\u671f, \u7528\u6237ID: {}, \u51fa\u751f\u65e5\u671f: {}", (Object)tenantUser.getId(), (Object)birthdate);
                    }
                    newTenantUserEntities.add(tenantUser);
                    finalExistsTenantUsers.add(tenantUser);
                    this.tenantUserRepository.save(tenantUser);
                    this.logger.error("[BatchCreateTenantUser] \u7528\u6237\u4fdd\u5b58\u6210\u529f, \u7528\u6237ID: {}, \u59d3\u540d: {}, \u624b\u673a\u53f7: {}, \u8bc1\u4ef6\u53f7: {}", new Object[]{tenantUser.getId(), tenantUser.getName(), tenantUser.getTelephone(), tenantUser.getSelectIdNum()});
                }
            });
            this.logger.error("[BatchCreateTenantUser] \u4e8b\u52a1\u63d0\u4ea4\u6210\u529f, \u65b0\u521b\u5efa\u7528\u6237\u6570\u91cf: {}", (Object)newTenantUserEntities.size());
            existsTenantUsers.clear();
            existsTenantUsers.addAll(finalExistsTenantUsers);
            for (TenantUserEntity tenantUser : newTenantUserEntities) {
                this.logger.error("[BatchCreateTenantUser] \u5f00\u59cb\u5206\u53d1\u7528\u6237\u521b\u5efa\u4e8b\u4ef6, \u7528\u6237ID: {}, \u59d3\u540d: {}, \u624b\u673a\u53f7: {}", new Object[]{tenantUser.getId(), tenantUser.getName(), tenantUser.getTelephone()});
                try {
                    this.eventDispatcher.dispatch((DomainEventAbstract)TenantUserAfterCreatedEvent.create(tenantUser));
                    this.logger.error("[BatchCreateTenantUser] \u7528\u6237\u521b\u5efa\u4e8b\u4ef6\u5206\u53d1\u6210\u529f, \u7528\u6237ID: {}", (Object)tenantUser.getId());
                }
                catch (Exception e) {
                    this.logger.error("[BatchCreateTenantUser] \u7528\u6237\u521b\u5efa\u4e8b\u4ef6\u5206\u53d1\u5931\u8d25, \u7528\u6237ID: {}, \u9519\u8bef\u4fe1\u606f: {}", new Object[]{tenantUser.getId(), ExceptionUtil.getStackMessage((Throwable)e), e});
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("[BatchCreateTenantUser] \u6279\u91cf\u521b\u5efa\u7528\u6237\u5f02\u5e38, \u9519\u8bef\u4fe1\u606f: {}, \u5806\u6808: {}", new Object[]{ex.getMessage(), ExceptionUtil.getStackMessage((Throwable)ex), ex});
            if (ex.toString().contains("unique_tenant_user_credential_number")) {
                this.logger.error("[BatchCreateTenantUser] \u68c0\u6d4b\u5230\u8bc1\u4ef6\u53f7\u552f\u4e00\u6027\u7ea6\u675f\u51b2\u7a81, \u5c06\u91cd\u8bd5");
                throw new RetryableTenantException();
            }
            throw ex;
        }
    }

    private String generateThirdPartyLoginNo() {
        String code = this.tenantUserConfig.getCode();
        for (int count = 999999; count > 0; --count) {
            String str = System.currentTimeMillis() + "";
            String value = code + str.substring(str.length() - 6);
            TenantUserEntity tenantUserEntity = this.tenantUserRepository.getByThirdPartyLoginNo(value);
            if (tenantUserEntity != null) continue;
            return value;
        }
        return "";
    }

    @Override
    public void createAppeal(CreateAuthAppealCommand command) {
        if (org.springframework.util.StringUtils.isEmpty((Object)command.getId())) {
            throw new ArgumentTenantException("\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)command.getAppealPhoto())) {
            throw new ArgumentTenantException("\u7533\u8bc9\u56fe\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)command.getRegionCode())) {
            throw new ArgumentTenantException("\u516c\u53f8\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional tenantUserOpt = this.tenantUserRepository.findById(command.getId());
        if (!tenantUserOpt.isPresent()) {
            throw new NotFoundTenantException(String.format("%s\u4eba\u5458\u4fe1\u606f\u4e0d\u5b58\u5728", command.getId()));
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOpt.get());
        RealNameAuthenticatedStatus authStatus = tenantUser.getAuthenticateStatus();
        if (authStatus != RealNameAuthenticatedStatus.Failed) {
            throw new BadTenantException(String.format("\u5f53\u524d\u5b9e\u540d\u8ba4\u8bc1\u72b6\u6001\u4e3a%s, \u4e0d\u5141\u8bb8\u8fdb\u884c\u7533\u8bc9", authStatus.getTypeName()));
        }
        this.unitWork.executeTran(() -> {
            TenantUserAppealsEntity appealsEntity = TenantUserAppealsEntity.create(tenantUser, command.getAppealPhoto(), command.getRegionCode());
            this.tenantUserAppealsRepository.save(appealsEntity);
            tenantUser.changeAppealStatus(AppealStatus.Request);
            this.tenantUserRepository.save(tenantUser);
        });
    }

    @Override
    public void dispatch(PlatformUpdateUserBasicCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getTenantUserId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f");
        }
        Optional operateUserOptional = this.tenantUserRepository.findById(command.getOperateUserId());
        if (!operateUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u88ab\u64cd\u4f5c\u7684\u7528\u6237\u4fe1\u606f");
        }
        StringBuffer operateContent = new StringBuffer(64);
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        TenantUserEntity operateUser = (TenantUserEntity)((Object)operateUserOptional.get());
        String oldName = operateUser.getName();
        String oldPhone = operateUser.getTelephone();
        if (StringUtils.isNotBlank((CharSequence)command.getName())) {
            operateContent.append("\u4fee\u6539\u4e86\u59d3\u540d\uff0c\u539f\u503c\uff1a[").append(oldName).append("]\uff0c\u6539\u4e3a\uff1a[").append(command.getName()).append("]\u3002");
        }
        if (StringUtils.isNotBlank((CharSequence)command.getTelephone())) {
            operateContent.append("\u4fee\u6539\u4e86\u624b\u673a\u53f7\u7801\uff0c\u539f\u503c\uff1a[").append(oldPhone).append("]\uff0c\u6539\u4e3a\uff1a[").append(command.getTelephone()).append("]\u3002");
        }
        this.unitWork.executeTran(() -> {
            operateUser.changeBasic(command.getName(), command.getTelephone());
            this.tenantUserRepository.save(operateUser);
            if (StringUtils.isNotBlank((CharSequence)command.getName()) && !oldName.equals(command.getName())) {
                this.tenantUserRepository.updateCredentialNameByTenantUserId(operateUser.getId(), command.getName());
            }
            this.platformOperateLogRpcProvider.logOperate(new PlatformOperateLogRequest(tenantUser.getId(), command.getEmployeeId(), tenantUser.getName(), Integer.valueOf(1), operateUser.getId(), operateContent.toString(), command.getOperateReason(), command.getIpAddress()));
        });
    }

    @Override
    public void dispatch(PlatformResetAuthenticateStatusCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getTenantUserId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f");
        }
        Optional operateUserOptional = this.tenantUserRepository.findById(command.getOperateUserId());
        if (!operateUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u88ab\u64cd\u4f5c\u7684\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        TenantUserEntity operateUser = (TenantUserEntity)((Object)operateUserOptional.get());
        this.unitWork.executeTran(() -> {
            operateUser.resetAuthenticateStatus();
            this.tenantUserRepository.save(operateUser);
            this.platformOperateLogRpcProvider.logOperate(new PlatformOperateLogRequest(tenantUser.getId(), command.getEmployeeId(), tenantUser.getName(), Integer.valueOf(2), operateUser.getId(), "\u5e73\u53f0\u64cd\u4f5c\u91cd\u65b0\u8ba4\u8bc1", command.getOperateReason(), command.getIpAddress()));
        });
    }

    @Override
    public void dispatch(PlatformResetPasswordCommand command) {
        command.validate();
        Optional tenantUserOptional = this.tenantUserRepository.findById(command.getTenantUserId());
        if (!tenantUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u767b\u5f55\u7528\u6237\u4fe1\u606f");
        }
        Optional operateUserOptional = this.tenantUserRepository.findById(command.getOperateUserId());
        if (!operateUserOptional.isPresent()) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u88ab\u64cd\u4f5c\u7684\u7528\u6237\u4fe1\u606f");
        }
        TenantUserEntity tenantUser = (TenantUserEntity)((Object)tenantUserOptional.get());
        TenantUserEntity operateUser = (TenantUserEntity)((Object)operateUserOptional.get());
        ResetPassWordRequest request = new ResetPassWordRequest();
        request.setLoginName(operateUser.getSelectIdNum());
        request.setNewPassword("");
        this.identityRpcProvider.resetPassword(request);
        this.unitWork.executeTran(() -> this.platformOperateLogRpcProvider.logOperate(new PlatformOperateLogRequest(tenantUser.getId(), command.getEmployeeId(), tenantUser.getName(), Integer.valueOf(5), operateUser.getId(), "\u5e73\u53f0\u91cd\u7f6e\u5bc6\u7801", null, command.getIpAddress())));
    }

    @Override
    public TocWechatCgiConfirmCheckStatusCommand.TocWechatCgiConfirmCheckStatusCommandResult dispatch(TocWechatCgiConfirmCheckStatusCommand command) {
        TenantUserEntity findTenantUser = this.tenantUserRepository.getByIdNum(command.getNumber(), command.getCredentialType());
        if (findTenantUser != null && findTenantUser.getCheckedStatus() != UserCheckedStatus.None) {
            return TocWechatCgiConfirmCheckStatusCommand.TocWechatCgiConfirmCheckStatusCommandResult.create(findTenantUser.getId());
        }
        AtomicReference<Boolean> existsUser = new AtomicReference<Boolean>(false);
        AtomicReference tenantUserIdAto = new AtomicReference();
        this.unitWork.executeTran(() -> {
            TenantUserEntity tenantUser = findTenantUser;
            if (tenantUser == null) {
                tenantUser = TenantUserEntity.create(this.eventService, command.getName(), command.getPhone(), true);
                existsUser.set(true);
            }
            tenantUserIdAto.set(tenantUser.getId());
            tenantUser.changeTelephone(command.getPhone());
            tenantUser.changeCredential(command.getName(), command.getCredentialType(), command.getHeadPhoto(), command.getNumber(), command.getValidDateFrom(), command.getValidDateTo(), command.getFrontPhoto(), command.getReversePhoto(), command.getAddress(), true, command.getCertificateImage(), this.updateNicknameHeadPhoto, false);
            this.tenantUserRepository.save(tenantUser);
        });
        return TocWechatCgiConfirmCheckStatusCommand.TocWechatCgiConfirmCheckStatusCommandResult.create((String)tenantUserIdAto.get());
    }
}

