/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.events;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;

public class OrganizationApprovedChangedEvent
extends DomainEventAbstract<String> {
    private final String organId;
    private final LocationValueType placeOfRegister;
    private final LocationValueType placeOfBusiness;
    private final ApprovedStatus status;
    private final String superviseRegionCode;
    private final String institutionalCode;

    public OrganizationApprovedChangedEvent(String organId, ApprovedStatus status, LocationValueType placeOfRegister, LocationValueType placeOfBusiness, String institutionalCode, String superviseRegionCode) {
        super((Object)organId);
        this.organId = organId;
        this.status = status;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.institutionalCode = institutionalCode;
        this.superviseRegionCode = superviseRegionCode;
    }

    public String getRegisterProvinceCity() {
        if (this.placeOfRegister == null) {
            return null;
        }
        return String.format("%s%s", new Object[]{this.placeOfRegister.getProvince(), this.placeOfRegister.getCity()});
    }

    public static OrganizationApprovedChangedEvent create(String organId, ApprovedStatus status, LocationValueType placeOfRegister, LocationValueType placeOfBusiness, String institutionalCode, String superviseRegionCode) {
        return new OrganizationApprovedChangedEvent(organId, status, placeOfRegister, placeOfBusiness, institutionalCode, superviseRegionCode);
    }

    public String getOrganId() {
        return this.organId;
    }

    public LocationValueType getPlaceOfRegister() {
        return this.placeOfRegister;
    }

    public LocationValueType getPlaceOfBusiness() {
        return this.placeOfBusiness;
    }

    public ApprovedStatus getStatus() {
        return this.status;
    }

    public String getSuperviseRegionCode() {
        return this.superviseRegionCode;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }
}

