/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.contracts;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.tenant.domain.snapshots.ContractImportedItemSnapshot;
import java.util.Collection;
import java.util.Date;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchImportContractCommand
extends CommandAbstract {
    private final String organizationId;
    private final String path;
    private final Collection<ContractCommandItem> items;

    public BatchImportContractCommand(String organizationId, String path, Collection<ContractCommandItem> items) {
        this.organizationId = organizationId;
        this.path = path;
        this.items = items;
    }

    public static BatchImportContractCommand create(String organizationId, String path, Collection<ContractCommandItem> items) {
        return new BatchImportContractCommand(organizationId, path, items);
    }

    public void validate() {
        super.validate();
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new ArgumentTenantException("\u5f53\u524d\u7ec4\u7ec7\u65e0\u6548");
        }
        if (!StringUtils.hasLength((String)this.getPath())) {
            throw new ArgumentTenantException("\u4e0a\u4f20\u7684\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(this.getItems())) {
            throw new ArgumentTenantException("\u5f85\u5bfc\u5165\u7684\u5408\u540c\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.getItems().forEach(ix -> {
            try {
                ix.validate();
            }
            catch (TenantExceptionAbstract ex) {
                ix.addError(ex.getMessage());
            }
        });
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getPath() {
        return this.path;
    }

    public Collection<ContractCommandItem> getItems() {
        return this.items;
    }

    public static class ContractCommandItem
    extends CommandAbstract {
        private final ContractImportedItemSnapshot data;

        public ContractCommandItem(int index, String name, String aName, String bName, String idNum, String beginDate, String endDate) {
            this.data = ContractImportedItemSnapshot.create(index, name, aName, bName, idNum, beginDate, endDate);
        }

        public static ContractCommandItem create(int index, String name, String aName, String bName, String idNum, String beginDate, String endDate) {
            return new ContractCommandItem(index, name, aName, bName, idNum, beginDate, endDate);
        }

        public Date getBeginDate() {
            return DateUtil.fromString((String)this.getData().getBeginDateText());
        }

        public Date getEndDate() {
            return DateUtil.fromString((String)this.getData().getEndDateText());
        }

        public void validate() {
            super.validate();
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getData().getName())) {
                    throw new ArgumentTenantException("\u5408\u540c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getData().getAName())) {
                    throw new ArgumentTenantException("\u7532\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getData().getBName())) {
                    throw new ArgumentTenantException("\u4e59\u65b9\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getData().getBeginDateText())) {
                    throw new ArgumentTenantException("\u5408\u540c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (DateUtil.fromString((String)this.getData().getBeginDateText()) == null) {
                    throw new ArgumentTenantException("\u5408\u540c\u5f00\u59cb\u65f6\u95f4\u65e0\u6548");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getData().getEndDateText())) {
                    throw new ArgumentTenantException("\u5408\u540c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (DateUtil.fromString((String)this.getData().getEndDateText()) == null) {
                    throw new ArgumentTenantException("\u5408\u540c\u7ed3\u675f\u65f6\u95f4\u65e0\u6548");
                }
            });
            this.checkParameter(() -> {
                Date beginDate = DateUtil.fromString((String)this.getData().getBeginDateText());
                Date endDate = DateUtil.fromString((String)this.getData().getEndDateText());
                if (beginDate != null && endDate != null && beginDate.after(endDate)) {
                    throw new ArgumentTenantException("\u5408\u540c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
                }
            });
        }

        public ContractImportedItemSnapshot getData() {
            return this.data;
        }
    }
}

