/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import java.util.Collection;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchDeleteDepartAdminCommand
extends CommandAbstract {
    private final String organizationId;
    private final Collection<String> employeeIds;

    public BatchDeleteDepartAdminCommand(String organizationId, Collection<String> employeeIds) {
        this.organizationId = organizationId;
        this.employeeIds = employeeIds;
    }

    public void validate() {
        if (!TenantContext.getInstance().getUserContext().isDomainAdmin()) {
            throw new NotAllowedTenantException("\u975e\u7ec4\u7ec7\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new ArgumentTenantException("\u64cd\u4f5c\u7684\u4f01\u4e1a\u65e0\u6548!");
        }
        if (CollectionUtils.isEmpty(this.getEmployeeIds()) || this.getEmployeeIds().stream().anyMatch(ii -> !StringUtils.hasLength((String)ii))) {
            throw new ArgumentTenantException("\u804c\u5458\u4fe1\u606f\u65e0\u6548!");
        }
    }

    public static BatchDeleteDepartAdminCommand create(String organizationId, Collection<String> employeeIds) {
        return new BatchDeleteDepartAdminCommand(organizationId, employeeIds);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Collection<String> getEmployeeIds() {
        return this.employeeIds;
    }
}

