/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import java.sql.Timestamp;
import java.time.Instant;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Table(name="tenant_employee_relations", uniqueConstraints={@UniqueConstraint(name="unique_tenant_employee_relations_tenant_user_id_organization_id", columnNames={"tenant_user_id", "organization_id"})})
@Entity
public class TenantUserEmployeeRelationEntity
extends EntityAbstract {
    @Id
    @Column(length=50)
    private String id;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="employee_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_tenant_employee_relation_tenant_employee_id", value=ConstraintMode.CONSTRAINT))
    private EmployeeEntity employee;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="organization_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_tenant_employee_relation_tenant_organization_id", value=ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tenant_user_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_tenant_employee_relation_tenant_user_id"))
    private TenantUserEntity tenantUser;

    protected TenantUserEmployeeRelationEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static TenantUserEmployeeRelationEntity create(TenantUserEntity tenantUser, OrganizationEntity organization, EmployeeEntity employee) {
        TenantUserEmployeeRelationEntity tenantUserEmployeeRelation = new TenantUserEmployeeRelationEntity();
        tenantUserEmployeeRelation.setEmployee(employee);
        tenantUserEmployeeRelation.setTenantUser(tenantUser);
        tenantUserEmployeeRelation.setOrganization(organization);
        tenantUserEmployeeRelation.setId(UUIDUtil.getShortUuid());
        return tenantUserEmployeeRelation;
    }

    public String getId() {
        return this.id;
    }

    public EmployeeEntity getEmployee() {
        return this.employee;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public TenantUserEntity getTenantUser() {
        return this.tenantUser;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setEmployee(EmployeeEntity employee) {
        this.employee = employee;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setTenantUser(TenantUserEntity tenantUser) {
        this.tenantUser = tenantUser;
    }
}

