/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.Infrastructures.validations.CredentialValidator;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.springframework.util.StringUtils;

@Table(name="tenant_user_credentials", uniqueConstraints={@UniqueConstraint(name="unique_tenant_user_credential_number", columnNames={"credential_type", "number"})})
@Entity
public class TenantUserCredentialsEntity {
    @Id
    private String id;
    @Column(name="name", length=50, nullable=false)
    private String name;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="credential_type", nullable=false)
    private CredentialType credentialType;
    @Column(name="number")
    private String number;
    @Temporal(value=TemporalType.DATE)
    @Column(name="valid_date_from", nullable=true)
    private Date validDateFrom;
    @Temporal(value=TemporalType.DATE)
    @Column(name="valid_date_to", nullable=true)
    private Date validDateTo;
    private String headPhoto;
    @Column(name="front_photo", length=500)
    private String frontPhoto;
    @Column(name="reverse_photo", length=500)
    private String reversePhoto;
    @Column(name="address", length=500)
    private String address;
    @Column(name="created_time", nullable=false)
    private Timestamp CreatedTime;
    @ManyToOne
    @JoinColumn(name="tenant_user_id", referencedColumnName="id")
    private TenantUserEntity tenantUser;
    @Column(name="selected", nullable=false)
    private TrueFalseStatus selected;

    public void changeDetail(String headPhoto, String frontPhoto, String reversePhoto, String address, Date validDateFrom, Date validDateTo) {
        if (!StringUtils.hasLength((String)headPhoto)) {
            throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u5934\u50cf\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)frontPhoto)) {
            throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u4eba\u50cf\u9762\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)reversePhoto)) {
            throw new ArgumentTenantException("\u8eab\u4efd\u8bc1\u56fd\u5fbd\u9762\u7167\u7247\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setHeadPhoto(headPhoto);
        this.setFrontPhoto(frontPhoto);
        this.setReversePhoto(reversePhoto);
        this.setAddress(address);
        this.setValidDateFrom(validDateFrom);
        this.setValidDateTo(validDateTo);
    }

    public void changeDetail(CredentialType credentialType, String name, String number, String headPhoto, String frontPhoto, String reversePhoto, String address, Date validDateFrom, Date validDateTo) {
        if (credentialType == null) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)name)) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)number)) {
            throw new ArgumentTenantException("\u8bc1\u4ef6\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CredentialValidator.validate((CredentialType)credentialType, (String)number)) {
            throw new ArgumentTenantException(String.format("\u8bc1\u4ef6\u53f7\u7801(%s)\u683c\u5f0f\u4e0d\u6b63\u786e", number));
        }
        this.setCredentialType(credentialType);
        this.setName(name);
        this.setNumber(number);
        this.setHeadPhoto(headPhoto);
        this.setFrontPhoto(frontPhoto);
        this.setReversePhoto(reversePhoto);
        this.setAddress(address);
        this.setValidDateFrom(validDateFrom);
        this.setValidDateTo(validDateTo);
        this.markSelected(true);
    }

    public void changeName(String name) {
        this.setName(name);
    }

    protected TenantUserCredentialsEntity() {
        this.markSelected(true);
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public void markSelected(boolean selected) {
        this.setSelected(selected ? TrueFalseStatus.True : TrueFalseStatus.False);
    }

    public static TenantUserCredentialsEntity create(TenantUserEntity tenantUser, CredentialType credentialType, String number) {
        TenantUserCredentialsEntity credential = new TenantUserCredentialsEntity();
        if (!StringUtils.hasLength((String)number)) {
            throw new BadTenantException("\u8bc1\u4ef6\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CredentialValidator.validate((CredentialType)credentialType, (String)number)) {
            throw new BadTenantException(String.format("\u8bc1\u4ef6\u7f16\u53f7(%s)\u4e0d\u6b63\u786e", number));
        }
        credential.setTenantUser(tenantUser);
        credential.setName(tenantUser.getName());
        credential.setCredentialType(credentialType);
        credential.setNumber(number);
        credential.setId(UUIDUtil.getShortUuid());
        return credential;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public String getNumber() {
        return this.number;
    }

    public Date getValidDateFrom() {
        return this.validDateFrom;
    }

    public Date getValidDateTo() {
        return this.validDateTo;
    }

    public String getHeadPhoto() {
        return this.headPhoto;
    }

    public String getFrontPhoto() {
        return this.frontPhoto;
    }

    public String getReversePhoto() {
        return this.reversePhoto;
    }

    public String getAddress() {
        return this.address;
    }

    public Timestamp getCreatedTime() {
        return this.CreatedTime;
    }

    public TenantUserEntity getTenantUser() {
        return this.tenantUser;
    }

    public TrueFalseStatus getSelected() {
        return this.selected;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    protected void setNumber(String number) {
        this.number = number;
    }

    protected void setValidDateFrom(Date validDateFrom) {
        this.validDateFrom = validDateFrom;
    }

    protected void setValidDateTo(Date validDateTo) {
        this.validDateTo = validDateTo;
    }

    protected void setHeadPhoto(String headPhoto) {
        this.headPhoto = headPhoto;
    }

    protected void setFrontPhoto(String frontPhoto) {
        this.frontPhoto = frontPhoto;
    }

    protected void setReversePhoto(String reversePhoto) {
        this.reversePhoto = reversePhoto;
    }

    protected void setAddress(String address) {
        this.address = address;
    }

    protected void setCreatedTime(Timestamp CreatedTime) {
        this.CreatedTime = CreatedTime;
    }

    protected void setTenantUser(TenantUserEntity tenantUser) {
        this.tenantUser = tenantUser;
    }

    protected void setSelected(TrueFalseStatus selected) {
        this.selected = selected;
    }
}

