/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.ImportDataItemEntity;
import com.bcxin.tenant.domain.enums.ImportedDataCategory;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Table(name="queue_imported_data")
@Entity
public class ImportDataEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=100)
    private String id;
    @Column(name="path", nullable=false)
    private String path;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="category", nullable=false)
    private ImportedDataCategory category;
    @Column(name="download_time", nullable=true)
    private Timestamp downloadedTime;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;
    @Column(name="organization_id", nullable=true)
    private String organizationId;
    @OneToMany(mappedBy="importData", cascade={CascadeType.ALL})
    private Collection<ImportDataItemEntity> dataItems;
    @Transient
    private OperatorValueType operator;

    protected ImportDataEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static ImportDataEntity create(String organizationId, String path, ImportedDataCategory category) {
        ImportDataEntity importDataEntity = new ImportDataEntity();
        importDataEntity.setOrganizationId(organizationId);
        importDataEntity.setId(String.format("%s-%s", DateUtil.format2ShortDateTime((Date)new Date()), UUIDUtil.getShortUuid()));
        importDataEntity.setCategory(category);
        importDataEntity.setPath(path);
        return importDataEntity;
    }

    public void setOperator(OperatorValueType operator) {
        this.operator = operator;
    }

    public ImportDataItemEntity addDataItem(String data) {
        Collection<ImportDataItemEntity> dataItemEntities = this.getDataItems();
        if (dataItemEntities == null) {
            dataItemEntities = new ArrayList<ImportDataItemEntity>();
        }
        ImportDataItemEntity importDataItemEntity = ImportDataItemEntity.create(this, data);
        dataItemEntities.add(importDataItemEntity);
        this.setDataItems(dataItemEntities);
        return importDataItemEntity;
    }

    public ImportDataItemEntity addProcessedDataItem(String data, ProcessedStatus status, String result) {
        ImportDataItemEntity dataItemEntity = this.addDataItem(data);
        dataItemEntity.changeStatus(status, result);
        return dataItemEntity;
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public ImportedDataCategory getCategory() {
        return this.category;
    }

    public Timestamp getDownloadedTime() {
        return this.downloadedTime;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Collection<ImportDataItemEntity> getDataItems() {
        return this.dataItems;
    }

    public OperatorValueType getOperator() {
        return this.operator;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void setCategory(ImportedDataCategory category) {
        this.category = category;
    }

    protected void setDownloadedTime(Timestamp downloadedTime) {
        this.downloadedTime = downloadedTime;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    protected void setDataItems(Collection<ImportDataItemEntity> dataItems) {
        this.dataItems = dataItems;
    }
}

