/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchAssignEmployeeSuperiorCommand
extends CommandAbstract {
    private final String organizationId;
    private final Collection<AssignEmployeeSuperiorItem> items;

    public BatchAssignEmployeeSuperiorCommand(String organizationId, Collection<AssignEmployeeSuperiorItem> items) {
        this.organizationId = organizationId;
        this.items = items;
    }

    public void validate() {
        super.validate();
        if (CollectionUtils.isEmpty(this.getItems())) {
            throw new ArgumentTenantException("\u5f85\u8f6c\u79fb\u4e0a\u7ea7\u804c\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasLength((String)this.getOrganizationId())) {
            throw new ArgumentTenantException("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.getItems().forEach(item -> {
            if (!StringUtils.hasLength((String)item.getOriginalSuperiorId())) {
                throw new ArgumentTenantException("\u5f85\u7236\u804c\u5458\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }

    public Collection<String> getComputedIds() {
        if (CollectionUtils.isEmpty(this.getItems())) {
            return Collections.EMPTY_LIST;
        }
        return this.getItems().stream().flatMap(ii -> Stream.of(ii.getOriginalSuperiorId(), ii.getNewSuperiorId()).filter(ix -> StringUtils.hasLength((String)ix))).collect(Collectors.toList());
    }

    public static BatchAssignEmployeeSuperiorCommand create(String organizationId, Collection<AssignEmployeeSuperiorItem> employeeSuperiorItems) {
        return new BatchAssignEmployeeSuperiorCommand(organizationId, employeeSuperiorItems);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public Collection<AssignEmployeeSuperiorItem> getItems() {
        return this.items;
    }

    public static class AssignEmployeeSuperiorItem {
        private final String originalSuperiorId;
        private final String newSuperiorId;

        public AssignEmployeeSuperiorItem(String originalSuperiorId, String newSuperiorId) {
            this.originalSuperiorId = originalSuperiorId;
            this.newSuperiorId = newSuperiorId;
        }

        public static AssignEmployeeSuperiorItem create(String originalSuperiorId, String newSuperiorId) {
            return new AssignEmployeeSuperiorItem(originalSuperiorId, newSuperiorId);
        }

        public String getOriginalSuperiorId() {
            return this.originalSuperiorId;
        }

        public String getNewSuperiorId() {
            return this.newSuperiorId;
        }
    }
}

