/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.DepartImPermissionType;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DepartmentCommand
extends CommandAbstract {
    private final String organizationId;
    private final String name;
    private final String code;
    private final String parentId;
    private final int displayOrder;
    private final List<String> leaderEmployeeIdList;
    private DepartImPermissionType permissionType;
    private Collection<String> allowedDepartIds;

    public DepartmentCommand(String organizationId, String name, String parentId, int displayOrder, DepartImPermissionType permissionType, Collection<String> allowedDepartIds, List<String> leaderEmployeeIdList) {
        this.organizationId = organizationId;
        this.name = name;
        this.parentId = parentId;
        this.displayOrder = displayOrder;
        this.permissionType = permissionType;
        this.allowedDepartIds = allowedDepartIds;
        this.leaderEmployeeIdList = leaderEmployeeIdList;
        this.code = null;
    }

    public DepartmentCommand(String organizationId, String name, String parentId, String code) {
        this.organizationId = organizationId;
        this.name = name;
        this.parentId = parentId;
        this.code = code;
        this.displayOrder = 1;
        this.permissionType = DepartImPermissionType.OnDepartAndSub;
        this.allowedDepartIds = null;
        this.leaderEmployeeIdList = Collections.singletonList("null");
    }

    public static DepartmentCommand create(String organizationId, String name, String parentId, int displayOrder, DepartImPermissionType permissionType, Collection<String> allowedDepartIds, List<String> leaderEmployeeIdList) {
        return new DepartmentCommand(organizationId, name, parentId, displayOrder, permissionType, allowedDepartIds, leaderEmployeeIdList);
    }

    public static DepartmentCommand create(String organizationId, String name, String parentId, String code) {
        return new DepartmentCommand(organizationId, name, parentId, code);
    }

    public void validate() {
        super.validate();
        if (DepartImPermissionType.Special.equals((Object)this.getPermissionType()) && (this.allowedDepartIds == null || this.allowedDepartIds.size() == 0)) {
            throw new BadTenantException("\u8bf7\u9009\u62e9\u53ef\u89c1\u6307\u5b9a\u90e8\u95e8!");
        }
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getParentId() {
        return this.parentId;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public List<String> getLeaderEmployeeIdList() {
        return this.leaderEmployeeIdList;
    }

    public DepartImPermissionType getPermissionType() {
        return this.permissionType;
    }

    public Collection<String> getAllowedDepartIds() {
        return this.allowedDepartIds;
    }
}

