/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.EmploymentStatus;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="tenant_employee_records")
@Entity
public class EmployeeRecordEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @Column(name="employee_id", nullable=false)
    private String employeeId;
    @Column(name="tenant_user_id", nullable=false)
    private String tenantUserId;
    @Column(name="organization_id", nullable=false)
    private String organizationId;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="occupation_type", nullable=false)
    private OccupationType occupationType;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="status", nullable=false)
    private EmploymentStatus status;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="operator_id", nullable=true, length=150)), @AttributeOverride(name="name", column=@Column(name="operator_name", nullable=true, length=200)), @AttributeOverride(name="createdTime", column=@Column(name="operator_created_time", nullable=true))})
    private OperatorValueType operator;
    @Column(name="action_time", nullable=true)
    private Date actionTime;
    @Column(name="action_note", length=500)
    private String actionNote;
    @Column(name="position", length=200)
    private String position;
    @Column(name="is_domain_admin", nullable=false)
    private TrueFalseStatus domainAdmin;
    @Column(name="interview", nullable=true, length=500)
    private String interview;
    @Column(name="department_id", nullable=true, length=200)
    private String departmentId;
    @Column(name="department_name", nullable=true, length=200)
    private String departmentName;
    @Column(name="created_time", nullable=false)
    private Timestamp createdTime;

    public EmployeeRecordEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static EmployeeRecordEntity create(EmployeeEntity employee) {
        EmployeeRecordEntity employeeRecord = new EmployeeRecordEntity();
        employeeRecord.setEmployeeId(employee.getId());
        employeeRecord.setTenantUserId(employee.getTenantUser().getId());
        employeeRecord.setOrganizationId(employee.getOrganization().getId());
        employeeRecord.setOccupationType(employee.getOccupationType());
        employeeRecord.setStatus(employee.getStatus());
        employeeRecord.setPosition(employee.getPosition());
        if (employee.getStatus() == EmploymentStatus.OnJob) {
            employeeRecord.setActionTime(employee.getHiredDate());
            if (employee.getLeaveOperator() != null) {
                employeeRecord.setActionNote("\u590d\u804c");
            } else {
                employeeRecord.setActionNote("\u5165\u804c");
            }
            employeeRecord.setOperator(employee.getHiredOperator());
        } else {
            employeeRecord.setActionTime(employee.getLeaveTime());
            employeeRecord.setActionNote(employee.getLeaveNote());
            employeeRecord.setOperator(employee.getLeaveOperator());
        }
        if (employee.getDefaultDepartment() != null) {
            employeeRecord.setDepartmentId(employee.getDefaultDepartment().getId());
            employeeRecord.setDepartmentName(employee.getDefaultDepartment().getName());
        }
        employeeRecord.setDomainAdmin(employee.getDomainAdmin());
        employeeRecord.setInterview(employee.getInterview());
        return employeeRecord;
    }

    public long getId() {
        return this.id;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getTenantUserId() {
        return this.tenantUserId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public EmploymentStatus getStatus() {
        return this.status;
    }

    public OperatorValueType getOperator() {
        return this.operator;
    }

    public Date getActionTime() {
        return this.actionTime;
    }

    public String getActionNote() {
        return this.actionNote;
    }

    public String getPosition() {
        return this.position;
    }

    public TrueFalseStatus getDomainAdmin() {
        return this.domainAdmin;
    }

    public String getInterview() {
        return this.interview;
    }

    public String getDepartmentId() {
        return this.departmentId;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    protected void setId(long id) {
        this.id = id;
    }

    protected void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    protected void setTenantUserId(String tenantUserId) {
        this.tenantUserId = tenantUserId;
    }

    protected void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    protected void setOccupationType(OccupationType occupationType) {
        this.occupationType = occupationType;
    }

    protected void setStatus(EmploymentStatus status) {
        this.status = status;
    }

    protected void setOperator(OperatorValueType operator) {
        this.operator = operator;
    }

    protected void setActionTime(Date actionTime) {
        this.actionTime = actionTime;
    }

    protected void setActionNote(String actionNote) {
        this.actionNote = actionNote;
    }

    protected void setPosition(String position) {
        this.position = position;
    }

    protected void setDomainAdmin(TrueFalseStatus domainAdmin) {
        this.domainAdmin = domainAdmin;
    }

    protected void setInterview(String interview) {
        this.interview = interview;
    }

    protected void setDepartmentId(String departmentId) {
        this.departmentId = departmentId;
    }

    protected void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }
}

