/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.conditions.impls;

import com.bcxin.tenant.domain.conditions.TenantUserSameValidator;
import com.bcxin.tenant.domain.conditions.requests.TenantUserSameCheckRequest;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.dto.TenantUserTelephoneCredentialDto;
import com.bcxin.tenant.domain.exceptions.EntryEmployeeValidationException;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class TenantUserSameValidatorImpl
implements TenantUserSameValidator {
    private final EnvConfig envConfig;
    private final TenantDbReader dbReader;

    public TenantUserSameValidatorImpl(EnvConfig envConfig, TenantDbReader dbReader) {
        this.envConfig = envConfig;
        this.dbReader = dbReader;
    }

    @Override
    public void validate(Collection<TenantUserSameCheckRequest> requests) {
        ArrayList<EntryEmployeeValidationException.EntryNotAllowedInfo> notAllowedCompanyInfos = new ArrayList<EntryEmployeeValidationException.EntryNotAllowedInfo>();
        if (this.envConfig.isRequiredPhoneAsLoginName()) {
            Collection numbers = requests.stream().map(ii -> ii.getCredentialNumber()).filter(ii -> StringUtils.hasLength((String)ii)).distinct().collect(Collectors.toList());
            Collection telephones = requests.stream().map(ii -> ii.getTelephone()).filter(ii -> StringUtils.hasLength((String)ii)).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)numbers)) {
                Collection<TenantUserTelephoneCredentialDto> userTelephoneIdCards = this.dbReader.getTenantUserTelephoneCredentialsByNumberOrTel(numbers, telephones);
                for (TenantUserSameCheckRequest dataItem : requests) {
                    Optional<TenantUserTelephoneCredentialDto> selectedCredentialTelephoneByTelOptional;
                    Optional<TenantUserTelephoneCredentialDto> selectedCredentialTelephoneOptional = userTelephoneIdCards.stream().filter(ii -> ii.getCredentialNumber().equalsIgnoreCase(dataItem.getCredentialNumber()) && ii.getCredentialType() == dataItem.getCredentialType()).findFirst();
                    if (selectedCredentialTelephoneOptional.isPresent() && !selectedCredentialTelephoneOptional.get().getTelephone().equalsIgnoreCase(dataItem.getTelephone())) {
                        notAllowedCompanyInfos.add(EntryEmployeeValidationException.EntryNotAllowedInfo.create(dataItem.getTelephone(), String.format(" %s \u5bf9\u5e94\u7684\u8bc1\u4ef6(%s)\u4fe1\u606f\u5df2\u7ecf\u4ed6\u4eba(%s)\u5360\u7528", dataItem.getTelephone(), selectedCredentialTelephoneOptional.get().getCredentialNumber(), selectedCredentialTelephoneOptional.get().getTelephone()), dataItem.getTelephone(), dataItem.getCredentialType(), dataItem.getCredentialNumber()));
                    }
                    if (!(selectedCredentialTelephoneByTelOptional = userTelephoneIdCards.stream().filter(ii -> ii.getTelephone().equalsIgnoreCase(dataItem.getTelephone())).findFirst()).isPresent() || selectedCredentialTelephoneByTelOptional.get().getCredentialType() != dataItem.getCredentialType() || selectedCredentialTelephoneByTelOptional.get().getCredentialNumber().equalsIgnoreCase(dataItem.getCredentialNumber())) continue;
                    notAllowedCompanyInfos.add(EntryEmployeeValidationException.EntryNotAllowedInfo.create(dataItem.getTelephone(), String.format(" %s \u5df2\u7ecf\u6301\u6709\u8bc1\u4ef6(%s)\u4fe1\u606f; \u65e0\u6cd5\u901a\u8fc7\u5176\u4ed6\u8bc1\u4ef6\u8fdb\u884c\u5165/\u590d\u804c", dataItem.getTelephone(), selectedCredentialTelephoneByTelOptional.get().getCredentialNumber()), dataItem.getTelephone(), dataItem.getCredentialType(), dataItem.getCredentialNumber()));
                }
            }
        }
        if (!CollectionUtils.isEmpty(notAllowedCompanyInfos)) {
            throw new EntryEmployeeValidationException("", notAllowedCompanyInfos);
        }
    }
}

