/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.IdWorker;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.EventDispatcher;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import com.bcxin.Infrastructures.events.DomainEventAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.tenant.domain.DomainConstraint;
import com.bcxin.tenant.domain.entities.ExternalGroupEntity;
import com.bcxin.tenant.domain.entities.ExternalMemberEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.TenantUserEntity;
import com.bcxin.tenant.domain.events.MemberCreatedEvent;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.ExternalGroupRepository;
import com.bcxin.tenant.domain.repositories.ExternalMemberRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.TenantUserRepository;
import com.bcxin.tenant.domain.services.ExternalMemberService;
import com.bcxin.tenant.domain.services.commands.externalMembers.CreateExternalMemberCommand;
import com.bcxin.tenant.domain.services.commands.externalMembers.CreateOrgExternalMemberCommand;
import com.bcxin.tenant.domain.services.commands.externalMembers.DeleteExternalMemberCommand;
import com.bcxin.tenant.domain.services.commands.externalMembers.UpdateExternalMemberCommand;
import com.bcxin.tenant.domain.services.commands.externalMembers.UpdateExternalMemberStatusCommand;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExternalMemberServiceImpl
implements ExternalMemberService {
    private final UnitWork unitWork;
    private final IdWorker idWorker;
    private final ExternalMemberRepository externalMemberRepository;
    private final ExternalGroupRepository externalGroupRepository;
    private final OrganizationRepository organizationRepository;
    private final TenantUserRepository userRepository;
    private final EmployeeRepository employeeRepository;
    private final JsonProvider jsonProvider;
    private final EventDispatcher eventDispatcher;

    public ExternalMemberServiceImpl(UnitWork unitWork, IdWorker idWorker, ExternalMemberRepository externalMemberRepository, ExternalGroupRepository externalGroupRepository, OrganizationRepository organizationRepository, TenantUserRepository userRepository, EmployeeRepository employeeRepository, JsonProvider jsonProvider, EventDispatcher eventDispatcher) {
        this.unitWork = unitWork;
        this.idWorker = idWorker;
        this.externalMemberRepository = externalMemberRepository;
        this.externalGroupRepository = externalGroupRepository;
        this.organizationRepository = organizationRepository;
        this.userRepository = userRepository;
        this.employeeRepository = employeeRepository;
        this.jsonProvider = jsonProvider;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public void update(UpdateExternalMemberCommand command) {
        Collection<ExternalMemberEntity> externalMembers = this.externalMemberRepository.getByIds(command.getIds());
        if (CollectionUtils.isEmpty(externalMembers)) {
            throw new NotFoundTenantException();
        }
        if (!externalMembers.stream().anyMatch(ix -> ix.getReferenceNumber().equalsIgnoreCase(command.getReferenceNumber()))) {
            throw new ForbidTenantException("\u7981\u6b62\u4fee\u6539\u8be5\u5206\u7ec4\u4eba\u5458\u4fe1\u606f");
        }
        Collection<ExternalGroupEntity> addGroups = null;
        if (!CollectionUtils.isEmpty(command.getAddGroupIds())) {
            addGroups = this.externalGroupRepository.getByIds(command.getAddGroupIds());
        }
        for (ExternalMemberEntity externalMember : externalMembers) {
            externalMember.resetGroups();
            externalMember.join(this.jsonProvider, addGroups);
            externalMember.markOperateLog(command.getOperatorId(), command.getOperatorName());
            this.unitWork.executeTran(() -> this.externalMemberRepository.save(externalMember));
        }
    }

    @Override
    public void create(CreateExternalMemberCommand command) {
        ExternalMemberEntity externalMember;
        OrganizationEntity organization = this.organizationRepository.findById(command.getReferenceNumber()).orElse(null);
        if (organization == null) {
            throw new NotFoundTenantException(String.format("\u5f53\u524d\u7ec4\u7ec7(%s)\u65e0\u6548", command.getReferenceNumber()));
        }
        TenantUserEntity tenantUser = this.userRepository.findById(command.getTenantUserId()).orElse(null);
        if (tenantUser == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        ExternalGroupEntity group = null;
        if (StringUtils.hasLength((String)command.getGroupId())) {
            group = this.externalGroupRepository.findById(command.getGroupId()).orElse(null);
        }
        if ((externalMember = this.externalMemberRepository.getByTenantUserIdAndRefNumAndRefType(tenantUser.getId(), organization.getId(), ResourceReferenceType.Organization)) != null) {
            this.checkAndChangeExternalMember(externalMember, tenantUser, organization);
        } else {
            String empId = this.employeeRepository.getByOrgIdAndUserId(organization.getId(), tenantUser.getId());
            externalMember = ExternalMemberEntity.create(this.jsonProvider, empId, command.getInviteType(), command.getInviteCode(), tenantUser, group, organization);
        }
        Collection<String> adminMemberIds = this.externalMemberRepository.getAdminIds(organization.getId());
        try {
            ExternalMemberEntity finalExternalMember = externalMember;
            this.unitWork.executeTran(() -> {
                this.externalMemberRepository.save(finalExternalMember);
                this.eventDispatcher.dispatch((DomainEventAbstract)MemberCreatedEvent.create(finalExternalMember.getId(), organization.getId(), finalExternalMember.getMemberType(), tenantUser.getName(), tenantUser.getTelephone(), organization.getName(), adminMemberIds, false));
            });
        }
        catch (Exception ex) {
            if (DomainConstraint.isUniqueConstraintIssue(ex)) {
                externalMember = this.externalMemberRepository.getByTenantUserIdAndRefNumAndRefType(tenantUser.getId(), organization.getId(), ResourceReferenceType.Organization);
                if (externalMember != null) {
                    this.checkAndChangeExternalMember(externalMember, tenantUser, organization);
                    ExternalMemberEntity finalExternalMember1 = externalMember;
                    this.unitWork.executeTran(() -> {
                        this.externalMemberRepository.save(finalExternalMember1);
                        this.eventDispatcher.dispatch((DomainEventAbstract)MemberCreatedEvent.create(finalExternalMember1.getId(), organization.getId(), finalExternalMember1.getMemberType(), tenantUser.getName(), tenantUser.getTelephone(), organization.getName(), adminMemberIds, true));
                    });
                } else {
                    throw ex;
                }
            }
            throw ex;
        }
    }

    @Override
    public void delete(DeleteExternalMemberCommand command) {
        Collection<ExternalMemberEntity> externalMembers = this.getAllowedMembers(command.getIds(), command.getReferenceNumber());
        if (CollectionUtils.isEmpty(externalMembers) && !CollectionUtils.isEmpty(command.getIds())) {
            throw new ArgumentTenantException("\u65e0\u6548\u53c2\u6570\u4fe1\u606f(\u975e\u6cd5\u5220\u9664\u975e\u8be5\u7ec4\u7ec7\u6570\u636e)");
        }
        this.unitWork.executeTran(() -> {
            for (ExternalMemberEntity member : externalMembers) {
                member.delete(command.getOperatorId(), command.getOperatorName());
                this.externalMemberRepository.save(member);
            }
        });
    }

    @Override
    public void updateStatus(UpdateExternalMemberStatusCommand command) {
        Collection<ExternalMemberEntity> externalMembers = this.getAllowedMembers(command.getIds(), command.getReferenceNumber());
        if (CollectionUtils.isEmpty(externalMembers) && !CollectionUtils.isEmpty(command.getIds())) {
            throw new ArgumentTenantException("\u65e0\u6548\u53c2\u6570\u4fe1\u606f(\u975e\u6cd5\u5220\u9664\u975e\u8be5\u7ec4\u7ec7\u6570\u636e)");
        }
        if (command.getStatus() == ApprovedStatus.Init) {
            throw new ForbidTenantException("\u4e0d\u5141\u8bb8\u91cd\u7f6e\u5ba1\u6279\u72b6\u6001");
        }
        this.unitWork.executeTran(() -> {
            for (ExternalMemberEntity member : externalMembers) {
                member.changeStatus(command.getStatus(), command.getNote(), command.getOperatorId(), command.getOperatorName());
                this.externalMemberRepository.save(member);
            }
        });
    }

    @Override
    public void create(CreateOrgExternalMemberCommand command) {
        this.unitWork.executeTran(() -> {
            ExternalMemberEntity externalMember = ExternalMemberEntity.create(this.jsonProvider, command.getTenantUser(), command.getOrganization());
            this.externalMemberRepository.save(externalMember);
        });
    }

    private Collection<ExternalMemberEntity> getAllowedMembers(Collection<String> ids, String referenceNumber) {
        Collection externalMembers = this.externalMemberRepository.getByIds(ids).stream().filter(ii -> ii.getReferenceNumber().equalsIgnoreCase(referenceNumber)).collect(Collectors.toList());
        return externalMembers;
    }

    private void checkAndChangeExternalMember(ExternalMemberEntity externalMember, TenantUserEntity tenantUser, OrganizationEntity organization) {
        if (externalMember.getApprovedInformationValueType().getStatus() != ApprovedStatus.NoPassed && externalMember.getApprovedInformationValueType().getStatus() != ApprovedStatus.Deleted) {
            throw new ConflictTenantException(String.format("\u8be5\u7528\u6237(%s)\u5df2\u5b58\u5728\uff08%s\uff09\u63d0\u4ea4\u8bb0\u5f55, \u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4!", tenantUser.getName(), organization.getName()));
        }
        externalMember.changeStatus(ApprovedStatus.Init, "\u91cd\u65b0\u7533\u8bf7\u52a0\u5165", externalMember.getId(), tenantUser.getName());
    }
}

