/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands;

import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.tenant.domain.configs.TenantUserConfig;
import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.snapshots.EmployeeImportedItemSnapshot;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BatchImportEmployeeCommand
extends CommandAbstract {
    private final String organizationId;
    private final String institutionalCode;
    private final String path;
    private final Collection<EmployeeCommandItem> commandItems;

    public BatchImportEmployeeCommand(String organizationId, String institutionalCode, String path, Collection<EmployeeCommandItem> commandItems) {
        this.organizationId = organizationId;
        this.institutionalCode = institutionalCode;
        this.path = path;
        this.commandItems = commandItems;
    }

    public Collection<String> getFormatDepartNames() {
        return this.commandItems.stream().filter(ii -> ii.getDataItem() != null).map(ii -> ii.getDepartName()).filter(ii -> StringUtils.hasLength((String)ii)).distinct().collect(Collectors.toList());
    }

    public static BatchImportEmployeeCommand create(String organizationId, String institutionalCode, String path, Collection<EmployeeCommandItem> commandItems) {
        return new BatchImportEmployeeCommand(organizationId, institutionalCode, path, commandItems);
    }

    public void validate() {
        this.validate(null);
    }

    public void validate(TenantUserConfig tenantUserConfig) {
        if (CollectionUtils.isEmpty(this.commandItems)) {
            throw new ArgumentTenantException("\u5f85\u5bfc\u5165\u7684\u4fdd\u5b89\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.commandItems.forEach(ix -> {
            try {
                ix.validate(tenantUserConfig);
            }
            catch (TenantExceptionAbstract ex) {
                ix.addError(ex.getMessage());
            }
        });
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public String getPath() {
        return this.path;
    }

    public Collection<EmployeeCommandItem> getCommandItems() {
        return this.commandItems;
    }

    public static class EmployeeCommandItem
    extends CommandAbstract {
        private final EmployeeImportedItemSnapshot dataItem;
        private boolean requiredPhoneAsLoginName = false;
        private String organizationId;
        private String institutionalCode;

        public void setRequiredPhoneAsLoginName(boolean requiredPhoneAsLoginName) {
            this.requiredPhoneAsLoginName = requiredPhoneAsLoginName;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public EmployeeCommandItem(EmployeeImportedItemSnapshot dataItem) {
            this.dataItem = dataItem;
        }

        public EmployeeCommandItem(EmployeeImportedItemSnapshot dataItem, String institutionalCode) {
            this.dataItem = dataItem;
            this.institutionalCode = institutionalCode;
        }

        public static EmployeeCommandItem create(String institutionalCode, int paramIndex, String name, String telephone, String departName, String occupationTypeText, String positionText, String hiredDate, String credentialTypeText, String credentialNumber, String nation, String education, String politicsStatus, String militaryStatus, String maritalStatus, String emergencyContact, String emergencyPhone, String address, String householdType) {
            return new EmployeeCommandItem(new EmployeeImportedItemSnapshot(paramIndex, name, telephone, departName, occupationTypeText, positionText, hiredDate, credentialTypeText, credentialNumber, nation, education, politicsStatus, militaryStatus, maritalStatus, emergencyContact, emergencyPhone, address, householdType), institutionalCode);
        }

        public static EmployeeCommandItem create(EmployeeImportedItemSnapshot snapshot) {
            return new EmployeeCommandItem(snapshot);
        }

        @JsonIgnore
        public OccupationType getOccupationType() {
            if (StrUtil.isEmpty((CharSequence)this.getDataItem().getOccupationTypeText())) {
                return null;
            }
            switch (this.getDataItem().getOccupationTypeText()) {
                case "\u4e00\u822c\u804c\u5458": {
                    return OccupationType.Normal;
                }
                case "\u4fdd\u5b89\u5458": {
                    return OccupationType.SecurityGuard;
                }
                case "\u8b66\u5458": {
                    return OccupationType.Police;
                }
            }
            throw new ArgumentTenantException("\u804c\u4e1a\u7c7b\u578b\u65e0\u6548");
        }

        @JsonIgnore
        public CredentialType getCredentialType() {
            if (StrUtil.isEmpty((CharSequence)this.getDataItem().getCredentialTypeText())) {
                throw new ArgumentTenantException("\u8bc1\u4ef6\u7c7b\u578b\u65e0\u6548");
            }
            if (StringUtils.hasLength((String)this.getDataItem().getCredentialTypeText())) {
                switch (this.getDataItem().getCredentialTypeText()) {
                    case "\u5c45\u6c11\u8eab\u4efd\u8bc1\uff08\u6237\u53e3\u7c3f\uff09": 
                    case "\u5c45\u6c11\u8eab\u4efd\u8bc1/\u6237\u53e3\u7c3f": {
                        return CredentialType.IdCard;
                    }
                    case "\u6c11\u8b66": 
                    case "\u8b66\u53f7": {
                        return CredentialType.PoliceNo;
                    }
                }
            }
            throw new ArgumentTenantException("\u8bc1\u4ef6\u7c7b\u578b\u65e0\u6548");
        }

        @JsonIgnore
        public Collection<String> getFormattedDepartNames() {
            if (!StringUtils.hasLength((String)this.getDataItem().getDepartTreeName())) {
                return Collections.EMPTY_LIST;
            }
            return Arrays.stream(this.getDataItem().getDepartTreeName().split("/")).filter(ii -> !StringUtils.hasLength((String)ii)).collect(Collectors.toList());
        }

        @JsonIgnore
        public String getDepartName() {
            if (!StringUtils.hasLength((String)this.getDataItem().getDepartTreeName())) {
                return null;
            }
            if (!this.getDataItem().getDepartTreeName().contains("/")) {
                return this.getDataItem().getDepartTreeName();
            }
            int lastIndex = this.getDataItem().getDepartTreeName().lastIndexOf("/");
            return this.getDataItem().getDepartTreeName().substring(lastIndex + 1);
        }

        @JsonIgnore
        public Date getHiredDate() {
            if (!StringUtils.hasLength((String)this.getDataItem().getHiredDateText())) {
                return null;
            }
            return DateUtil.fromString((String)this.getDataItem().getHiredDateText());
        }

        public void validate() {
            this.validate(null);
        }

        public void validate(TenantUserConfig tenantUserConfig) {
            super.validate();
            this.checkParameter(() -> {
                if (!(!StringUtils.hasLength((String)this.getDataItem().getEducation()) || this.getDataItem().getEducation().equals("\u521d\u4e2d") || this.getDataItem().getEducation().equals("\u9ad8\u4e2d") || this.getDataItem().getEducation().equals("\u4e2d\u4e13") || this.getDataItem().getEducation().equals("\u5927\u4e13") || this.getDataItem().getEducation().equals("\u672c\u79d1") || this.getDataItem().getEducation().equals("\u7855\u58eb\u7814\u7a76\u751f\u53ca\u4ee5\u4e0a"))) {
                    throw new ArgumentTenantException("\u201c\u6587\u5316\u7a0b\u5ea6\u201d\u9879\u4e0d\u7b26\u5408\u9009\u9879\u8981\u6c42\uff01");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getDataItem().getName())) {
                    throw new ArgumentTenantException("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getDataItem().getTelephone())) {
                    throw new ArgumentTenantException("\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!PhoneUtil.isPhone((CharSequence)this.getDataItem().getTelephone()) && !PhoneUtil.isTel((CharSequence)this.getDataItem().getTelephone())) {
                    throw new ArgumentTenantException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
            });
            this.checkParameter(() -> {
                if (StringUtils.hasLength((String)this.getDataItem().getEmergencyPhone()) && !PhoneUtil.isPhone((CharSequence)this.getDataItem().getEmergencyPhone()) && !PhoneUtil.isTel((CharSequence)this.getDataItem().getEmergencyPhone())) {
                    throw new ArgumentTenantException("\u7d27\u6025\u8054\u7cfb\u4eba\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
            });
            if (this.isRequiredPhoneAsLoginName()) {
                this.checkParameter(() -> {
                    if (StrUtil.isEmpty((CharSequence)this.getDataItem().getCredentialNumber())) {
                        throw new ArgumentTenantException("\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StrUtil.isEmpty((CharSequence)this.getDataItem().getCredentialTypeText())) {
                        throw new ArgumentTenantException("\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            }
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getDataItem().getHiredDateText())) {
                    throw new ArgumentTenantException("\u5165\u804c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (DateUtil.fromString((String)this.getDataItem().getHiredDateText()) == null) {
                    throw new ArgumentTenantException("\u5165\u804c\u65e5\u671f\u4e0d\u7b26\u5408\u683c\u5f0f\u8981\u6c42");
                }
                if (tenantUserConfig != null && tenantUserConfig.isHiredDateMustBeToday() && !DateUtil.format2ShortDate().equals(DateUtil.format2ShortDate((Date)this.getHiredDate()))) {
                    throw new ArgumentTenantException("\u5165\u804c\u65e5\u671f\u5fc5\u987b\u662f\u5f53\u5929");
                }
            });
            this.checkParameter(() -> {
                if (!StringUtils.hasLength((String)this.getDataItem().getOccupationTypeText())) {
                    throw new ArgumentTenantException("\u804c\u4e1a\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> {
                if (StringUtils.hasLength((String)this.getInstitutionalCode()) && (this.getInstitutionalCode().startsWith("04") || this.getInstitutionalCode().startsWith("06") || this.getInstitutionalCode().startsWith("07")) && !this.getInstitutionalCode().endsWith("07") && !this.getInstitutionalCode().endsWith("08") && !this.getInstitutionalCode().endsWith("09") && !StringUtils.hasLength((String)this.getDataItem().getPositionText())) {
                    throw new ArgumentTenantException("\u5c97\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            this.checkParameter(() -> this.getCredentialType());
            if (this.getOccupationType() != null && this.getCredentialType() != null) {
                this.checkParameter(() -> this.getOccupationType().validate(this.getCredentialType(), this.getDataItem().getCredentialNumber(), AuthUtil.getAreaCode(), this.getInstitutionalCode()));
            }
            if (OccupationType.SecurityGuard.equals((Object)this.getOccupationType())) {
                this.checkParameter(() -> {
                    CredentialType credentialType = this.getCredentialType();
                    if (CredentialType.IdCard != credentialType) {
                        throw new ArgumentTenantException("\u804c\u4e1a\u7c7b\u578b\u4e3a\u4fdd\u5b89\u5458\u65f6, \u8bc1\u4ef6\u7c7b\u578b\u7c7b\u578b\u5fc5\u987b\u4e3a: \u5c45\u6c11\u8eab\u4efd\u8bc1/\u6237\u53e3\u7c3f");
                    }
                });
            }
        }

        public DepartmentEntity validateDepartTree(Collection<DepartmentEntity> selectedDeparts) {
            AtomicReference matchedDepart = new AtomicReference();
            this.checkParameter(() -> {
                for (DepartmentEntity department : selectedDeparts) {
                    String expectedDepartTreeName = this.getDataItem().getDepartTreeName();
                    if ((department.getParent() != null || StringUtils.hasLength((String)expectedDepartTreeName)) && !department.getFullPath().equals(expectedDepartTreeName)) continue;
                    matchedDepart.set(department);
                    break;
                }
                if (matchedDepart.get() == null) {
                    throw new ArgumentTenantException(String.format("\u90e8\u95e8(%s)\u8def\u5f84\u65e0\u6548", this.getDataItem().getDepartTreeName()));
                }
            });
            return (DepartmentEntity)((Object)matchedDepart.get());
        }

        public String toString() {
            return String.format("\u59d3\u540d=%s;\u90e8\u95e8=%s;\u5165\u804c\u65e5\u671f=%s;\u804c\u4e1a=%s;\u8bc1\u4ef6\u7c7b\u578b=%s;\u8bc1\u4ef6\u53f7=%s;\u7ed3\u679c=%s;", this.dataItem.getName(), this.dataItem.getDepartTreeName(), this.dataItem.getHiredDateText(), this.dataItem.getOccupationTypeText(), this.dataItem.getCredentialTypeText(), this.dataItem.getCredentialNumber(), this.getErrorResult());
        }

        public EmployeeImportedItemSnapshot getDataItem() {
            return this.dataItem;
        }

        public boolean isRequiredPhoneAsLoginName() {
            return this.requiredPhoneAsLoginName;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public String getInstitutionalCode() {
            return this.institutionalCode;
        }
    }
}

