/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.DepartImPermissionType;
import com.bcxin.Infrastructures.enums.OnlineOfflineStatus;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.tenant.domain.entities.DepartmentAdminEntity;
import com.bcxin.tenant.domain.entities.DepartmentEmployeeRelationEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.events.DepartmentCreatedEvent;
import com.bcxin.tenant.domain.snapshots.DepartImAllowedDepartSnapshot;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ConstraintMode;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.util.StringUtils;

@Table(name="tenant_departments")
@Entity
public class DepartmentEntity
extends EntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="code", nullable=false, length=50)
    private String code;
    @Column(nullable=false, length=200)
    private String name;
    @Column(name="display_order", nullable=false)
    private int displayOrder;
    @Column(nullable=false, name="created_time")
    private Timestamp createdTime;
    @Column(nullable=true, name="last_updated_time")
    private Timestamp lastUpdatedTime;
    @Column(name="total_member", nullable=false)
    private int totalMember;
    @Column(name="index_tree", nullable=false, length=2000)
    private String indexTree;
    @Column(name="level", nullable=false)
    private int level;
    @Column(name="status", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    public OnlineOfflineStatus status;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent_id", referencedColumnName="id", foreignKey=@ForeignKey(name="fk_tenant_depart_parent_id", value=ConstraintMode.CONSTRAINT))
    private DepartmentEntity parent;
    @OneToMany(mappedBy="parent", cascade={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE}, fetch=FetchType.LAZY)
    private Collection<DepartmentEntity> children;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="organization_id", referencedColumnName="id", nullable=false, foreignKey=@ForeignKey(name="fk_tenant_depart_organization_id", value=ConstraintMode.CONSTRAINT))
    private OrganizationEntity organization;
    @OneToMany(mappedBy="department", cascade={CascadeType.ALL})
    private Collection<DepartmentEmployeeRelationEntity> departmentEmployeeRelations;
    @OneToMany(mappedBy="department", cascade={CascadeType.ALL})
    private Collection<DepartmentAdminEntity> departmentAdmins;
    @Enumerated
    @Column(nullable=false, name="permission_type")
    private DepartImPermissionType permissionType;
    @Column(name="permission_config", length=2000)
    private String permissionConfig;
    @Column(nullable=false, name="is_deleted")
    private boolean deleted = false;

    public DepartmentEntity addChild(String name, int displayOrder) {
        Optional<DepartmentEntity> departmentOptional;
        Collection<DepartmentEntity> departmentEntities = this.getChildren();
        if (departmentEntities == null) {
            departmentEntities = new ArrayList<DepartmentEntity>();
        }
        if ((departmentOptional = departmentEntities.stream().filter(ii -> ii.getName().equals(name)).findFirst()).isPresent()) {
            departmentOptional.get().change(name, displayOrder);
            return departmentOptional.get();
        }
        DepartmentEntity department = DepartmentEntity.create(this.getOrganization(), this, name, null, displayOrder);
        departmentEntities.add(department);
        this.setChildren(departmentEntities);
        return department;
    }

    public void change(String name, int displayOrder) {
        this.setName(name);
        this.setDisplayOrder(displayOrder);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void change(DepartImPermissionType permissionType, DepartImAllowedDepartSnapshot snapshot, JsonProvider jsonProvider) {
        this.setPermissionType(permissionType);
        this.setPermissionConfig(jsonProvider.getJson((Object)snapshot));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void changeStatus(OnlineOfflineStatus status) {
        this.setStatus(status);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void changeSubNodeParent(DepartmentEntity department) {
        if (department.getIndexTree().startsWith(this.getIndexTree())) {
            throw new BadTenantException(String.format("\u4e0d\u80fd\u5c06\u5176\u5b50\u90e8\u95e8(%s)\u8bbe\u7f6e\u4e3a\u8be5\u90e8\u95e8\u7684\u7236\u90e8\u95e8", department.getName()));
        }
        this.changeParent(department);
    }

    private void changeParent(DepartmentEntity department) {
        if (department == null) {
            return;
        }
        this.setParent(department);
        String indexTree = String.format("%s-%s", department.getIndexTree(), this.getId());
        this.setIndexTree(indexTree);
        this.setLevel(department.getLevel() + 1);
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void moveEmployeesTo(DepartmentEntity destDepartment) {
        this.getDepartmentEmployeeRelations().forEach(ix -> ix.gotoDepartment(destDepartment));
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void moveEmployeesFrom(Collection<DepartmentEntity> sourceDepartments) {
        for (DepartmentEntity department : sourceDepartments) {
            department.moveEmployeesTo(this);
        }
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
    }

    public void incrEmployee() {
        this.setTotalMember(this.getTotalMember() + 1);
    }

    public void declEmployee() {
        this.setTotalMember(this.getTotalMember() - 1);
    }

    protected DepartmentEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setDisplayOrder(0);
        this.setLevel(0);
        this.setStatus(OnlineOfflineStatus.Online);
    }

    public static DepartmentEntity createRoot(OrganizationEntity organization, String name, int displayOrder) {
        assert (organization != null);
        DepartmentEntity department = new DepartmentEntity();
        department.setId(UUIDUtil.getShortUuid());
        department.setCode(department.getId());
        department.setName(name);
        department.setOrganization(organization);
        department.setDisplayOrder(displayOrder);
        department.setIndexTree(department.getId());
        department.setPermissionType(DepartImPermissionType.JustOnDepart);
        department.recordEvent(DepartmentCreatedEvent.create(department));
        return department;
    }

    public static DepartmentEntity create(OrganizationEntity organization, DepartmentEntity parent, String name, String code, int displayOrder) {
        assert (organization != null);
        DepartmentEntity department = DepartmentEntity.create(organization, name, code, displayOrder);
        department.changeParent(parent);
        return department;
    }

    private static DepartmentEntity create(OrganizationEntity organization, String name, String code, int displayOrder) {
        assert (organization != null);
        DepartmentEntity department = new DepartmentEntity();
        department.setId(UUIDUtil.getShortUuid());
        if (!StringUtils.hasLength((String)code)) {
            code = department.getId();
        }
        department.setName(name);
        department.setCode(code);
        department.setOrganization(organization);
        department.setDisplayOrder(displayOrder);
        department.setIndexTree(department.getId());
        department.setPermissionType(DepartImPermissionType.JustOnDepart);
        department.recordEvent(DepartmentCreatedEvent.create(department));
        return department;
    }

    @Transient
    public String getFullPath() {
        StringBuilder fullDepartPathName = new StringBuilder();
        int index = 0;
        for (DepartmentEntity loopDepartment = this; loopDepartment != null; loopDepartment = loopDepartment.getParent()) {
            if (index > 0) {
                fullDepartPathName.insert(0, "/");
            }
            fullDepartPathName.insert(0, loopDepartment.getName());
            if (++index <= 100) continue;
            break;
        }
        return fullDepartPathName.toString();
    }

    public void resetIndexTree(String indexTree) {
        this.setIndexTree(indexTree);
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public Timestamp getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public int getTotalMember() {
        return this.totalMember;
    }

    public String getIndexTree() {
        return this.indexTree;
    }

    public int getLevel() {
        return this.level;
    }

    public OnlineOfflineStatus getStatus() {
        return this.status;
    }

    public DepartmentEntity getParent() {
        return this.parent;
    }

    public Collection<DepartmentEntity> getChildren() {
        return this.children;
    }

    public OrganizationEntity getOrganization() {
        return this.organization;
    }

    public Collection<DepartmentEmployeeRelationEntity> getDepartmentEmployeeRelations() {
        return this.departmentEmployeeRelations;
    }

    public Collection<DepartmentAdminEntity> getDepartmentAdmins() {
        return this.departmentAdmins;
    }

    public DepartImPermissionType getPermissionType() {
        return this.permissionType;
    }

    public String getPermissionConfig() {
        return this.permissionConfig;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    protected void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    protected void setLastUpdatedTime(Timestamp lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    protected void setTotalMember(int totalMember) {
        this.totalMember = totalMember;
    }

    protected void setIndexTree(String indexTree) {
        this.indexTree = indexTree;
    }

    protected void setLevel(int level) {
        this.level = level;
    }

    protected void setStatus(OnlineOfflineStatus status) {
        this.status = status;
    }

    protected void setParent(DepartmentEntity parent) {
        this.parent = parent;
    }

    protected void setChildren(Collection<DepartmentEntity> children) {
        this.children = children;
    }

    protected void setOrganization(OrganizationEntity organization) {
        this.organization = organization;
    }

    protected void setDepartmentEmployeeRelations(Collection<DepartmentEmployeeRelationEntity> departmentEmployeeRelations) {
        this.departmentEmployeeRelations = departmentEmployeeRelations;
    }

    protected void setDepartmentAdmins(Collection<DepartmentAdminEntity> departmentAdmins) {
        this.departmentAdmins = departmentAdmins;
    }

    protected void setPermissionType(DepartImPermissionType permissionType) {
        this.permissionType = permissionType;
    }

    protected void setPermissionConfig(String permissionConfig) {
        this.permissionConfig = permissionConfig;
    }

    protected void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }
}

