/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.enums.ActionType;
import com.bcxin.Infrastructures.enums.InviteType;
import com.bcxin.Infrastructures.enums.OrganizationLevel;
import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationRelationshipCreateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizationRelationship.OrganizationRelationshipStatusUpdateRequest;
import com.bcxin.tenant.domain.entities.InviteOrganizationRelationshipEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.OrganizationRelationshipActionHistoriesEntity;
import com.bcxin.tenant.domain.entities.OrganizationRelationshipEntity;
import com.bcxin.tenant.domain.entities.OrganizationTypeEntity;
import com.bcxin.tenant.domain.repositories.InviteOrganizationRelationshipRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRelationshipActionHistoriesRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRelationshipRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.OrganizationTypeRepository;
import com.bcxin.tenant.domain.services.OrganizationRelationshipService;
import com.bcxin.tenant.domain.services.commands.organizationrelationship.OrganizationRelationshipInfoUpdateCommand;
import io.jsonwebtoken.lang.Collections;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrganizationRelationshipServiceImpl
implements OrganizationRelationshipService {
    private final Logger logger = LoggerFactory.getLogger(OrganizationRelationshipServiceImpl.class);
    private final OrganizationRelationshipRepository organizationRelationshipRepository;
    private final OrganizationTypeRepository organizationTypeRepository;
    private final InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository;
    private final OrganizationRepository organizationRepository;
    private final UnitWork unitWork;
    private final OrganizationRelationshipActionHistoriesRepository organizationRelationshipActionHistoriesRepository;

    public OrganizationRelationshipServiceImpl(OrganizationRelationshipRepository organizationRelationshipRepository, OrganizationTypeRepository organizationTypeRepository, InviteOrganizationRelationshipRepository inviteOrganizationRelationshipRepository, OrganizationRepository organizationRepository, UnitWork unitWork, OrganizationRelationshipActionHistoriesRepository organizationRelationshipActionHistoriesRepository) {
        this.organizationRelationshipRepository = organizationRelationshipRepository;
        this.organizationTypeRepository = organizationTypeRepository;
        this.inviteOrganizationRelationshipRepository = inviteOrganizationRelationshipRepository;
        this.organizationRepository = organizationRepository;
        this.unitWork = unitWork;
        this.organizationRelationshipActionHistoriesRepository = organizationRelationshipActionHistoriesRepository;
    }

    @Override
    public void join(OrganizationRelationshipCreateRequest organizationRelationshipCreateRequest) {
        if (organizationRelationshipCreateRequest.getInviteType() == InviteType.GroupCode) {
            String organizationId;
            Optional optional;
            Collection<InviteOrganizationRelationshipEntity> inviteOrganizationRelationshipEntities = this.inviteOrganizationRelationshipRepository.findByCode(organizationRelationshipCreateRequest.getGroupCode());
            if (inviteOrganizationRelationshipEntities.size() == 0) {
                throw new ForbidTenantException("\u96c6\u56e2\u7801\u4e0d\u5b58\u5728");
            }
            if (inviteOrganizationRelationshipEntities != null && inviteOrganizationRelationshipEntities.size() > 0 && (optional = this.organizationRepository.findById(organizationId = inviteOrganizationRelationshipEntities.iterator().next().getOrganizationId())).isPresent()) {
                OrganizationEntity organization = (OrganizationEntity)((Object)optional.get());
                if (!OrganizationLevel.contain((int)organization.getOrganizationLevel(), (OrganizationLevel)OrganizationLevel.Premium)) {
                    throw new ForbidTenantException("\u8bf7\u6c42\u52a0\u5165\u7684\u7ec4\u7ec7\u4e0d\u662f\u96c6\u56e2\u7ec4\u7ec7\uff01");
                }
                TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
                if (currentUser == null) {
                    throw new ForbidTenantException("\u5fc5\u987b\u6709\u4eba\u6765\u64cd\u4f5c\u79bb\u804c");
                }
                String tranId = this.unitWork.beginTransaction();
                try {
                    OrganizationRelationshipEntity organizationRelationshipEntity = (OrganizationRelationshipEntity)this.organizationRelationshipRepository.save(OrganizationRelationshipEntity.create(organization.getId(), organization.getName(), organizationRelationshipCreateRequest.getSelectedOrganizationId(), organizationRelationshipCreateRequest.getSelectedOrganizationName(), null, null, null, null, null, organization.getId() + "---" + organizationRelationshipCreateRequest.getSelectedOrganizationId(), RelationshipsStatus.Verify, null, null, null, null, organization.getId(), currentUser.getId(), organizationRelationshipCreateRequest.getInviteType()));
                    this.organizationRelationshipActionHistoriesRepository.save(OrganizationRelationshipActionHistoriesEntity.create(organizationRelationshipEntity.getId(), ActionType.Request, "", organizationRelationshipCreateRequest.getSelectedOrganizationId(), currentUser.getId(), organizationRelationshipCreateRequest.getInviteType()));
                    this.unitWork.commit(tranId);
                }
                catch (Exception e) {
                    this.unitWork.rollback(tranId);
                    Collection<OrganizationRelationshipEntity> byOrganizationIdAndSelectedOrganizationId = this.organizationRelationshipRepository.findByOrganizationIdAndSelectedOrganizationId(organization.getId(), organizationRelationshipCreateRequest.getSelectedOrganizationId());
                    if (byOrganizationIdAndSelectedOrganizationId.size() == 0) {
                        throw e;
                    }
                    OrganizationRelationshipEntity organizationRelationshipEntity1 = byOrganizationIdAndSelectedOrganizationId.iterator().next();
                    if (organizationRelationshipEntity1.isDeleted()) {
                        String tranId2 = this.unitWork.beginTransaction();
                        try {
                            organizationRelationshipEntity1.restartRelationship(organizationRelationshipCreateRequest.getInviteType());
                            this.organizationRelationshipRepository.save(organizationRelationshipEntity1);
                            this.organizationRelationshipActionHistoriesRepository.save(OrganizationRelationshipActionHistoriesEntity.create(organizationRelationshipEntity1.getId(), ActionType.Request, "", organizationRelationshipCreateRequest.getSelectedOrganizationId(), currentUser.getId(), organizationRelationshipCreateRequest.getInviteType()));
                            this.unitWork.commit(tranId2);
                        }
                        catch (Exception e2) {
                            this.unitWork.rollback(tranId2);
                            throw e2;
                        }
                    }
                    throw new ForbidTenantException("\u7ec4\u7ec7\u5173\u7cfb\u5df2\u5b58\u5728");
                }
            }
        }
    }

    @Override
    public void updateOrganizationRelationshipStatus(String organizationId, OrganizationRelationshipStatusUpdateRequest organizationRelationshipStatusUpdateRequest) {
        OrganizationEntity organization;
        OrganizationRelationshipEntity organizationRelationshipEntity = this.organizationRelationshipRepository.findById(organizationRelationshipStatusUpdateRequest.getId());
        if (organizationRelationshipEntity == null) {
            throw new ForbidTenantException("\u7ec4\u7ec7\u5173\u7cfb\u4e0d\u5b58\u5728\uff01");
        }
        if (!organizationRelationshipEntity.getOrganizationId().equals(organizationId)) {
            throw new ForbidTenantException("\u5f53\u524d\u96c6\u56e2\u7ec4\u7ec7\u65e0\u6548\uff01");
        }
        Optional optional = this.organizationRepository.findById(organizationId);
        if (optional.isPresent() && !OrganizationLevel.contain((int)(organization = (OrganizationEntity)((Object)optional.get())).getOrganizationLevel(), (OrganizationLevel)OrganizationLevel.Premium)) {
            throw new ForbidTenantException("\u5f53\u524d\u7ec4\u7ec7\u4e0d\u662f\u96c6\u56e2\u7ec4\u7ec7\uff01");
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            organizationRelationshipEntity.changeRelationshipStatus(organizationRelationshipStatusUpdateRequest.getStatus());
            this.organizationRelationshipRepository.save(organizationRelationshipEntity);
            TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
            if (organizationRelationshipStatusUpdateRequest.getStatus() == RelationshipsStatus.Related) {
                this.organizationRelationshipActionHistoriesRepository.save(OrganizationRelationshipActionHistoriesEntity.create(organizationRelationshipStatusUpdateRequest.getId(), ActionType.Confirm, "", organizationId, currentUser.getId(), organizationRelationshipEntity.getInviteType()));
            } else if (organizationRelationshipStatusUpdateRequest.getStatus() == RelationshipsStatus.TargetVerify || organizationRelationshipStatusUpdateRequest.getStatus() == RelationshipsStatus.Verify) {
                this.organizationRelationshipActionHistoriesRepository.save(OrganizationRelationshipActionHistoriesEntity.create(organizationRelationshipStatusUpdateRequest.getId(), ActionType.Request, "", organizationId, currentUser.getId(), organizationRelationshipEntity.getInviteType()));
            } else {
                this.organizationRelationshipActionHistoriesRepository.save(OrganizationRelationshipActionHistoriesEntity.create(organizationRelationshipStatusUpdateRequest.getId(), ActionType.Refuse, "", organizationId, currentUser.getId(), organizationRelationshipEntity.getInviteType()));
            }
            this.unitWork.commit(tranId);
        }
        catch (Exception e) {
            this.unitWork.rollback(tranId);
            throw e;
        }
    }

    @Override
    public void updateOrganizationRelationshipInfo(OrganizationRelationshipInfoUpdateCommand command) {
        OrganizationRelationshipEntity organizationRelationshipEntity = this.organizationRelationshipRepository.findById(command.getId());
        if (organizationRelationshipEntity == null || !command.getOrganizationId().equals(organizationRelationshipEntity.getOrganizationId())) {
            throw new BadTenantException("\u7ec4\u7ec7\u5173\u7cfb\u4e0d\u5b58\u5728");
        }
        OrganizationTypeEntity organizationTypeEntity = null;
        if (command.getOrganizationTypeId() != null) {
            Optional organizationTypeOptional = this.organizationTypeRepository.findById(command.getOrganizationTypeId());
            if (organizationTypeOptional.isPresent()) {
                organizationTypeEntity = (OrganizationTypeEntity)((Object)organizationTypeOptional.get());
            } else {
                throw new BadTenantException("\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
        }
        String tranId = this.unitWork.beginTransaction();
        try {
            organizationRelationshipEntity.changeRelationshipInfo(command.getOrganizationNote(), organizationTypeEntity, command.getParentId(), command.getParentName(), command.getParentIndex(), command.getCode(), command.getContactName(), command.getContactTelephone());
            this.organizationRelationshipRepository.save(organizationRelationshipEntity);
            this.unitWork.commit(tranId);
        }
        catch (Exception e) {
            this.unitWork.rollback(tranId);
            throw e;
        }
    }

    @Override
    public void delete(Collection<Long> ids, String organizationId) {
        if (ids == null) {
            throw new ForbidTenantException("\u9700\u8981\u5220\u9664\u7ec4\u7ec7\u5173\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (organizationId.isEmpty()) {
            throw new ForbidTenantException("\u96c6\u56e2\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<OrganizationRelationshipEntity> organizationRelationshipEntities = this.organizationRelationshipRepository.findAllById(ids);
        if (!Collections.isEmpty(organizationRelationshipEntities)) {
            organizationRelationshipEntities.forEach(organizationRelationshipEntity -> organizationRelationshipEntity.removeRelationship());
            String tranId = this.unitWork.beginTransaction();
            try {
                this.organizationRelationshipRepository.saveAll(organizationRelationshipEntities);
                TenantUserContext.UserModel currentUser = TenantContext.getInstance().getUserContext().get();
                Collection organizationRelationshipActionHistoriesEntities = organizationRelationshipEntities.stream().map(organizationRelationshipEntity -> OrganizationRelationshipActionHistoriesEntity.create(organizationRelationshipEntity.getId(), ActionType.Delete, "", organizationId, currentUser.getId(), organizationRelationshipEntity.getInviteType())).collect(Collectors.toList());
                this.organizationRelationshipActionHistoriesRepository.saveAll(organizationRelationshipActionHistoriesEntities);
                this.unitWork.commit(tranId);
            }
            catch (Exception e) {
                this.unitWork.rollback(tranId);
                throw e;
            }
        }
    }
}

