/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.entities;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.PersonStatus;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

public class EmployeeExportViewEntity
extends EntityAbstract
implements IAggregate {
    @Id
    @Column(length=100)
    private String id;
    private String userId;
    @Column(name="name")
    private String name;
    @Column(name="telephone")
    private String telephone;
    @ExcelIgnore
    @Column(name="credential_type")
    private CredentialType credentialType;
    @Column(name="number")
    private String number;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="checked_status")
    private UserCheckedStatus checkedStatus;
    @Temporal(value=TemporalType.DATE)
    @Column(name="last_checked_status_time")
    private Date lastCheckedStatusTime;
    @Enumerated(value=EnumType.ORDINAL)
    @ExcelIgnore
    @Column(name="authenticated_status")
    private RealNameAuthenticatedStatus authenticateStatus;
    private String authenticatedResult;
    @Column(name="depart_name")
    private String departName;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="occupation_type")
    private OccupationType occupationType;
    @Column(name="superior_name")
    private String superiorName;
    @Column(name="position")
    private String position;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="hired_date")
    private Date hiredDate;
    @Temporal(value=TemporalType.DATE)
    @Column(name="positive_date")
    private Date positiveDate;
    @Column(name="sex")
    @Enumerated(value=EnumType.ORDINAL)
    private Sex sex;
    @Temporal(value=TemporalType.DATE)
    @Column(name="birthdate")
    private Date birthdate;
    @Column(name="nation")
    private String nation;
    @Column(name="education")
    private String education;
    @Column(name="politics_status")
    private String politicsStatus;
    @Column(name="household_type")
    private String householdType;
    @Column(name="stature")
    private String stature;
    @Column(name="native_place")
    private String nativePlace;
    @Column(name="military_status")
    private String militaryStatus;
    @Column(name="marital_status")
    private String maritalStatus;
    @Column(name="valid_date_from")
    private Date validDateFrom;
    @Column(name="valid_date_to")
    private Date validDateTo;
    @Column(name="address")
    private String address;
    @Column(name="contract_status")
    private TrueFalseStatus contractStatus = TrueFalseStatus.False;
    private boolean contractStatusValue;
    @Column(name="cer_status")
    private TrueFalseStatus cerStatus = TrueFalseStatus.False;
    private boolean cerStatusValue = false;
    @Column(name="grade_cer_status")
    private TrueFalseStatus gradeCerStatus = TrueFalseStatus.False;
    private boolean gradeCerStatusValue = false;
    @Column(name="cer_no")
    private String cerNo;
    private String gradeLevel;
    private String gradeCerNo;
    @Column(name="insure")
    private TrueFalseStatus insure;
    @Column(name="created_time")
    private Date createdTime;
    @Column(name="is_domain_admin")
    private TrueFalseStatus domainAdmin;
    @Column(name="depart_admin")
    private TrueFalseStatus departAdmin = TrueFalseStatus.False;
    @Column(name="manage_departs")
    private String manageDeparts;
    @Column(name="organ_id")
    private String organId;
    @Column(name="person_status")
    private PersonStatus personStatus;
    @Column(name="probation")
    private String probation;
    @Column(name="plan_positive_date")
    @Temporal(value=TemporalType.DATE)
    private Date planPositiveDate;
    @Column(name="emergency_contact")
    private String emergencyContact;
    @Column(name="emergency_phone")
    private String emergencyPhone;
    @Column(name="license_level")
    private String licenseLevel;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="province.code", column=@Column(name="place_Of_now_province_code")), @AttributeOverride(name="province.name", column=@Column(name="place_Of_now_province_name")), @AttributeOverride(name="city.code", column=@Column(name="place_Of_now_city_code")), @AttributeOverride(name="city.name", column=@Column(name="place_Of_now_city_name")), @AttributeOverride(name="district.code", column=@Column(name="place_Of_now_district_code")), @AttributeOverride(name="district.name", column=@Column(name="place_Of_now_district_name")), @AttributeOverride(name="address", column=@Column(name="place_Of_now_address"))})
    private LocationValueType placeOfNow;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="hired_operator_id", nullable=true, length=150)), @AttributeOverride(name="name", column=@Column(name="hired_operator_name", nullable=true, length=200)), @AttributeOverride(name="createdTime", column=@Column(name="hired_operator_created_time", nullable=true))})
    private OperatorValueType hiredOperator;

    protected EmployeeExportViewEntity() {
    }

    public EmployeeExportViewEntity(String id, String userId, String name, String telephone, CredentialType credentialType, String number, UserCheckedStatus checkedStatus, Date lastCheckedStatusTime, RealNameAuthenticatedStatus authenticateStatus, String authenticatedResult, OccupationType occupationType, String superiorName, String position, Date hiredDate, Date positiveDate, Sex sex, Date birthdate, String nation, String education, String politicsStatus, String householdType, String stature, String nativePlace, String militaryStatus, String maritalStatus, Date validDateFrom, Date validDateTo, String address, boolean contractStatusValue, TrueFalseStatus insure, Date createdTime, TrueFalseStatus domainAdmin, String organId, PersonStatus personStatus, String probation, Date planPositiveDate, String emergencyContact, String emergencyPhone, String licenseLevel, LocationValueType placeOfNow, OperatorValueType hiredOperator) {
        this.id = id;
        this.userId = userId;
        this.name = name;
        this.telephone = telephone;
        this.credentialType = credentialType;
        this.number = number;
        this.checkedStatus = checkedStatus;
        this.lastCheckedStatusTime = lastCheckedStatusTime;
        this.authenticateStatus = authenticateStatus;
        this.authenticatedResult = authenticatedResult;
        this.occupationType = occupationType;
        this.superiorName = superiorName;
        this.position = position;
        this.hiredDate = hiredDate;
        this.positiveDate = positiveDate;
        this.sex = sex;
        this.birthdate = birthdate;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.householdType = householdType;
        this.stature = stature;
        this.nativePlace = nativePlace;
        this.militaryStatus = militaryStatus;
        this.maritalStatus = maritalStatus;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.address = address;
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        this.placeOfNow = placeOfNow;
        this.hiredOperator = hiredOperator;
        if (contractStatusValue) {
            this.contractStatus = TrueFalseStatus.True;
        }
        if (this.cerStatusValue) {
            this.cerStatus = TrueFalseStatus.True;
        }
        if (this.gradeCerStatusValue) {
            this.gradeCerStatus = TrueFalseStatus.True;
        }
        this.insure = insure;
        this.createdTime = createdTime;
        this.domainAdmin = domainAdmin;
        this.organId = organId;
    }

    public void assignDepart(String name) {
        this.departName = name;
    }

    public void assignAdminDepart(String name) {
        this.manageDeparts = name;
        this.departAdmin = TrueFalseStatus.True;
    }

    public void setCerInfo(String cerNo) {
        this.cerNo = cerNo;
        if (StrUtil.isNotEmpty((CharSequence)cerNo)) {
            this.cerStatus = TrueFalseStatus.True;
            this.cerStatusValue = true;
        }
    }

    public void setGradeCerInfo(String gradeCerNo, String gradeLevel) {
        this.gradeCerNo = gradeCerNo;
        this.gradeLevel = gradeLevel;
        if (StrUtil.isNotEmpty((CharSequence)gradeCerNo)) {
            this.gradeCerStatus = TrueFalseStatus.True;
            this.gradeCerStatusValue = true;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public CredentialType getCredentialType() {
        return this.credentialType;
    }

    public String getNumber() {
        return this.number;
    }

    public UserCheckedStatus getCheckedStatus() {
        return this.checkedStatus;
    }

    public Date getLastCheckedStatusTime() {
        return this.lastCheckedStatusTime;
    }

    public RealNameAuthenticatedStatus getAuthenticateStatus() {
        return this.authenticateStatus;
    }

    public String getAuthenticatedResult() {
        return this.authenticatedResult;
    }

    public String getDepartName() {
        return this.departName;
    }

    public OccupationType getOccupationType() {
        return this.occupationType;
    }

    public String getSuperiorName() {
        return this.superiorName;
    }

    public String getPosition() {
        return this.position;
    }

    public Date getHiredDate() {
        return this.hiredDate;
    }

    public Date getPositiveDate() {
        return this.positiveDate;
    }

    public Sex getSex() {
        return this.sex;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public String getNation() {
        return this.nation;
    }

    public String getEducation() {
        return this.education;
    }

    public String getPoliticsStatus() {
        return this.politicsStatus;
    }

    public String getHouseholdType() {
        return this.householdType;
    }

    public String getStature() {
        return this.stature;
    }

    public String getNativePlace() {
        return this.nativePlace;
    }

    public String getMilitaryStatus() {
        return this.militaryStatus;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public Date getValidDateFrom() {
        return this.validDateFrom;
    }

    public Date getValidDateTo() {
        return this.validDateTo;
    }

    public String getAddress() {
        return this.address;
    }

    public TrueFalseStatus getContractStatus() {
        return this.contractStatus;
    }

    public boolean isContractStatusValue() {
        return this.contractStatusValue;
    }

    public TrueFalseStatus getCerStatus() {
        return this.cerStatus;
    }

    public boolean isCerStatusValue() {
        return this.cerStatusValue;
    }

    public TrueFalseStatus getGradeCerStatus() {
        return this.gradeCerStatus;
    }

    public boolean isGradeCerStatusValue() {
        return this.gradeCerStatusValue;
    }

    public String getCerNo() {
        return this.cerNo;
    }

    public String getGradeLevel() {
        return this.gradeLevel;
    }

    public String getGradeCerNo() {
        return this.gradeCerNo;
    }

    public TrueFalseStatus getInsure() {
        return this.insure;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public TrueFalseStatus getDomainAdmin() {
        return this.domainAdmin;
    }

    public TrueFalseStatus getDepartAdmin() {
        return this.departAdmin;
    }

    public String getManageDeparts() {
        return this.manageDeparts;
    }

    public String getOrganId() {
        return this.organId;
    }

    public PersonStatus getPersonStatus() {
        return this.personStatus;
    }

    public String getProbation() {
        return this.probation;
    }

    public Date getPlanPositiveDate() {
        return this.planPositiveDate;
    }

    public String getEmergencyContact() {
        return this.emergencyContact;
    }

    public String getEmergencyPhone() {
        return this.emergencyPhone;
    }

    public String getLicenseLevel() {
        return this.licenseLevel;
    }

    public LocationValueType getPlaceOfNow() {
        return this.placeOfNow;
    }

    public OperatorValueType getHiredOperator() {
        return this.hiredOperator;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setCheckedStatus(UserCheckedStatus checkedStatus) {
        this.checkedStatus = checkedStatus;
    }

    public void setLastCheckedStatusTime(Date lastCheckedStatusTime) {
        this.lastCheckedStatusTime = lastCheckedStatusTime;
    }

    public void setAuthenticateStatus(RealNameAuthenticatedStatus authenticateStatus) {
        this.authenticateStatus = authenticateStatus;
    }

    public void setAuthenticatedResult(String authenticatedResult) {
        this.authenticatedResult = authenticatedResult;
    }

    public void setDepartName(String departName) {
        this.departName = departName;
    }

    public void setOccupationType(OccupationType occupationType) {
        this.occupationType = occupationType;
    }

    public void setSuperiorName(String superiorName) {
        this.superiorName = superiorName;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void setHiredDate(Date hiredDate) {
        this.hiredDate = hiredDate;
    }

    public void setPositiveDate(Date positiveDate) {
        this.positiveDate = positiveDate;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }

    public void setEducation(String education) {
        this.education = education;
    }

    public void setPoliticsStatus(String politicsStatus) {
        this.politicsStatus = politicsStatus;
    }

    public void setHouseholdType(String householdType) {
        this.householdType = householdType;
    }

    public void setStature(String stature) {
        this.stature = stature;
    }

    public void setNativePlace(String nativePlace) {
        this.nativePlace = nativePlace;
    }

    public void setMilitaryStatus(String militaryStatus) {
        this.militaryStatus = militaryStatus;
    }

    public void setMaritalStatus(String maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    public void setValidDateFrom(Date validDateFrom) {
        this.validDateFrom = validDateFrom;
    }

    public void setValidDateTo(Date validDateTo) {
        this.validDateTo = validDateTo;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setContractStatus(TrueFalseStatus contractStatus) {
        this.contractStatus = contractStatus;
    }

    public void setContractStatusValue(boolean contractStatusValue) {
        this.contractStatusValue = contractStatusValue;
    }

    public void setCerStatus(TrueFalseStatus cerStatus) {
        this.cerStatus = cerStatus;
    }

    public void setCerStatusValue(boolean cerStatusValue) {
        this.cerStatusValue = cerStatusValue;
    }

    public void setGradeCerStatus(TrueFalseStatus gradeCerStatus) {
        this.gradeCerStatus = gradeCerStatus;
    }

    public void setGradeCerStatusValue(boolean gradeCerStatusValue) {
        this.gradeCerStatusValue = gradeCerStatusValue;
    }

    public void setCerNo(String cerNo) {
        this.cerNo = cerNo;
    }

    public void setGradeLevel(String gradeLevel) {
        this.gradeLevel = gradeLevel;
    }

    public void setGradeCerNo(String gradeCerNo) {
        this.gradeCerNo = gradeCerNo;
    }

    public void setInsure(TrueFalseStatus insure) {
        this.insure = insure;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public void setDomainAdmin(TrueFalseStatus domainAdmin) {
        this.domainAdmin = domainAdmin;
    }

    public void setDepartAdmin(TrueFalseStatus departAdmin) {
        this.departAdmin = departAdmin;
    }

    public void setManageDeparts(String manageDeparts) {
        this.manageDeparts = manageDeparts;
    }

    public void setOrganId(String organId) {
        this.organId = organId;
    }

    public void setPersonStatus(PersonStatus personStatus) {
        this.personStatus = personStatus;
    }

    public void setProbation(String probation) {
        this.probation = probation;
    }

    public void setPlanPositiveDate(Date planPositiveDate) {
        this.planPositiveDate = planPositiveDate;
    }

    public void setEmergencyContact(String emergencyContact) {
        this.emergencyContact = emergencyContact;
    }

    public void setEmergencyPhone(String emergencyPhone) {
        this.emergencyPhone = emergencyPhone;
    }

    public void setLicenseLevel(String licenseLevel) {
        this.licenseLevel = licenseLevel;
    }

    public void setPlaceOfNow(LocationValueType placeOfNow) {
        this.placeOfNow = placeOfNow;
    }

    public void setHiredOperator(OperatorValueType hiredOperator) {
        this.hiredOperator = hiredOperator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmployeeExportViewEntity)) {
            return false;
        }
        EmployeeExportViewEntity other = (EmployeeExportViewEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isContractStatusValue() != other.isContractStatusValue()) {
            return false;
        }
        if (this.isCerStatusValue() != other.isCerStatusValue()) {
            return false;
        }
        if (this.isGradeCerStatusValue() != other.isGradeCerStatusValue()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$telephone = this.getTelephone();
        String other$telephone = other.getTelephone();
        if (this$telephone == null ? other$telephone != null : !this$telephone.equals(other$telephone)) {
            return false;
        }
        CredentialType this$credentialType = this.getCredentialType();
        CredentialType other$credentialType = other.getCredentialType();
        if (this$credentialType == null ? other$credentialType != null : !this$credentialType.equals(other$credentialType)) {
            return false;
        }
        String this$number = this.getNumber();
        String other$number = other.getNumber();
        if (this$number == null ? other$number != null : !this$number.equals(other$number)) {
            return false;
        }
        UserCheckedStatus this$checkedStatus = this.getCheckedStatus();
        UserCheckedStatus other$checkedStatus = other.getCheckedStatus();
        if (this$checkedStatus == null ? other$checkedStatus != null : !this$checkedStatus.equals(other$checkedStatus)) {
            return false;
        }
        Date this$lastCheckedStatusTime = this.getLastCheckedStatusTime();
        Date other$lastCheckedStatusTime = other.getLastCheckedStatusTime();
        if (this$lastCheckedStatusTime == null ? other$lastCheckedStatusTime != null : !((Object)this$lastCheckedStatusTime).equals(other$lastCheckedStatusTime)) {
            return false;
        }
        RealNameAuthenticatedStatus this$authenticateStatus = this.getAuthenticateStatus();
        RealNameAuthenticatedStatus other$authenticateStatus = other.getAuthenticateStatus();
        if (this$authenticateStatus == null ? other$authenticateStatus != null : !this$authenticateStatus.equals(other$authenticateStatus)) {
            return false;
        }
        String this$authenticatedResult = this.getAuthenticatedResult();
        String other$authenticatedResult = other.getAuthenticatedResult();
        if (this$authenticatedResult == null ? other$authenticatedResult != null : !this$authenticatedResult.equals(other$authenticatedResult)) {
            return false;
        }
        String this$departName = this.getDepartName();
        String other$departName = other.getDepartName();
        if (this$departName == null ? other$departName != null : !this$departName.equals(other$departName)) {
            return false;
        }
        OccupationType this$occupationType = this.getOccupationType();
        OccupationType other$occupationType = other.getOccupationType();
        if (this$occupationType == null ? other$occupationType != null : !this$occupationType.equals(other$occupationType)) {
            return false;
        }
        String this$superiorName = this.getSuperiorName();
        String other$superiorName = other.getSuperiorName();
        if (this$superiorName == null ? other$superiorName != null : !this$superiorName.equals(other$superiorName)) {
            return false;
        }
        String this$position = this.getPosition();
        String other$position = other.getPosition();
        if (this$position == null ? other$position != null : !this$position.equals(other$position)) {
            return false;
        }
        Date this$hiredDate = this.getHiredDate();
        Date other$hiredDate = other.getHiredDate();
        if (this$hiredDate == null ? other$hiredDate != null : !((Object)this$hiredDate).equals(other$hiredDate)) {
            return false;
        }
        Date this$positiveDate = this.getPositiveDate();
        Date other$positiveDate = other.getPositiveDate();
        if (this$positiveDate == null ? other$positiveDate != null : !((Object)this$positiveDate).equals(other$positiveDate)) {
            return false;
        }
        Sex this$sex = this.getSex();
        Sex other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !this$sex.equals(other$sex)) {
            return false;
        }
        Date this$birthdate = this.getBirthdate();
        Date other$birthdate = other.getBirthdate();
        if (this$birthdate == null ? other$birthdate != null : !((Object)this$birthdate).equals(other$birthdate)) {
            return false;
        }
        String this$nation = this.getNation();
        String other$nation = other.getNation();
        if (this$nation == null ? other$nation != null : !this$nation.equals(other$nation)) {
            return false;
        }
        String this$education = this.getEducation();
        String other$education = other.getEducation();
        if (this$education == null ? other$education != null : !this$education.equals(other$education)) {
            return false;
        }
        String this$politicsStatus = this.getPoliticsStatus();
        String other$politicsStatus = other.getPoliticsStatus();
        if (this$politicsStatus == null ? other$politicsStatus != null : !this$politicsStatus.equals(other$politicsStatus)) {
            return false;
        }
        String this$householdType = this.getHouseholdType();
        String other$householdType = other.getHouseholdType();
        if (this$householdType == null ? other$householdType != null : !this$householdType.equals(other$householdType)) {
            return false;
        }
        String this$stature = this.getStature();
        String other$stature = other.getStature();
        if (this$stature == null ? other$stature != null : !this$stature.equals(other$stature)) {
            return false;
        }
        String this$nativePlace = this.getNativePlace();
        String other$nativePlace = other.getNativePlace();
        if (this$nativePlace == null ? other$nativePlace != null : !this$nativePlace.equals(other$nativePlace)) {
            return false;
        }
        String this$militaryStatus = this.getMilitaryStatus();
        String other$militaryStatus = other.getMilitaryStatus();
        if (this$militaryStatus == null ? other$militaryStatus != null : !this$militaryStatus.equals(other$militaryStatus)) {
            return false;
        }
        String this$maritalStatus = this.getMaritalStatus();
        String other$maritalStatus = other.getMaritalStatus();
        if (this$maritalStatus == null ? other$maritalStatus != null : !this$maritalStatus.equals(other$maritalStatus)) {
            return false;
        }
        Date this$validDateFrom = this.getValidDateFrom();
        Date other$validDateFrom = other.getValidDateFrom();
        if (this$validDateFrom == null ? other$validDateFrom != null : !((Object)this$validDateFrom).equals(other$validDateFrom)) {
            return false;
        }
        Date this$validDateTo = this.getValidDateTo();
        Date other$validDateTo = other.getValidDateTo();
        if (this$validDateTo == null ? other$validDateTo != null : !((Object)this$validDateTo).equals(other$validDateTo)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        TrueFalseStatus this$contractStatus = this.getContractStatus();
        TrueFalseStatus other$contractStatus = other.getContractStatus();
        if (this$contractStatus == null ? other$contractStatus != null : !this$contractStatus.equals(other$contractStatus)) {
            return false;
        }
        TrueFalseStatus this$cerStatus = this.getCerStatus();
        TrueFalseStatus other$cerStatus = other.getCerStatus();
        if (this$cerStatus == null ? other$cerStatus != null : !this$cerStatus.equals(other$cerStatus)) {
            return false;
        }
        TrueFalseStatus this$gradeCerStatus = this.getGradeCerStatus();
        TrueFalseStatus other$gradeCerStatus = other.getGradeCerStatus();
        if (this$gradeCerStatus == null ? other$gradeCerStatus != null : !this$gradeCerStatus.equals(other$gradeCerStatus)) {
            return false;
        }
        String this$cerNo = this.getCerNo();
        String other$cerNo = other.getCerNo();
        if (this$cerNo == null ? other$cerNo != null : !this$cerNo.equals(other$cerNo)) {
            return false;
        }
        String this$gradeLevel = this.getGradeLevel();
        String other$gradeLevel = other.getGradeLevel();
        if (this$gradeLevel == null ? other$gradeLevel != null : !this$gradeLevel.equals(other$gradeLevel)) {
            return false;
        }
        String this$gradeCerNo = this.getGradeCerNo();
        String other$gradeCerNo = other.getGradeCerNo();
        if (this$gradeCerNo == null ? other$gradeCerNo != null : !this$gradeCerNo.equals(other$gradeCerNo)) {
            return false;
        }
        TrueFalseStatus this$insure = this.getInsure();
        TrueFalseStatus other$insure = other.getInsure();
        if (this$insure == null ? other$insure != null : !this$insure.equals(other$insure)) {
            return false;
        }
        Date this$createdTime = this.getCreatedTime();
        Date other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        TrueFalseStatus this$domainAdmin = this.getDomainAdmin();
        TrueFalseStatus other$domainAdmin = other.getDomainAdmin();
        if (this$domainAdmin == null ? other$domainAdmin != null : !this$domainAdmin.equals(other$domainAdmin)) {
            return false;
        }
        TrueFalseStatus this$departAdmin = this.getDepartAdmin();
        TrueFalseStatus other$departAdmin = other.getDepartAdmin();
        if (this$departAdmin == null ? other$departAdmin != null : !this$departAdmin.equals(other$departAdmin)) {
            return false;
        }
        String this$manageDeparts = this.getManageDeparts();
        String other$manageDeparts = other.getManageDeparts();
        if (this$manageDeparts == null ? other$manageDeparts != null : !this$manageDeparts.equals(other$manageDeparts)) {
            return false;
        }
        String this$organId = this.getOrganId();
        String other$organId = other.getOrganId();
        if (this$organId == null ? other$organId != null : !this$organId.equals(other$organId)) {
            return false;
        }
        PersonStatus this$personStatus = this.getPersonStatus();
        PersonStatus other$personStatus = other.getPersonStatus();
        if (this$personStatus == null ? other$personStatus != null : !this$personStatus.equals(other$personStatus)) {
            return false;
        }
        String this$probation = this.getProbation();
        String other$probation = other.getProbation();
        if (this$probation == null ? other$probation != null : !this$probation.equals(other$probation)) {
            return false;
        }
        Date this$planPositiveDate = this.getPlanPositiveDate();
        Date other$planPositiveDate = other.getPlanPositiveDate();
        if (this$planPositiveDate == null ? other$planPositiveDate != null : !((Object)this$planPositiveDate).equals(other$planPositiveDate)) {
            return false;
        }
        String this$emergencyContact = this.getEmergencyContact();
        String other$emergencyContact = other.getEmergencyContact();
        if (this$emergencyContact == null ? other$emergencyContact != null : !this$emergencyContact.equals(other$emergencyContact)) {
            return false;
        }
        String this$emergencyPhone = this.getEmergencyPhone();
        String other$emergencyPhone = other.getEmergencyPhone();
        if (this$emergencyPhone == null ? other$emergencyPhone != null : !this$emergencyPhone.equals(other$emergencyPhone)) {
            return false;
        }
        String this$licenseLevel = this.getLicenseLevel();
        String other$licenseLevel = other.getLicenseLevel();
        if (this$licenseLevel == null ? other$licenseLevel != null : !this$licenseLevel.equals(other$licenseLevel)) {
            return false;
        }
        LocationValueType this$placeOfNow = this.getPlaceOfNow();
        LocationValueType other$placeOfNow = other.getPlaceOfNow();
        if (this$placeOfNow == null ? other$placeOfNow != null : !((Object)((Object)this$placeOfNow)).equals((Object)other$placeOfNow)) {
            return false;
        }
        OperatorValueType this$hiredOperator = this.getHiredOperator();
        OperatorValueType other$hiredOperator = other.getHiredOperator();
        return !(this$hiredOperator == null ? other$hiredOperator != null : !this$hiredOperator.equals(other$hiredOperator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmployeeExportViewEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isContractStatusValue() ? 79 : 97);
        result = result * 59 + (this.isCerStatusValue() ? 79 : 97);
        result = result * 59 + (this.isGradeCerStatusValue() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $telephone = this.getTelephone();
        result = result * 59 + ($telephone == null ? 43 : $telephone.hashCode());
        CredentialType $credentialType = this.getCredentialType();
        result = result * 59 + ($credentialType == null ? 43 : $credentialType.hashCode());
        String $number = this.getNumber();
        result = result * 59 + ($number == null ? 43 : $number.hashCode());
        UserCheckedStatus $checkedStatus = this.getCheckedStatus();
        result = result * 59 + ($checkedStatus == null ? 43 : $checkedStatus.hashCode());
        Date $lastCheckedStatusTime = this.getLastCheckedStatusTime();
        result = result * 59 + ($lastCheckedStatusTime == null ? 43 : ((Object)$lastCheckedStatusTime).hashCode());
        RealNameAuthenticatedStatus $authenticateStatus = this.getAuthenticateStatus();
        result = result * 59 + ($authenticateStatus == null ? 43 : $authenticateStatus.hashCode());
        String $authenticatedResult = this.getAuthenticatedResult();
        result = result * 59 + ($authenticatedResult == null ? 43 : $authenticatedResult.hashCode());
        String $departName = this.getDepartName();
        result = result * 59 + ($departName == null ? 43 : $departName.hashCode());
        OccupationType $occupationType = this.getOccupationType();
        result = result * 59 + ($occupationType == null ? 43 : $occupationType.hashCode());
        String $superiorName = this.getSuperiorName();
        result = result * 59 + ($superiorName == null ? 43 : $superiorName.hashCode());
        String $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : $position.hashCode());
        Date $hiredDate = this.getHiredDate();
        result = result * 59 + ($hiredDate == null ? 43 : ((Object)$hiredDate).hashCode());
        Date $positiveDate = this.getPositiveDate();
        result = result * 59 + ($positiveDate == null ? 43 : ((Object)$positiveDate).hashCode());
        Sex $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : $sex.hashCode());
        Date $birthdate = this.getBirthdate();
        result = result * 59 + ($birthdate == null ? 43 : ((Object)$birthdate).hashCode());
        String $nation = this.getNation();
        result = result * 59 + ($nation == null ? 43 : $nation.hashCode());
        String $education = this.getEducation();
        result = result * 59 + ($education == null ? 43 : $education.hashCode());
        String $politicsStatus = this.getPoliticsStatus();
        result = result * 59 + ($politicsStatus == null ? 43 : $politicsStatus.hashCode());
        String $householdType = this.getHouseholdType();
        result = result * 59 + ($householdType == null ? 43 : $householdType.hashCode());
        String $stature = this.getStature();
        result = result * 59 + ($stature == null ? 43 : $stature.hashCode());
        String $nativePlace = this.getNativePlace();
        result = result * 59 + ($nativePlace == null ? 43 : $nativePlace.hashCode());
        String $militaryStatus = this.getMilitaryStatus();
        result = result * 59 + ($militaryStatus == null ? 43 : $militaryStatus.hashCode());
        String $maritalStatus = this.getMaritalStatus();
        result = result * 59 + ($maritalStatus == null ? 43 : $maritalStatus.hashCode());
        Date $validDateFrom = this.getValidDateFrom();
        result = result * 59 + ($validDateFrom == null ? 43 : ((Object)$validDateFrom).hashCode());
        Date $validDateTo = this.getValidDateTo();
        result = result * 59 + ($validDateTo == null ? 43 : ((Object)$validDateTo).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        TrueFalseStatus $contractStatus = this.getContractStatus();
        result = result * 59 + ($contractStatus == null ? 43 : $contractStatus.hashCode());
        TrueFalseStatus $cerStatus = this.getCerStatus();
        result = result * 59 + ($cerStatus == null ? 43 : $cerStatus.hashCode());
        TrueFalseStatus $gradeCerStatus = this.getGradeCerStatus();
        result = result * 59 + ($gradeCerStatus == null ? 43 : $gradeCerStatus.hashCode());
        String $cerNo = this.getCerNo();
        result = result * 59 + ($cerNo == null ? 43 : $cerNo.hashCode());
        String $gradeLevel = this.getGradeLevel();
        result = result * 59 + ($gradeLevel == null ? 43 : $gradeLevel.hashCode());
        String $gradeCerNo = this.getGradeCerNo();
        result = result * 59 + ($gradeCerNo == null ? 43 : $gradeCerNo.hashCode());
        TrueFalseStatus $insure = this.getInsure();
        result = result * 59 + ($insure == null ? 43 : $insure.hashCode());
        Date $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        TrueFalseStatus $domainAdmin = this.getDomainAdmin();
        result = result * 59 + ($domainAdmin == null ? 43 : $domainAdmin.hashCode());
        TrueFalseStatus $departAdmin = this.getDepartAdmin();
        result = result * 59 + ($departAdmin == null ? 43 : $departAdmin.hashCode());
        String $manageDeparts = this.getManageDeparts();
        result = result * 59 + ($manageDeparts == null ? 43 : $manageDeparts.hashCode());
        String $organId = this.getOrganId();
        result = result * 59 + ($organId == null ? 43 : $organId.hashCode());
        PersonStatus $personStatus = this.getPersonStatus();
        result = result * 59 + ($personStatus == null ? 43 : $personStatus.hashCode());
        String $probation = this.getProbation();
        result = result * 59 + ($probation == null ? 43 : $probation.hashCode());
        Date $planPositiveDate = this.getPlanPositiveDate();
        result = result * 59 + ($planPositiveDate == null ? 43 : ((Object)$planPositiveDate).hashCode());
        String $emergencyContact = this.getEmergencyContact();
        result = result * 59 + ($emergencyContact == null ? 43 : $emergencyContact.hashCode());
        String $emergencyPhone = this.getEmergencyPhone();
        result = result * 59 + ($emergencyPhone == null ? 43 : $emergencyPhone.hashCode());
        String $licenseLevel = this.getLicenseLevel();
        result = result * 59 + ($licenseLevel == null ? 43 : $licenseLevel.hashCode());
        LocationValueType $placeOfNow = this.getPlaceOfNow();
        result = result * 59 + ($placeOfNow == null ? 43 : ((Object)((Object)$placeOfNow)).hashCode());
        OperatorValueType $hiredOperator = this.getHiredOperator();
        result = result * 59 + ($hiredOperator == null ? 43 : $hiredOperator.hashCode());
        return result;
    }

    public String toString() {
        return "EmployeeExportViewEntity(id=" + this.getId() + ", userId=" + this.getUserId() + ", name=" + this.getName() + ", telephone=" + this.getTelephone() + ", credentialType=" + this.getCredentialType() + ", number=" + this.getNumber() + ", checkedStatus=" + this.getCheckedStatus() + ", lastCheckedStatusTime=" + this.getLastCheckedStatusTime() + ", authenticateStatus=" + this.getAuthenticateStatus() + ", authenticatedResult=" + this.getAuthenticatedResult() + ", departName=" + this.getDepartName() + ", occupationType=" + this.getOccupationType() + ", superiorName=" + this.getSuperiorName() + ", position=" + this.getPosition() + ", hiredDate=" + this.getHiredDate() + ", positiveDate=" + this.getPositiveDate() + ", sex=" + this.getSex() + ", birthdate=" + this.getBirthdate() + ", nation=" + this.getNation() + ", education=" + this.getEducation() + ", politicsStatus=" + this.getPoliticsStatus() + ", householdType=" + this.getHouseholdType() + ", stature=" + this.getStature() + ", nativePlace=" + this.getNativePlace() + ", militaryStatus=" + this.getMilitaryStatus() + ", maritalStatus=" + this.getMaritalStatus() + ", validDateFrom=" + this.getValidDateFrom() + ", validDateTo=" + this.getValidDateTo() + ", address=" + this.getAddress() + ", contractStatus=" + this.getContractStatus() + ", contractStatusValue=" + this.isContractStatusValue() + ", cerStatus=" + this.getCerStatus() + ", cerStatusValue=" + this.isCerStatusValue() + ", gradeCerStatus=" + this.getGradeCerStatus() + ", gradeCerStatusValue=" + this.isGradeCerStatusValue() + ", cerNo=" + this.getCerNo() + ", gradeLevel=" + this.getGradeLevel() + ", gradeCerNo=" + this.getGradeCerNo() + ", insure=" + this.getInsure() + ", createdTime=" + this.getCreatedTime() + ", domainAdmin=" + this.getDomainAdmin() + ", departAdmin=" + this.getDepartAdmin() + ", manageDeparts=" + this.getManageDeparts() + ", organId=" + this.getOrganId() + ", personStatus=" + this.getPersonStatus() + ", probation=" + this.getProbation() + ", planPositiveDate=" + this.getPlanPositiveDate() + ", emergencyContact=" + this.getEmergencyContact() + ", emergencyPhone=" + this.getEmergencyPhone() + ", licenseLevel=" + this.getLicenseLevel() + ", placeOfNow=" + (Object)((Object)this.getPlaceOfNow()) + ", hiredOperator=" + this.getHiredOperator() + ")";
    }
}

