/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.snapshots;

import com.bcxin.tenant.domain.snapshots.EmployeeImportedItemSnapshot;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class EmployeeImportedResultSnapshot {
    private Collection<BatchImportEmployeeResultItem> result;

    public EmployeeImportedResultSnapshot() {
    }

    public EmployeeImportedResultSnapshot(Collection<BatchImportEmployeeResultItem> result) {
        this.result = result;
    }

    @JsonIgnore
    public int getTotalSuccess() {
        if (CollectionUtils.isEmpty(this.result)) {
            return 0;
        }
        return (int)this.result.stream().filter(ii -> ii.getIsSuccess()).count();
    }

    @JsonIgnore
    public int getTotalFailed() {
        if (CollectionUtils.isEmpty(this.result)) {
            return 0;
        }
        return (int)this.result.stream().filter(ii -> !ii.getIsSuccess()).count();
    }

    public static EmployeeImportedResultSnapshot create(Collection<BatchImportEmployeeResultItem> result) {
        return new EmployeeImportedResultSnapshot(result);
    }

    public Collection<BatchImportEmployeeResultItem> getResult() {
        return this.result;
    }

    public void setResult(Collection<BatchImportEmployeeResultItem> result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmployeeImportedResultSnapshot)) {
            return false;
        }
        EmployeeImportedResultSnapshot other = (EmployeeImportedResultSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<BatchImportEmployeeResultItem> this$result = this.getResult();
        Collection<BatchImportEmployeeResultItem> other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmployeeImportedResultSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<BatchImportEmployeeResultItem> $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    public String toString() {
        return "EmployeeImportedResultSnapshot(result=" + this.getResult() + ")";
    }

    public static class BatchImportEmployeeResultItem {
        private EmployeeImportedItemSnapshot dataItem;
        private Collection<String> invalidLogs = new ArrayList<String>();

        public BatchImportEmployeeResultItem() {
        }

        public BatchImportEmployeeResultItem(EmployeeImportedItemSnapshot dataItem) {
            this.dataItem = dataItem;
        }

        private void addErrorLogs(Collection<String> errorLogs) {
            this.invalidLogs.addAll(errorLogs);
        }

        @JsonIgnore
        public boolean getIsSuccess() {
            return CollectionUtils.isEmpty(this.invalidLogs);
        }

        public static BatchImportEmployeeResultItem create(EmployeeImportedItemSnapshot item, Collection<String> invalidLogs) {
            BatchImportEmployeeResultItem result = new BatchImportEmployeeResultItem(item);
            result.addErrorLogs(invalidLogs);
            return result;
        }

        public EmployeeImportedItemSnapshot getDataItem() {
            return this.dataItem;
        }

        public Collection<String> getInvalidLogs() {
            return this.invalidLogs;
        }

        public void setDataItem(EmployeeImportedItemSnapshot dataItem) {
            this.dataItem = dataItem;
        }

        public void setInvalidLogs(Collection<String> invalidLogs) {
            this.invalidLogs = invalidLogs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BatchImportEmployeeResultItem)) {
                return false;
            }
            BatchImportEmployeeResultItem other = (BatchImportEmployeeResultItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EmployeeImportedItemSnapshot this$dataItem = this.getDataItem();
            EmployeeImportedItemSnapshot other$dataItem = other.getDataItem();
            if (this$dataItem == null ? other$dataItem != null : !((Object)this$dataItem).equals(other$dataItem)) {
                return false;
            }
            Collection<String> this$invalidLogs = this.getInvalidLogs();
            Collection<String> other$invalidLogs = other.getInvalidLogs();
            return !(this$invalidLogs == null ? other$invalidLogs != null : !((Object)this$invalidLogs).equals(other$invalidLogs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BatchImportEmployeeResultItem;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            EmployeeImportedItemSnapshot $dataItem = this.getDataItem();
            result = result * 59 + ($dataItem == null ? 43 : ((Object)$dataItem).hashCode());
            Collection<String> $invalidLogs = this.getInvalidLogs();
            result = result * 59 + ($invalidLogs == null ? 43 : ((Object)$invalidLogs).hashCode());
            return result;
        }

        public String toString() {
            return "EmployeeImportedResultSnapshot.BatchImportEmployeeResultItem(dataItem=" + this.getDataItem() + ", invalidLogs=" + this.getInvalidLogs() + ")";
        }
    }
}

