/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.IdWorker;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.tenant.domain.DomainConstraint;
import com.bcxin.tenant.domain.entities.ExternalGroupEntity;
import com.bcxin.tenant.domain.entities.ExternalMemberEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.ExternalGroupRepository;
import com.bcxin.tenant.domain.repositories.ExternalMemberRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.services.ExternalGroupService;
import com.bcxin.tenant.domain.services.commands.externalGroups.CreateExternalGroupCommand;
import com.bcxin.tenant.domain.services.commands.externalGroups.DeleteExternalGroupCommand;
import com.bcxin.tenant.domain.services.commands.externalGroups.UpdateExternalGroupCommand;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExternalGroupServiceImpl
implements ExternalGroupService {
    private final UnitWork unitWork;
    private final IdWorker idWorker;
    private final ExternalGroupRepository externalGroupRepository;
    private final OrganizationRepository organizationRepository;
    private final ExternalMemberRepository externalMemberRepository;

    public ExternalGroupServiceImpl(UnitWork unitWork, IdWorker idWorker, ExternalGroupRepository externalGroupRepository, OrganizationRepository organizationRepository, ExternalMemberRepository externalMemberRepository) {
        this.unitWork = unitWork;
        this.idWorker = idWorker;
        this.externalGroupRepository = externalGroupRepository;
        this.organizationRepository = organizationRepository;
        this.externalMemberRepository = externalMemberRepository;
    }

    @Override
    public void update(UpdateExternalGroupCommand command) {
        ExternalGroupEntity externalGroup = this.externalGroupRepository.findById(command.getId()).orElse(null);
        if (externalGroup == null) {
            throw new NotFoundTenantException();
        }
        if (!externalGroup.getReferenceNumber().equalsIgnoreCase(command.getReferenceNumber())) {
            throw new ForbidTenantException("\u7981\u6b62\u4fee\u6539\u8be5\u5206\u7ec4\u4fe1\u606f");
        }
        this.assignExternalGroupInfo(externalGroup, command.getPrincipalId(), command.getParentId());
        externalGroup.change(command.getName(), command.getDisplayOrder());
        this.unitWork.executeTran(() -> this.externalGroupRepository.save(externalGroup));
    }

    @Override
    public void create(CreateExternalGroupCommand command) {
        OrganizationEntity organization = this.organizationRepository.findById(command.getReferenceNumber()).orElse(null);
        if (organization == null) {
            throw new NotFoundTenantException(String.format("\u5f53\u524d\u7ec4\u7ec7(%s)\u65e0\u6548", command.getReferenceNumber()));
        }
        String id = String.valueOf(this.idWorker.nextId());
        ExternalGroupEntity externalGroup = ExternalGroupEntity.create(ResourceReferenceType.Organization, organization.getId(), id, command.getName(), command.getDisplayOrder());
        this.assignExternalGroupInfo(externalGroup, command.getPrincipalId(), command.getParentId());
        this.unitWork.executeTran(() -> this.externalGroupRepository.save(externalGroup));
    }

    @Override
    public void delete(DeleteExternalGroupCommand command) {
        ExternalGroupEntity externalGroup = this.externalGroupRepository.findById(command.getId()).orElse(null);
        if (externalGroup == null) {
            throw new NotFoundTenantException();
        }
        if (!externalGroup.getReferenceNumber().equalsIgnoreCase(command.getReferenceNumber())) {
            throw new ForbidTenantException("\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u5206\u7ec4\u4fe1\u606f");
        }
        try {
            this.unitWork.executeTran(() -> this.externalGroupRepository.delete(externalGroup));
        }
        catch (Exception ex) {
            if (DomainConstraint.isRefForeignIssue(ex)) {
                throw new BadTenantException("\u5220\u9664\u8be5\u5206\u7ec4\u4e4b\u524d\u3001\u8bf7\u5148\u5220\u9664\u5b50\u5206\u7ec4\u6216\u8005\u5206\u7ec4\u6210\u5458\u4fe1\u606f");
            }
            throw ex;
        }
    }

    private void assignExternalGroupInfo(ExternalGroupEntity externalGroup, String principalId, String parentId) {
        ExternalMemberEntity externalMember = null;
        if (StringUtils.hasLength((String)principalId)) {
            externalMember = this.externalMemberRepository.findById(principalId).orElse(null);
        }
        externalGroup.assignPrincipal(externalMember);
        ExternalGroupEntity parent = null;
        if (StringUtils.hasLength((String)parentId)) {
            parent = this.externalGroupRepository.findById(parentId).orElse(null);
            if (parent != null && !externalGroup.getReferenceNumber().equalsIgnoreCase(parent.getReferenceNumber())) {
                throw new ArgumentTenantException(String.format("\u6570\u636e(%s)\u65e0\u6548(\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u4e00\u81f4)", parentId));
            }
            externalGroup.assign(parent);
        } else {
            externalGroup.assign(null);
        }
    }
}

