/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.tenant.domain.entities.ContractEntity;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.CompositeDataRepository;
import com.bcxin.tenant.domain.repositories.ContractRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.services.ContractService;
import com.bcxin.tenant.domain.services.commands.contracts.BatchDeleteContractCommand;
import com.bcxin.tenant.domain.services.commands.contracts.BatchImportContractCommand;
import com.bcxin.tenant.domain.services.commands.contracts.CreateContractCommand;
import com.bcxin.tenant.domain.services.commands.contracts.DeleteContractCommand;
import com.bcxin.tenant.domain.services.commands.contracts.UpdateContractCommand;
import com.bcxin.tenant.domain.services.commands.contracts.results.BatchImportContractCommandResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ContractServiceImpl
implements ContractService {
    private final ContractRepository contractRepository;
    private final EmployeeRepository employeeRepository;
    private final OrganizationRepository organizationRepository;
    private final CompositeDataRepository compositeDataRepository;
    private final UnitWork unitWork;
    private final TenantDbReader dbReader;
    private final RetryProvider retryProvider;

    public ContractServiceImpl(ContractRepository contractRepository, EmployeeRepository employeeRepository, OrganizationRepository organizationRepository, CompositeDataRepository compositeDataRepository, UnitWork unitWork, TenantDbReader dbReader, RetryProvider retryProvider) {
        this.contractRepository = contractRepository;
        this.employeeRepository = employeeRepository;
        this.organizationRepository = organizationRepository;
        this.compositeDataRepository = compositeDataRepository;
        this.unitWork = unitWork;
        this.dbReader = dbReader;
        this.retryProvider = retryProvider;
    }

    @Override
    public void dispatch(CreateContractCommand command) {
        command.validate();
        EmployeeEntity employee = this.employeeRepository.getByOrganIdAndId(command.getOrganizationId(), command.getEmployeeId());
        if (employee == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u8be5\u804c\u5458\u4fe1\u606f");
        }
        List<ContractEntity> contractList = this.contractRepository.getByOrganIdAndEmployeeId(command.getOrganizationId(), command.getEmployeeId());
        command.validateExist(contractList);
        this.unitWork.executeTran(() -> {
            ContractEntity contract = ContractEntity.create(employee, command.getName(), command.getAName(), command.getBName(), command.getBeginDate(), command.getEndDate(), command.isDateLimitless());
            contract.changeAttachment(command.getAttachment());
            contract.changeNote(command.getNote());
            contract.assignCreator(AuthUtil.getCurrentOperator());
            contract.assignModifier(AuthUtil.getCurrentOperator());
            this.contractRepository.save((EntityAbstract)contract);
        });
    }

    @Override
    public void dispatch(UpdateContractCommand command) {
        command.validate();
        ContractEntity contract = this.contractRepository.getByOrganIdAndId(command.getOrganizationId(), command.getId());
        if (contract == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5408\u540c\u4fe1\u606f");
        }
        List<ContractEntity> contractList = this.contractRepository.getByOrganIdAndEmployeeId(command.getOrganizationId(), contract.getEmployee().getId());
        command.validateExist(contract.getId(), contractList);
        this.unitWork.executeTran(() -> {
            contract.change(command.getName(), command.getAName(), command.getBName(), command.getNote(), command.getBeginDate(), command.getEndDate(), command.isDateLimitless());
            contract.changeAttachment(command.getAttachment());
            contract.changeNote(command.getNote());
            contract.assignModifier(AuthUtil.getCurrentOperator());
            this.contractRepository.save((EntityAbstract)contract);
        });
    }

    @Override
    public void dispatch(DeleteContractCommand command) {
        command.validate();
        ContractEntity contract = this.contractRepository.getByOrganIdAndId(command.getOrganizationId(), command.getId());
        if (contract == null) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5408\u540c\u4fe1\u606f");
        }
        this.unitWork.executeTran(() -> this.contractRepository.delete((EntityAbstract)contract));
    }

    @Override
    public void dispatch(BatchDeleteContractCommand command) {
        command.validate();
        List<ContractEntity> contracts = this.contractRepository.getByOrganIdAndIds(command.getOrganizationId(), command.getIds());
        if (contracts.size() == 0) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5408\u540c\u4fe1\u606f");
        }
        for (ContractEntity contract : contracts) {
            this.unitWork.executeTran(() -> this.contractRepository.delete((EntityAbstract)contract));
        }
    }

    @Override
    public BatchImportContractCommandResult dispatch(BatchImportContractCommand command) {
        command.validate();
        Optional organizationOptional = this.organizationRepository.findById(command.getOrganizationId());
        if (!organizationOptional.isPresent()) {
            throw new NotFoundTenantException("\u7ec4\u7ec7\u65e0\u6548!");
        }
        OrganizationEntity organization = (OrganizationEntity)((Object)organizationOptional.get());
        Collection idNums = command.getItems().stream().filter(ii -> ii.IsValid()).map(ii -> ii.getData().getIdNum()).collect(Collectors.toList());
        Collection<EmployeeEntity> employeeList = this.employeeRepository.getByIdNums(organization.getId(), idNums);
        if (employeeList.size() == 0) {
            throw new NotFoundTenantException("\u627e\u4e0d\u5230\u5173\u8054\u5458\u5de5\u8bc1\u4ef6\u53f7\u7801\u5458\u5de5\u4fe1\u606f!");
        }
        Map employeeMaps = employeeList.stream().collect(Collectors.toMap(EmployeeEntity::getSelectIdNum, Function.identity()));
        Collection validCommandItems = command.getItems().stream().filter(ii -> ii.IsValid()).collect(Collectors.toList());
        List<ContractEntity> contractList = this.contractRepository.getByOrganIdAndEmployeeIds(organization.getId(), employeeList.stream().map(EmployeeEntity::getId).collect(Collectors.toList()));
        HashMap contractMap = contractList.size() == 0 ? new HashMap() : contractList.stream().collect(Collectors.groupingBy(ii -> ii.getEmployee().getId()));
        this.unitWork.executeTran(() -> validCommandItems.forEach(item -> {
            EmployeeEntity employeeEntity = (EmployeeEntity)((Object)((Object)((Object)employeeMaps.get(item.getData().getIdNum()))));
            if (employeeEntity != null) {
                boolean save = true;
                List contracts = (List)contractMap.get(employeeEntity.getId());
                if (contracts != null && contracts.stream().anyMatch(ii -> item.getBeginDate().getTime() <= ii.getBeginDate().getTime() && item.getEndDate().getTime() >= ii.getBeginDate().getTime() || item.getBeginDate().getTime() <= ii.getEndDate().getTime() && item.getEndDate().getTime() >= ii.getEndDate().getTime() || ii.getBeginDate().getTime() <= item.getBeginDate().getTime() && ii.getEndDate().getTime() >= item.getBeginDate().getTime() || ii.getBeginDate().getTime() <= item.getEndDate().getTime() && ii.getEndDate().getTime() >= item.getEndDate().getTime())) {
                    item.addError("\u5728\u5408\u540c\u6709\u6548\u671f\u5185\u540c\u4e00\u4e2a\u4eba\u53ea\u80fd\u6709\u4e00\u4efd\u5408\u540c");
                    save = false;
                }
                if (save) {
                    ContractEntity contract = ContractEntity.create(employeeEntity, item.getData().getName(), item.getData().getAName(), item.getData().getBName(), item.getBeginDate(), item.getEndDate(), false);
                    contract.assignCreator(AuthUtil.getCurrentOperator());
                    contract.assignModifier(AuthUtil.getCurrentOperator());
                    this.contractRepository.save((EntityAbstract)contract);
                }
            } else {
                item.addError(String.format("\u627e\u4e0d\u5230\u804c\u5458(%s)\u4fe1\u606f", item.getData().getIdNum()));
            }
        }));
        AtomicReference importedDataIdAto = new AtomicReference();
        this.retryProvider.execute(() -> importedDataIdAto.set(this.compositeDataRepository.execute(organization, command)), 10);
        int totalSuccess = (int)command.getItems().stream().filter(ii -> ii.IsValid()).count();
        int totalFailed = (int)command.getItems().stream().filter(ii -> !ii.IsValid()).count();
        return BatchImportContractCommandResult.create((String)importedDataIdAto.get(), totalSuccess, totalFailed, command.getItems().size());
    }
}

