/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.v5.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.tenant.domain.v5.enums.IdCardType;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Table(name="t_user")
@Entity
public class TUserEntity
extends EntityAbstract
implements IAggregate {
    @Id
    private String id;
    @Column(name="name")
    private String name;
    @Column(name="loginno")
    private String loginNo;
    @Column(name="LOGINPWD")
    private String password;
    @Column(name="domainid")
    private String domainId;
    @Column(name="dimission")
    private Integer dimission;
    @Column(name="LEVELS")
    private Integer levels;
    @Column(name="STATUS")
    private Integer status;
    @Column(name="LIAISON_OFFICER")
    private Integer liaisonOfficer;
    @Column(name="TELEPHONEPUBLIC")
    private Integer telephonePublic;
    @Column(name="TELEPHONEPUBLIC2")
    private Integer telephonePublic2;
    @Column(name="EMAILPUBLIC")
    private Integer emailPublic;
    @Column(name="USERINFOPUBLIC")
    private Integer userInfoPublic;
    @Column(name="DEFAULTDEPARTMENT")
    private String defaultDepartId;
    @Column(name="PERMISSION_TYPE")
    private String permissionType;
    @Column(name="field11")
    private String credentialType;
    @Column(name="field12")
    private String credentialNumber;
    @Column(name="ISDOMAINUSER")
    private String domainUser;
    @Column(name="TELEPHONE")
    private String telephone;

    public void change(String name, String loginNo) {
        this.setName(name);
        this.setLoginNo(loginNo);
    }

    public void change(String defaultDepartId, boolean isDomainUser) {
        this.setDomainUser(isDomainUser ? "1" : "0");
        this.setDefaultDepartId(defaultDepartId);
    }

    public void changeNumber(String credentialType, String credentialNumber) {
        this.setCredentialNumber(credentialNumber);
        if (credentialType != null) {
            switch (credentialType) {
                case "IdCard": {
                    this.setCredentialType(IdCardType.IdCard.getText());
                    break;
                }
                case "IdCardOfXiangGang": {
                    this.setCredentialType(IdCardType.IdCardOfXiangGang.getText());
                    break;
                }
                case "IdCardOfAoMen": {
                    this.setCredentialType(IdCardType.IdCardOfAoMen.getText());
                    break;
                }
                case "IdCardOfTaiwan": {
                    this.setCredentialType(IdCardType.IdCardOfTaiwan.getText());
                    break;
                }
                case "Passport": {
                    this.setCredentialType(IdCardType.Passport.getText());
                    break;
                }
                case "Arms": {
                    this.setCredentialType(IdCardType.Arms.getText());
                    break;
                }
                case "PoliceNo": {
                    this.setCredentialType(IdCardType.PoliceNo.getText());
                }
            }
        }
    }

    public void markDeleted() {
        if (this.getDimission() == 1) {
            this.setDimission(0);
        }
    }

    public void markUnDeleted() {
        this.setDimission(1);
    }

    protected TUserEntity() {
        this.setLevels(0);
        this.setStatus(1);
        this.setLiaisonOfficer(1);
        this.setTelephonePublic(1);
        this.setTelephonePublic2(1);
        this.setEmailPublic(1);
        this.setUserInfoPublic(1);
        this.setPermissionType("public");
    }

    public static TUserEntity create(String id, String name, String loginNo, String domainId, String telephone) {
        TUserEntity tUser = new TUserEntity();
        tUser.setId(id);
        tUser.change(name, loginNo);
        tUser.setDomainId(domainId);
        tUser.setDimission(1);
        tUser.setTelephone(telephone);
        tUser.setPassword(String.format("invalid%s", UUID.randomUUID()));
        return tUser;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getLoginNo() {
        return this.loginNo;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public Integer getDimission() {
        return this.dimission;
    }

    public Integer getLevels() {
        return this.levels;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getLiaisonOfficer() {
        return this.liaisonOfficer;
    }

    public Integer getTelephonePublic() {
        return this.telephonePublic;
    }

    public Integer getTelephonePublic2() {
        return this.telephonePublic2;
    }

    public Integer getEmailPublic() {
        return this.emailPublic;
    }

    public Integer getUserInfoPublic() {
        return this.userInfoPublic;
    }

    public String getDefaultDepartId() {
        return this.defaultDepartId;
    }

    public String getPermissionType() {
        return this.permissionType;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getCredentialNumber() {
        return this.credentialNumber;
    }

    public String getDomainUser() {
        return this.domainUser;
    }

    public String getTelephone() {
        return this.telephone;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setLoginNo(String loginNo) {
        this.loginNo = loginNo;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    protected void setDimission(Integer dimission) {
        this.dimission = dimission;
    }

    protected void setLevels(Integer levels) {
        this.levels = levels;
    }

    protected void setStatus(Integer status) {
        this.status = status;
    }

    protected void setLiaisonOfficer(Integer liaisonOfficer) {
        this.liaisonOfficer = liaisonOfficer;
    }

    protected void setTelephonePublic(Integer telephonePublic) {
        this.telephonePublic = telephonePublic;
    }

    protected void setTelephonePublic2(Integer telephonePublic2) {
        this.telephonePublic2 = telephonePublic2;
    }

    protected void setEmailPublic(Integer emailPublic) {
        this.emailPublic = emailPublic;
    }

    protected void setUserInfoPublic(Integer userInfoPublic) {
        this.userInfoPublic = userInfoPublic;
    }

    protected void setDefaultDepartId(String defaultDepartId) {
        this.defaultDepartId = defaultDepartId;
    }

    protected void setPermissionType(String permissionType) {
        this.permissionType = permissionType;
    }

    protected void setCredentialType(String credentialType) {
        this.credentialType = credentialType;
    }

    protected void setCredentialNumber(String credentialNumber) {
        this.credentialNumber = credentialNumber;
    }

    protected void setDomainUser(String domainUser) {
        this.domainUser = domainUser;
    }

    protected void setTelephone(String telephone) {
        this.telephone = telephone;
    }
}

