package com.bcxin.tenant.domain.repository.translates.impls;

import com.alibaba.fastjson.JSON;
import com.bcxin.tenant.domain.readers.dtos.DepartAdminDto;
import com.bcxin.tenant.domain.readers.dtos.MyDepartImContactDto;
import com.bcxin.tenant.domain.readers.dtos.MyImContactDto;
import com.bcxin.tenant.domain.readers.dtos.MyImDepartDto;
import com.bcxin.tenant.domain.repositories.dtos.DepartmentAdminExportDto;
import com.bcxin.tenant.domain.repository.readers.tmps.DepartAdminReadDto;
import com.bcxin.tenant.domain.repository.readers.tmps.DepartmentReadDto;
import com.bcxin.tenant.domain.repository.readers.tmps.EmployeeContactReadDto;
import com.bcxin.tenant.domain.repository.readers.tmps.KeyValueReadDto;
import com.bcxin.tenant.domain.repository.translates.DataTranslate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;
import java.util.stream.Collectors;

@Component
public class DataTranslateImpl implements DataTranslate {
    @Override
    public Collection<MyDepartImContactDto> translate2MyDepartImContacts(Collection<DepartmentReadDto> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        Collection<MyDepartImContactDto> departImContacts = new ArrayList<>();
        data.forEach(ii -> {
            if (!departImContacts.stream().anyMatch(ix -> ix.getId().equals(ii.getId()))) {
                MyDepartImContactDto myDepartImContactDto = MyDepartImContactDto.create(ii.getId(), ii.getName(), ii.getParentId(), ii.getDisplayOrder());
                departImContacts.add(myDepartImContactDto);

//                data.stream().filter(contact -> contact.getId().equals(ii.getId())).forEach(contact -> {
//                    myDepartImContactDto.addContact(MyDepartImContactDto.ImContactItem.create(contact.getUserId(), contact.getUserName(),
//                            contact.getUserSex(), contact.getUserHeadPhoto(), contact.getUserTelephone(), contact.getUserImIdentity()));
//                });
            }
        });

        return departImContacts;
    }

    @Override
    public Collection<MyImDepartDto> translate2MyImDeparts(Collection<DepartmentReadDto> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        Collection<MyImDepartDto> departs = new ArrayList<>();
        data.forEach(ii -> {
            if (!departs.stream().anyMatch(ix -> ix.getId().equals(ii.getId()))) {
                MyImDepartDto myImDepartDto = MyImDepartDto.create(ii.getId(), ii.getName(), ii.getParentId(), ii.getDisplayOrder());
                departs.add(myImDepartDto);
            }
        });

        return departs;
    }

    @Override
    public Collection<MyImContactDto> translate2MyImContacts(Collection<EmployeeContactReadDto> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Collections.EMPTY_LIST;
        }
        Collection<MyImContactDto> contacts = new ArrayList<>();
        data.forEach(ii -> {
            if (!contacts.stream().anyMatch(ix -> ix.getId().equals(ii.getId()))) {
                MyImContactDto myImContactDto = MyImContactDto.create(ii.getId(), ii.getEmpId(), ii.getName(),
                        ii.getSex(), ii.getHeadPhoto(), ii.getTelephone(), ii.getImIdentity());
                contacts.add(myImContactDto);
            }
        });

        return contacts;
    }

    @Override
    public Collection<DepartAdminDto> translate2DepartAdmins(Collection<DepartAdminReadDto> departAdminReads) {
        /**
         * 构造管理员数据
         */
        Collection<DepartAdminDto> wholeDepartAdmins = new ArrayList<>();
        Map<String,List<DepartAdminReadDto>> employeeMaps = departAdminReads.stream().collect(Collectors.groupingBy(DepartAdminReadDto::getEmployeeId));
        for (DepartAdminReadDto readDto : departAdminReads) {
            Optional<DepartAdminDto> selectedDepartAdminOptional = wholeDepartAdmins.stream().filter(ii -> ii.getEmployeeId().equals(readDto.getEmployeeId()))
                    .findFirst();
            if (!selectedDepartAdminOptional.isPresent()) {
                String departName =  employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getDepartName).distinct().collect(Collectors.joining(","));
                String manangeDepartName = employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getManagedDepartName).distinct().collect(Collectors.joining(","));
                wholeDepartAdmins.add(DepartAdminDto.create(readDto.getEmployeeId(),readDto.getUserName(), readDto.getUserTelephone(),departName,manangeDepartName));
            }
        }

        return wholeDepartAdmins;
    }

    @Override
    public List<DepartmentAdminExportDto> translate2DepartExportAdmins(Collection<DepartAdminReadDto> departAdminReads) {
        /**
         * 构造导出管理员数据
         */
        List<DepartmentAdminExportDto> wholeDepartAdmins = new ArrayList<>();
        Map<String,List<DepartAdminReadDto>> employeeMaps = departAdminReads.stream().collect(Collectors.groupingBy(DepartAdminReadDto::getEmployeeId));
        for (DepartAdminReadDto readDto : departAdminReads) {
            Optional<DepartmentAdminExportDto> selectedDepartAdminOptional = wholeDepartAdmins.stream().filter(ii -> ii.getEmployeeId().equals(readDto.getEmployeeId()))
                    .findFirst();
            if (!selectedDepartAdminOptional.isPresent()) {
                String departName =  employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getDepartName).distinct().collect(Collectors.joining(","));
                String manangeDepartName = employeeMaps.get(readDto.getEmployeeId()).stream().map(DepartAdminReadDto::getManagedDepartName).distinct().collect(Collectors.joining(","));
                wholeDepartAdmins.add(DepartmentAdminExportDto.create(readDto.getEmployeeId(),readDto.getUserName(), readDto.getUserTelephone(),departName,manangeDepartName));
            }
        }

        return wholeDepartAdmins;
    }


}
