package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.SuperviseDepartmentEntity;
import com.bcxin.tenant.domain.repositories.SuperviseDepartmentRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface SuperviseDepartmentJpaRepository extends SuperviseDepartmentRepository, JpaRepository<SuperviseDepartmentEntity, Long> {


    @Query("select t from SuperviseDepartmentEntity t where t.status = '启用' and t.regionId like CONCAT(:regionStartWith,'%') ")
    List<SuperviseDepartmentEntity> findByRegionIdStartWith(@Param("regionStartWith") String regionStartWith);

    @Query(value = "select t.* from t_supervise_department t where t.status = '启用' and (t.region_id like CONCAT(:regionStartWith,'%') or t.region_id='000000' ) and (FIND_IN_SET(:industryCode, t.industry_code) > 0 or t.industry_code is null or t.industry_code = '')", nativeQuery = true)
    List<SuperviseDepartmentEntity> findByRegionIdStartWithAndIndustryCode(@Param("regionStartWith") String regionStartWith, @Param("industryCode") String industryCode);

}
