package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.Infrastructures.enums.RelationshipsStatus;
import com.bcxin.tenant.domain.entities.OrganizationRelationshipEntity;
import com.bcxin.tenant.domain.repositories.OrganizationRelationshipRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationRelationshipInfoDto;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface OrganizationRelationshipJpaRepository  extends OrganizationRelationshipRepository,JpaRepository<OrganizationRelationshipEntity,Long> {

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.OrganizationRelationshipInfoDto(o.id,o.parentId,o.parentName," +
            "o.selectedOrganizationId,o.selectedOrganizationName,o.selectedOrganizationNote," +
            "o.code,o.contactName,o.contactTelephone," +
            "t.id,t.name,t.note,t.organizationId," +
            "o.relationshipIndexTree,o.status,o.lastReplyNote,o.lastReplyEmployeeId,o.lastReplyEmployeeName,o.lastReplyTime," +
            "o.organizationId,o.inviteType," +
            "s.id,s.unifySocialCreditCode,s.countOfMembers" +
            ") "+
            " from OrganizationRelationshipEntity o left join o.organizationType as t "+
            " LEFT JOIN OrganizationStatisticsReportEntity s on o.selectedOrganizationId = s.id" +
            " where o.id=?1 ")
    OrganizationRelationshipInfoDto getRelationshipDetailById(long id);


    OrganizationRelationshipEntity findById(long id);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.OrganizationRelationshipInfoDto(o.id,o.parentId,o.parentName," +
            "o.selectedOrganizationId,o.selectedOrganizationName,o.selectedOrganizationNote," +
            "o.code,o.contactName,o.contactTelephone," +
            "t.id,t.name,t.note,t.organizationId," +
            "o.relationshipIndexTree,o.status,o.lastReplyNote,o.lastReplyEmployeeId,o.lastReplyEmployeeName,o.lastReplyTime," +
            "o.organizationId,o.inviteType," +
            "s.id,s.unifySocialCreditCode,s.countOfMembers" +
            ") "+
            " from OrganizationRelationshipEntity o left join o.organizationType as t "+
            " left join  OrganizationStatisticsReportEntity s on o.selectedOrganizationId = s.id " +
            " where o.organizationId = ?1 and o.status in ?2 and o.isDeleted = false")
    Collection<OrganizationRelationshipInfoDto> getOrganizationRelationshipsInfo(String organizationId, Collection<RelationshipsStatus> Statuses);


    Collection<OrganizationRelationshipEntity> findByOrganizationIdAndSelectedOrganizationId(String organizationId, String selectedOrganizationId);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto(o.id,o.parentName,s.unifySocialCreditCode) " +
            " from OrganizationRelationshipEntity o " +
            " left join CompanyEntity s on o.parentId = s.id" +
            " where o.selectedOrganizationId = ?1 and o.isDeleted = false")
    Collection<OrgRelationDto> getParentList(String organizationId);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto(o.id,o.selectedOrganizationName,s.unifySocialCreditCode) " +
            " from OrganizationRelationshipEntity o " +
            " left join CompanyEntity s on o.selectedOrganizationId = s.id" +
            " where o.parentId = ?1 and o.isDeleted = false")
    Collection<OrgRelationDto> getChildrenList(String organizationId);
}
