package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.OrganizationPartnerEntity;
import com.bcxin.tenant.domain.repositories.OrganizationPartnerRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.Collection;

/**
 * description: 组织合作伙伴JPA Repository实现
 * author: system
 * date: 2024-01-01
 */
public interface OrganizationPartnerJpaRepository extends OrganizationPartnerRepository, JpaRepository<OrganizationPartnerEntity, String> {
    
    /**
     * 根据申请方组织ID查询（未删除的记录）
     * @param applicantOrganizationId 申请方组织ID
     * @return 合作伙伴列表
     */
    @Query("select u from OrganizationPartnerEntity u where u.applicantOrganizationId = :applicantOrganizationId and (u.isDeleted = false or u.isDeleted is null)")
    Collection<OrganizationPartnerEntity> findByApplicantOrganizationIdAndIsDeletedFalse(@Param("applicantOrganizationId") String applicantOrganizationId);
    
    /**
     * 根据邀请码查询（未删除的记录）
     * @param invitationCode 邀请码
     * @return 合作伙伴实体
     */
    @Query("select u from OrganizationPartnerEntity u where u.invitationCode = :invitationCode and (u.isDeleted = false or u.isDeleted is null)")
    OrganizationPartnerEntity findByInvitationCodeAndIsDeletedFalse(@Param("invitationCode") String invitationCode);
}

