package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationAdminiInfoDto;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationDto;
import com.bcxin.tenant.domain.repositories.dtos.TenantUserRepositoryDto;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;
import java.util.List;


public interface OrganizationJpaRepository extends OrganizationRepository, JpaRepository<OrganizationEntity,String> {
    boolean existsByName(String name);

    @Query("select " +
            "new com.bcxin.tenant.domain.repositories.dtos.OrganizationDto(u.id,u.code, u.name,u.placeOfRegister,u.placeOfBusiness,u.industryCode,u.institutionalCode,u.logoPath,u.sysName,u.description,u.longitude,u.latitude,u.createdTime,u.lastUpdatedTime,c.unifySocialCreditCode,c.unifySocialCreditCodeFile,u.lonLatJson) " +
            "from OrganizationEntity u left join CompanyEntity c on c.id = u.id where u.id=?1")
    OrganizationDto getDtoById(String id);

    @Query("select   new com.bcxin.tenant.domain.repositories.dtos.TenantUserRepositoryDto(u.id,u.telephone,u.name)\n" +
            "from OrganizationEntity o\n" +
            "left JOIN EmployeeEntity e on o.id=e.organization.id\n" +
            "left JOIN  TenantUserEntity u on e.tenantUser.id=u.id\n" +
            "where o.approvedInformationValueType.status =?3 and e.domainAdmin=?2 and o.id=?1" )
    Collection<TenantUserRepositoryDto> getOrganization(String id, TrueFalseStatus domainAdmin, ApprovedStatus status);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.OrganizationAdminiInfoDto(e.id,t.name,t.id,t.telephone) " +
            "from EmployeeEntity e join e.tenantUser t " +
            " where e.organization.id = ?1 and e.status = 0 and e.domainAdmin = 1"
            )
    Collection<OrganizationAdminiInfoDto> getOrganizationAdminInfo(String organizationId);

    @Query("select o from OrganizationEntity o where o.id in (?1)")
    Collection<OrganizationEntity> getByIds(Collection<String> ids);
}
