package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.OrganizationInvitationCodeEntity;
import com.bcxin.tenant.domain.repositories.OrganizationInvitationCodeRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

/**
 * description: 组织邀请码JPA Repository实现
 * author: system
 * date: 2024-01-01
 */
public interface OrganizationInvitationCodeJpaRepository extends OrganizationInvitationCodeRepository, JpaRepository<OrganizationInvitationCodeEntity, String> {
    
    /**
     * 根据邀请码查询（未删除的记录）
     * @param invitationCode 邀请码
     * @return 邀请码实体
     */
    @Query("select u from OrganizationInvitationCodeEntity u where u.invitationCode = :invitationCode and (u.isDeleted = false or u.isDeleted is null)")
    OrganizationInvitationCodeEntity findByInvitationCodeAndIsDeletedFalse(@Param("invitationCode") String invitationCode);
}

