package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.OrganizationAdminEntity;
import com.bcxin.tenant.domain.repositories.OrganizationAdminRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface OrganizationAdminJpaRepository extends OrganizationAdminRepository, JpaRepository<OrganizationAdminEntity,String> {

    @Query("select o from OrganizationAdminEntity o where o.organization.id=?1 and o.id in (?2)")
    Collection<OrganizationAdminEntity> getByIds(String organizationId, Collection<String> ids);

    @Query("select o from OrganizationAdminEntity o where o.organization.id=?1 and o.employee.id in (?2)")
    Collection<OrganizationAdminEntity> getByEmployeeIds(String organizationId, Collection<String> employeeIds);
}
