package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.OrgRelationEntity;
import com.bcxin.tenant.domain.repositories.OrgRelationRepository;
import com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

/**
 * @author linqinglin
 * @date 2021/12/10 0010 14:51
 */
public interface OrgRelationJpaRepository extends OrgRelationRepository, JpaRepository<OrgRelationEntity,String> {

    @Query("select " +
            "new com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto(u.id,a.name,c.unifySocialCreditCode) " +
            "from OrgRelationEntity u left join OrganizationEntity a on u.parentOrg.id = a.id left join CompanyEntity c on c.id = a.id where u.organization.id=?1 and u.relationStatus = com.bcxin.Infrastructures.enums.OrgRelationStatus.BIND")
    Collection<OrgRelationDto> getParentList(String organizationId);

    @Query("select " +
            "new com.bcxin.tenant.domain.repositories.dtos.OrgRelationDto(u.id,a.name,c.unifySocialCreditCode) " +
            "from OrgRelationEntity u left join OrganizationEntity a on u.organization.id = a.id left join CompanyEntity c on c.id = a.id where u.parentOrg.id=?1 and u.relationStatus = com.bcxin.Infrastructures.enums.OrgRelationStatus.BIND")
    Collection<OrgRelationDto> getChildrenList(String organizationId);

    @Query("select u from OrgRelationEntity u where u.organization.id=?1 and u.parentOrg.id=?2 and u.relationStatus = com.bcxin.Infrastructures.enums.OrgRelationStatus.BIND")
    OrgRelationEntity findByOrgId(String organizationId,String parentOrgId);

}
