package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.Infrastructures.enums.ResourceReferenceType;
import com.bcxin.tenant.domain.entities.ExternalMemberEntity;
import com.bcxin.tenant.domain.repositories.ExternalMemberRepository;
import com.bcxin.tenant.domain.repositories.dtos.ExternalMemberDTO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;
import java.util.Optional;

public interface ExternalMemberJpaRepository extends ExternalMemberRepository, JpaRepository<ExternalMemberEntity,String> {

    @Query("select u from ExternalMemberEntity u where u.id in (?1)")
    Collection<ExternalMemberEntity> getByIds(Collection<String> ids);

    @Query("select u from ExternalMemberEntity u where u.tenantUser.id=?1 and u.referenceNumber=?2 and u.referenceType=?3")
    ExternalMemberEntity getByTenantUserIdAndRefNumAndRefType(String tenantUserId, String refNum, ResourceReferenceType refType);

    @Query("select u.id from ExternalMemberEntity u where u.referenceNumber=?1 and u.referenceType=com.bcxin.Infrastructures.enums.ResourceReferenceType.Organization and u.memberType= com.bcxin.Infrastructures.enums.MemberType.Master")
    Collection<String> getAdminIds(String orgId);
}
