package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.ExternalGroupEntity;
import com.bcxin.tenant.domain.repositories.ExternalGroupRepository;
import com.bcxin.tenant.domain.repositories.dtos.ExternalGroupDTO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.Collection;

public interface ExternalGroupJpaRepository extends ExternalGroupRepository, JpaRepository<ExternalGroupEntity,String> {

    @Query("select u from ExternalGroupEntity u where u.id in (?1)")
    Collection<ExternalGroupEntity> getByIds(Collection<String> ids);

    @Query("select new com.bcxin.tenant.domain.repositories.dtos.ExternalGroupDTO(u.id,u.name,0,u.displayOrder,u.parent.id,u.parent.id) from ExternalGroupEntity u where u.referenceNumber = (?1) ")
    Collection<ExternalGroupDTO> getAll(String organizationId);
}
