package com.bcxin.tenant.domain.repository.impls;

import com.bcxin.tenant.domain.entities.EmployeeEventEntity;
import com.bcxin.tenant.domain.enums.EmployeeEventType;
import com.bcxin.tenant.domain.repositories.EmployeeEventRepository;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.ArrayList;
import java.util.Collection;

public interface EmployeeEventJpaRepository extends EmployeeEventRepository, JpaRepository<EmployeeEventEntity,String> {
    @Query("select e from EmployeeEventEntity e  where e.employee.id = ?1 and e.eventType = ?2  order by  e.eventTime desc ")
    ArrayList<EmployeeEventEntity> getLatelyByIdAndType(String id, EmployeeEventType type);
}
